/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.core.condition;

import com.nxp.s32ds.cle.cdt.sdk.condition.Condition;
import com.nxp.s32ds.cle.cdt.sdk.condition.ConditionCheck;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.condition.ConditionCheckConfigurations;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.condition.ConditionCheckCores;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.condition.ConditionCheckCoresEnabled;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.condition.ConditionCheckDebugger;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.condition.ConditionCheckMulticoreProject;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConditionImpl
implements Condition {
    private final String id;
    private final Set<ConditionCheck> conditionChecks;

    public ConditionImpl(Element conditionElement) {
        this.id = conditionElement.getAttribute("id");
        this.conditionChecks = new HashSet<ConditionCheck>();
        this.initialize(conditionElement);
    }

    public String getId() {
        return this.id;
    }

    public boolean check(Object checkCondition) {
        boolean[] result = new boolean[]{true};
        this.conditionChecks.forEach(conditionCheck -> {
            boolean bl = result[0] & conditionCheck.check(checkCondition);
        });
        return result[0];
    }

    public void convertToXml(Document document, Element holderElement) {
        if ("conditions".equals(holderElement.getNodeName())) {
            Element conditionElement = document.createElement("condition");
            conditionElement.setAttribute("id", this.getId());
            this.conditionChecks.forEach(subCondition -> subCondition.convertToXml(document, conditionElement));
            holderElement.appendChild(conditionElement);
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.conditionChecks == null ? 0 : this.conditionChecks.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConditionImpl)) {
            return false;
        }
        ConditionImpl other = (ConditionImpl)obj;
        return !(this.conditionChecks == null ? other.conditionChecks != null : !this.conditionChecks.equals(other.conditionChecks));
    }

    private void initialize(Element conditionElement) {
        NodeList nodeList = conditionElement.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if ("check".equals(node.getNodeName()) && node instanceof Element) {
                Element checkElement = (Element)node;
                if (checkElement.hasAttribute("multicoreProject")) {
                    this.conditionChecks.add(new ConditionCheckMulticoreProject(checkElement));
                }
                if (checkElement.hasAttribute("configurations")) {
                    this.conditionChecks.add(new ConditionCheckConfigurations(checkElement));
                }
                if (checkElement.hasAttribute("cores")) {
                    this.conditionChecks.add(new ConditionCheckCores(checkElement));
                }
                if (checkElement.hasAttribute("coresEnabled")) {
                    this.conditionChecks.add(new ConditionCheckCoresEnabled(checkElement));
                }
                if (checkElement.hasAttribute("debuggers")) {
                    this.conditionChecks.add(new ConditionCheckDebugger(checkElement));
                }
            }
            ++i;
        }
    }
}

