/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.core.environment;

import com.nxp.s32ds.cle.cdt.sdk.core.load.ExternalSdkLoader;
import com.nxp.s32ds.cle.cdt.sdk.core.load.InternalSdkLoader;
import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkManagementUtils;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.SdkCoreActivator;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkType;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.environment.EnvironmentSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.environment.EnvironmentSdkDescriptor;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.IValueVariable;
import org.eclipse.core.variables.IValueVariableListener;
import org.eclipse.core.variables.VariablesPlugin;

public class SdkEnvironmentVariableChangeListener
implements IValueVariableListener {
    private static final IStringVariableManager SVM = VariablesPlugin.getDefault().getStringVariableManager();

    public void variablesRemoved(IValueVariable[] variables) {
        for (SdkDescriptor sdkDescriptor : SdkManagementUtils.getFilteredSdks(sdk -> true)) {
            EnvironmentSdkDescriptor sdkEnvironment = EnvironmentSdkDescriptors.getEnvironmentSdkDescriptorBySdkId((String)sdkDescriptor.getId());
            if (sdkEnvironment == null) {
                return;
            }
            String sdkEnvironmentName = sdkEnvironment.getName();
            Arrays.stream(variables).filter(valueVariable -> valueVariable.getName().equals(sdkEnvironmentName)).forEach(this::handleRemoveVariable);
        }
    }

    public void variablesChanged(IValueVariable[] variables) {
        Map<String, String> sdksDescriptorsPaths = ExternalSdkLoader.getSdksDescriptors();
        IValueVariable[] iValueVariableArray = variables;
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            IValueVariable variable = iValueVariableArray[n2];
            String variableName = "${" + variable.getName() + "}";
            List<SdkDescriptor> filteredSdks = SdkManagementUtils.getFilteredSdks(sdk -> SdkType.EXTERNAL == sdk.getType() && sdk.getBasePath().contains(variableName));
            SdkEnvironmentVariableChangeListener.handleChangeVariable(variableName, filteredSdks, sdksDescriptorsPaths);
            ++n2;
        }
    }

    public void variablesAdded(IValueVariable[] variables) {
    }

    private void handleRemoveVariable(IValueVariable valueVariable) {
        try {
            SVM.addVariables(new IValueVariable[]{valueVariable});
            SdkCoreActivator.getInstance().logWarning(String.format("Attempt to remove SDK variable %s - restored.", valueVariable.getName()));
        }
        catch (CoreException ce) {
            SdkCoreActivator.getInstance().logError(String.format("Error while handle removing variable %s", valueVariable.getName()), ce);
        }
    }

    private static void handleChangeVariable(String variableName, List<SdkDescriptor> filteredSdks, Map<String, String> sdksDescriptorsPaths) {
        boolean isUpdatePersistentSdks = false;
        for (SdkDescriptor sdk : filteredSdks) {
            String sdkBasePath = sdk.getBasePath();
            String substitutedSdkBasePath = SdkManagementUtils.performStringSubstitution(sdkBasePath, variableName);
            try {
                String resolvedSdkBasePath = SVM.performStringSubstitution(sdk.getBasePath());
                if (resolvedSdkBasePath.equals(substitutedSdkBasePath)) continue;
                String descriptorFilePath = sdksDescriptorsPaths.get(sdk.getId());
                if (descriptorFilePath != null && !descriptorFilePath.isEmpty()) {
                    ExternalSdkLoader.reloadSdkFromDescriptorFile(sdk, descriptorFilePath, sdk.isLoadedByUser());
                }
                isUpdatePersistentSdks = true;
            }
            catch (CoreException coreException) {}
        }
        if (isUpdatePersistentSdks) {
            InternalSdkLoader.updatePersistedInternalSdks();
        }
    }
}

