/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.core.load.fragment;

import com.nxp.s32ds.cle.cdt.sdk.internal.core.load.fragment.DummyFragment;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.load.fragment.FragmentDefinition;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.load.fragment.FragmentReference;
import java.util.Collection;
import java.util.Collections;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class Fragment {
    public static final String FRAGMENT_ELEMENT = "fragment";
    public static final String FRAGMENTREF_ELEMENT = "fragmentRef";
    public static final String ID_ATTRIBUTE = "id";
    public static final String NAME_ATTRIBUTE = "name";
    protected String id;
    protected String name;

    protected Fragment(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public static Fragment create(Element element) {
        switch (element.getNodeName()) {
            case "fragment": {
                return new FragmentDefinition(element);
            }
            case "fragmentRef": {
                return new FragmentReference(element);
            }
        }
        return new DummyFragment(element.getAttribute(NAME_ATTRIBUTE));
    }

    public void convertToXml(Document document, Element holderElement) {
        Element fragmentElement = document.createElement(this.getFragmentElementName());
        fragmentElement.setAttribute(ID_ATTRIBUTE, this.getId());
        fragmentElement.setAttribute(NAME_ATTRIBUTE, this.getName());
        holderElement.appendChild(fragmentElement);
    }

    public Collection<Element> getFragmentElements() {
        return Collections.emptyList();
    }

    protected abstract String getFragmentElementName();

    public boolean isDummy() {
        return false;
    }

    public String getId() {
        return this.id != null ? this.id : "";
    }

    public String getName() {
        return this.name != null ? this.name : "";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Fragment other = (Fragment)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

