/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.core.load.fragment;

import com.nxp.s32ds.cle.cdt.sdk.core.validators.SdkFragmentValidator;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.load.fragment.DummyFragment;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.load.fragment.Fragment;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.load.fragment.FragmentDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FragmentsHolder {
    public static final String FRAGMENTS_ELEMENT = "fragments";
    private Map<String, Fragment> fragments = new HashMap<String, Fragment>();
    private Map<IStatus, List<Fragment>> invalidFragments = new HashMap<IStatus, List<Fragment>>();
    private SdkFragmentValidator sdkFragmentValidator = new SdkFragmentValidator();

    public FragmentsHolder() {
    }

    public FragmentsHolder(Element element) {
        this.initialize(element);
    }

    public Map<String, Fragment> getFragments() {
        return this.fragments;
    }

    public Fragment getFragment(String id) {
        Fragment sdkFragment = this.fragments.get(id);
        return sdkFragment != null ? sdkFragment : new DummyFragment("");
    }

    public Map<IStatus, List<Fragment>> getInvalidFragments() {
        return this.invalidFragments;
    }

    public boolean containsFragment(Fragment fragment) {
        return fragment instanceof FragmentDefinition && this.fragments.containsKey(((FragmentDefinition)fragment).getId());
    }

    public void addFragment(Fragment fragment) {
        if (fragment instanceof FragmentDefinition) {
            this.fragments.put(((FragmentDefinition)fragment).getId(), fragment);
        }
    }

    public static FragmentsHolder emptyHolder() {
        return new FragmentsHolder();
    }

    private void initialize(Element element) {
        NodeList fragmentsElements = element.getElementsByTagName(FRAGMENTS_ELEMENT);
        int i = 0;
        while (i < fragmentsElements.getLength()) {
            Element fragmentsElement = (Element)fragmentsElements.item(i);
            if (element.equals(fragmentsElement.getParentNode())) {
                NodeList fragmentElements = fragmentsElement.getElementsByTagName("fragment");
                int j = 0;
                while (j < fragmentElements.getLength()) {
                    FragmentDefinition sdkFragmentDefinition;
                    Fragment sdkFragment = Fragment.create((Element)fragmentElements.item(j));
                    if (sdkFragment instanceof FragmentDefinition && this.validateFragment(sdkFragmentDefinition = (FragmentDefinition)sdkFragment).isOK()) {
                        this.fragments.put(sdkFragmentDefinition.getId(), sdkFragmentDefinition);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private IStatus validateFragment(FragmentDefinition sdkFragmentDefinition) {
        IStatus fragmentValiadtionStatus = this.sdkFragmentValidator.validate(sdkFragmentDefinition);
        if (!fragmentValiadtionStatus.isOK()) {
            this.invalidFragments.computeIfAbsent(fragmentValiadtionStatus, s -> new ArrayList()).add(sdkFragmentDefinition);
            return fragmentValiadtionStatus;
        }
        String sdkFragmentDefinitionId = sdkFragmentDefinition.getId();
        if (this.fragments.containsKey(sdkFragmentDefinitionId)) {
            fragmentValiadtionStatus = new Status(4, "com.nxp.s32ds.cle.cdt.sdk.core", NLS.bind((String)"Fragment with id {0} already exists", (Object)sdkFragmentDefinitionId));
            this.invalidFragments.computeIfAbsent(fragmentValiadtionStatus, s -> new ArrayList()).add(sdkFragmentDefinition);
            return fragmentValiadtionStatus;
        }
        return Status.OK_STATUS;
    }
}

