/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.debug.ka.osek;

import com.freescale.s32ds.debug.ka.osek.OsekPlugin;
import com.freescale.s32ds.debug.ka.osek.utils.OrtiImageResources;
import java.text.DateFormat;
import java.util.Date;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class OsekConsoleLogger {
    public static final String OSEK_CONSOLE_NAME = "OSEK";
    private MessageConsole m_console;
    private MessageConsoleStream m_consoleStream;

    private void CreateConsole() {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] consoles = conMan.getConsoles();
        int i = 0;
        while (i < consoles.length) {
            if (consoles[i].getName().equals(OSEK_CONSOLE_NAME)) {
                return;
            }
            ++i;
        }
        Image osekConsoleIcon = null;
        try {
            osekConsoleIcon = OrtiImageResources.GetImage(OrtiImageResources.ImageType.OsekLogo);
        }
        catch (Exception e) {
            OsekPlugin.log(e);
        }
        this.m_console = new MessageConsole(OSEK_CONSOLE_NAME, ImageDescriptor.createFromImage((Image)osekConsoleIcon));
        conMan.addConsoles(new IConsole[]{this.m_console});
        conMan.showConsoleView((IConsole)this.m_console);
        this.m_consoleStream = this.m_console.newMessageStream();
    }

    public synchronized void logMessage(String message) {
        if (this.m_console == null) {
            this.CreateConsole();
        }
        try {
            DateFormat df = DateFormat.getTimeInstance(2);
            this.m_consoleStream.println(String.format("[%s]%s", df.format(new Date()), message));
            this.m_consoleStream.flush();
        }
        catch (Exception e) {
            OsekPlugin.log(e);
        }
    }
}

