/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.modular.internal;

import com.nxp.s32ds.ext.rcp.compatibility.data.registry.Archetype;
import com.nxp.s32ds.ext.rcp.compatibility.data.registry.CompatibilitiesDataDescriptor;
import com.nxp.s32ds.ext.rcp.compatibility.data.registry.CompatibilitiesDataRegistry;
import com.nxp.s32ds.ext.rcp.compatibility.data.registry.core.CompatibilitiesData;
import com.nxp.s32ds.rcp.modular.ModularPackageCompatibleCategoryRegistry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ModularPackageCompatibleCategoryRegistryImplementation
implements ModularPackageCompatibleCategoryRegistry {
    private HashMap<String, Set<String>> category2ModularPackagesId = new HashMap();
    private static Predicate<CompatibilitiesDataDescriptor> categoryAttributeFilterPredicate = new Predicate<CompatibilitiesDataDescriptor>(){

        @Override
        public boolean test(CompatibilitiesDataDescriptor compatibilitiesDataDescriptor) {
            if (compatibilitiesDataDescriptor.getAttributes().isEmpty()) {
                return false;
            }
            return compatibilitiesDataDescriptor.getAttributes().stream().filter(attr -> "com.nxp.s32ds.pack.category".equals(attr.getName())).findFirst().map(Objects::nonNull).orElse(false);
        }
    };

    ModularPackageCompatibleCategoryRegistryImplementation() {
        this.extractCompatibleCategories();
    }

    @Override
    public void add(String category, String modularPackageId) {
        Set<String> set = this.category2ModularPackagesId.get(category);
        if (set == null) {
            set = new HashSet<String>();
            set.add(modularPackageId);
            this.category2ModularPackagesId.put(category, set);
        } else {
            set.add(modularPackageId);
        }
    }

    @Override
    public Set<String> getAllCategories() {
        return this.category2ModularPackagesId.keySet();
    }

    @Override
    public void clear() {
        this.category2ModularPackagesId.clear();
    }

    @Override
    public Set<String> getCategoriesByModularPackageId(String id) {
        return this.category2ModularPackagesId.entrySet().stream().filter(pair -> ((Set)pair.getValue()).contains(id)).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private void extractCompatibleCategories() {
        CompatibilitiesDataRegistry compatibilitiesDataRegistry = CompatibilitiesData.getCompatibilitiesDataRegistry();
        HashMap map = new HashMap();
        Archetype arch = compatibilitiesDataRegistry.getAllArchetypes().stream().filter(this.filterArchetype()).findFirst().orElse(null);
        if (arch == null) {
            return;
        }
        compatibilitiesDataRegistry.getCompatibilitiesDataDescriptorForArchetype(arch).stream().filter(categoryAttributeFilterPredicate::test).forEach(dataDescriptor -> {
            CompatibilitiesDataDescriptor compatibilitiesDataDescriptor = map.merge(dataDescriptor.getId(), dataDescriptor, (previous, current) -> this.getLatestVersionOfDataDescriptor((CompatibilitiesDataDescriptor)previous, (CompatibilitiesDataDescriptor)current));
        });
        map.entrySet().forEach(dataDescriptor -> ((CompatibilitiesDataDescriptor)dataDescriptor.getValue()).getAttributes().forEach(attr -> this.add(attr.getValue(), (String)dataDescriptor.getKey())));
    }

    private Predicate<Archetype> filterArchetype() {
        return a -> "s32ds.archetypes.mi.packs".equals(a.getId());
    }

    private CompatibilitiesDataDescriptor getLatestVersionOfDataDescriptor(CompatibilitiesDataDescriptor previous, CompatibilitiesDataDescriptor current) {
        if (previous.getVersion().compareTo(current.getVersion()) < 0) {
            return current;
        }
        return previous;
    }
}

