/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.hardware.debugger.core;

import com.nxp.s32ds.cle.runtime.hardware.debugger.CoreDebuggerDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.debugger.CoreDebuggerRegistry;
import com.nxp.s32ds.cle.runtime.hardware.debugger.DebuggerCondition;
import com.nxp.s32ds.cle.runtime.hardware.debugger.DeviceCoreDebuggerDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.debugger.DeviceCoreDebuggerRegistry;
import com.nxp.s32ds.cle.runtime.hardware.debugger.DeviceDebuggerDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.debugger.DeviceDebuggerRegistry;
import com.nxp.s32ds.cle.runtime.hardware.debugger.HardwareDebuggerDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.internal.debugger.core.HardwareDebuggerCoreActivator;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DeviceCoreDebuggerDescriptors {
    public static DeviceCoreDebuggerRegistry getDeviceCoreDebuggerRegistry() {
        DeviceCoreDebuggerRegistry deviceCoresRegistry = HardwareDebuggerCoreActivator.getInstance().getDeviceCoresDebuggerRegistry();
        return deviceCoresRegistry;
    }

    public static String getInitScript(String deviceCoreId, String debuggerId) {
        List debuggerDescriptors = DeviceCoreDebuggerDescriptors.getDeviceCoreDebuggerRegistry().getDeviceCoreDebuggerDescriptorsByDeviceCoreId(deviceCoreId);
        for (DeviceCoreDebuggerDescriptor debugerDescriptor : debuggerDescriptors) {
            if (!debugerDescriptor.getDebuggerId().equals(debuggerId)) continue;
            return debugerDescriptor.getInitScript();
        }
        return "";
    }

    public static String getServerPort(String deviceCoreId, String debuggerId) {
        DeviceCoreDebuggerRegistry registry = DeviceCoreDebuggerDescriptors.getDeviceCoreDebuggerRegistry();
        List descriptors = registry.getDeviceCoreDebuggerDescriptorsByDebuggerId(debuggerId);
        DeviceCoreDebuggerDescriptor descriptor = null;
        for (DeviceCoreDebuggerDescriptor iter : descriptors) {
            if (!iter.getDeviceCoreId().equals(deviceCoreId)) continue;
            descriptor = iter;
            break;
        }
        if (descriptor == null) {
            return "";
        }
        String serverPort = descriptor.getServerPort();
        if (serverPort == null) {
            return "";
        }
        return serverPort;
    }

    public static List<DeviceCoreDebuggerDescriptor> getDeviceCoreDebuggerDescriptorById(String debuggerId) {
        return DeviceCoreDebuggerDescriptors.getDeviceCoreDebuggerRegistry().getDeviceCoreDebuggerDescriptorsByDebuggerId(debuggerId);
    }

    public static List<DeviceCoreDebuggerDescriptor> getDeviceCoreDebuggerDescriptors(String deviceCoreId) {
        return DeviceCoreDebuggerDescriptors.getDeviceCoreDebuggerRegistry().getDeviceCoreDebuggerDescriptorsByDeviceCoreId(deviceCoreId);
    }

    public static List<DeviceCoreDescriptor> getDeviceCoreDescriptors(String debuggerId) {
        ArrayList<DeviceCoreDescriptor> result = new ArrayList<DeviceCoreDescriptor>();
        HardwareDebuggerCoreActivator activator = HardwareDebuggerCoreActivator.getInstance();
        CoreDebuggerRegistry coreDebuggerRegistry = activator.getCoreDebuggerRegistry();
        HashSet<String> coreIds = new HashSet<String>();
        List coreDebuggerDescriptors = coreDebuggerRegistry.getCoreDebuggerDescriptorsByDebuggerId(debuggerId);
        for (CoreDebuggerDescriptor coreDebuggerDescriptor : coreDebuggerDescriptors) {
            String coreId = coreDebuggerDescriptor.getCoreId();
            coreIds.add(coreId);
        }
        DeviceDebuggerRegistry deviceDebuggerRegistry = activator.getDeviceDebuggerRegistry();
        List deviceDebuggerDescriptors = deviceDebuggerRegistry.getDeviceDebuggerDescriptorsByDebuggerId(debuggerId);
        for (DeviceDebuggerDescriptor deviceDebuggerDescriptor : deviceDebuggerDescriptors) {
            String deviceId = deviceDebuggerDescriptor.getDeviceId();
            List deviceCoreDescriptors = DeviceDescriptors.getDeviceRegistry().getDeviceCoreDescriptorsByDeviceId(deviceId);
            result.addAll(deviceCoreDescriptors);
        }
        return result;
    }

    public static List<String> getDebuggersByDeviceToolchain(String device, String toolchain) {
        ArrayList<Predicate<DebuggerCondition>> conditions = new ArrayList<Predicate<DebuggerCondition>>();
        conditions.add(DeviceCoreDebuggerDescriptors.getToolchainPredicate(toolchain));
        return DeviceCoreDebuggerDescriptors.getDebuggersByConditions(device, conditions);
    }

    public static List<String> getDebuggersByDevicePlatform(String device, String platform) {
        ArrayList<Predicate<DebuggerCondition>> conditions = new ArrayList<Predicate<DebuggerCondition>>();
        conditions.add(DeviceCoreDebuggerDescriptors.getPlatformPredicate(platform));
        return DeviceCoreDebuggerDescriptors.getDebuggersByConditions(device, conditions);
    }

    public static List<String> getDebuggersByDeviceConditions(String device, String toolchain, String core) {
        ArrayList<Predicate<DebuggerCondition>> conditions = new ArrayList<Predicate<DebuggerCondition>>();
        conditions.add(DeviceCoreDebuggerDescriptors.getCorePredicate(core));
        conditions.add(DeviceCoreDebuggerDescriptors.getToolchainPredicate(toolchain));
        return DeviceCoreDebuggerDescriptors.getDebuggersByConditions(device, conditions);
    }

    public static List<String> getDebuggersByDeviceRevisionConditions(String device, String toolchain, String revision) {
        ArrayList<Predicate<DebuggerCondition>> conditions = new ArrayList<Predicate<DebuggerCondition>>();
        conditions.add(DeviceCoreDebuggerDescriptors.getRevisionPredicate(revision));
        conditions.add(DeviceCoreDebuggerDescriptors.getToolchainPredicate(toolchain));
        return DeviceCoreDebuggerDescriptors.getDebuggersByConditions(device, conditions);
    }

    public static List<String> getDebuggersByDeviceConditions(String device, String toolchain, String core, String revision) {
        ArrayList<Predicate<DebuggerCondition>> conditions = new ArrayList<Predicate<DebuggerCondition>>();
        conditions.add(DeviceCoreDebuggerDescriptors.getCorePredicate(core));
        conditions.add(DeviceCoreDebuggerDescriptors.getToolchainPredicate(toolchain));
        conditions.add(DeviceCoreDebuggerDescriptors.getRevisionPredicate(revision));
        return DeviceCoreDebuggerDescriptors.getDebuggersByConditions(device, conditions);
    }

    public static List<String> getDebuggersByDeviceConditions(String device, String toolchain, String core, String revision, String platform, String contributedCondition) {
        ArrayList<Predicate<DebuggerCondition>> conditions = new ArrayList<Predicate<DebuggerCondition>>();
        if (core != null && !core.isEmpty()) {
            conditions.add(DeviceCoreDebuggerDescriptors.getCorePredicate(core));
        }
        if (toolchain != null && !toolchain.isEmpty()) {
            conditions.add(DeviceCoreDebuggerDescriptors.getToolchainPredicate(toolchain));
        }
        if (revision != null && !revision.isEmpty()) {
            conditions.add(DeviceCoreDebuggerDescriptors.getRevisionPredicate(revision));
        }
        if (platform != null && !platform.isEmpty()) {
            conditions.add(DeviceCoreDebuggerDescriptors.getPlatformPredicate(platform));
        }
        if (contributedCondition != null && !contributedCondition.isEmpty()) {
            conditions.add(DeviceCoreDebuggerDescriptors.getContributedConditionPredicate(contributedCondition));
        }
        return DeviceCoreDebuggerDescriptors.getDebuggersByConditions(device, RequestType.DEVICE, conditions);
    }

    public static List<String> getDebuggersByFamilyConditions(String family, String toolchain, String core, String revision, String platform, String contributedCondition) {
        ArrayList<Predicate<DebuggerCondition>> conditions = new ArrayList<Predicate<DebuggerCondition>>();
        if (core != null && !core.isEmpty()) {
            conditions.add(DeviceCoreDebuggerDescriptors.getCorePredicate(core));
        }
        if (toolchain != null && !toolchain.isEmpty()) {
            conditions.add(DeviceCoreDebuggerDescriptors.getToolchainPredicate(toolchain));
        }
        if (revision != null && !revision.isEmpty()) {
            conditions.add(DeviceCoreDebuggerDescriptors.getRevisionPredicate(revision));
        }
        if (platform != null && !platform.isEmpty()) {
            conditions.add(DeviceCoreDebuggerDescriptors.getPlatformPredicate(platform));
        }
        if (contributedCondition != null && !contributedCondition.isEmpty()) {
            conditions.add(DeviceCoreDebuggerDescriptors.getContributedConditionPredicate(contributedCondition));
        }
        return DeviceCoreDebuggerDescriptors.getDebuggersByConditions(family, RequestType.FAMILY, conditions);
    }

    public static List<String> getDebuggersByConditions(String device, List<Predicate<DebuggerCondition>> conditions) {
        return DeviceCoreDebuggerDescriptors.getDebuggersByConditions(device, RequestType.DEVICE, conditions);
    }

    private static List<String> getDebuggersByConditions(String instanceId, RequestType type, List<Predicate<DebuggerCondition>> conditions) {
        List<String> debuggers = new ArrayList<String>();
        List<Map<String, List<DebuggerCondition>>> conditionsList = null;
        switch (type) {
            case DEVICE: {
                conditionsList = DeviceCoreDebuggerDescriptors.getDebuggerConditionsForDevice(instanceId);
                break;
            }
            case FAMILY: {
                conditionsList = DeviceCoreDebuggerDescriptors.getDebuggerConditionsForFamily(instanceId);
                break;
            }
            default: {
                return debuggers;
            }
        }
        for (Map<String, List<DebuggerCondition>> map : conditionsList) {
            for (Map.Entry<String, List<DebuggerCondition>> condition : map.entrySet()) {
                Optional<DebuggerCondition> optCondition = condition.getValue().stream().filter(conditions.stream().reduce(x -> true, Predicate::and)).findFirst();
                if (!optCondition.isPresent()) continue;
                debuggers.add(condition.getKey());
            }
        }
        List hardwareDebuggerDescriptorList = DeviceCoreDebuggerDescriptors.getDeviceCoreDebuggerRegistry().getHardwareDebuggerDescriptor();
        for (HardwareDebuggerDescriptor hardwareDebuggerDescriptor : hardwareDebuggerDescriptorList) {
            if (!hardwareDebuggerDescriptor.getDevice().equals(instanceId)) continue;
            debuggers = DeviceCoreDebuggerDescriptors.getDebuggersSortedByRank(debuggers, hardwareDebuggerDescriptor);
            break;
        }
        return debuggers;
    }

    private static List<String> getDebuggersSortedByRank(List<String> debuggers, final HardwareDebuggerDescriptor hardwareDebuggerDescriptor) {
        final Map debuggerRanks = hardwareDebuggerDescriptor.getDebuggersRanks();
        Collections.sort(debuggers, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (this.getRank(o1) > this.getRank(o2)) {
                    return 1;
                }
                return -1;
            }

            private int getRank(String debugger) {
                if (debuggerRanks.containsKey(debugger)) {
                    return (Integer)debuggerRanks.get(debugger);
                }
                HardwareDebuggerCoreActivator.getInstance().logWarning("Debugger desriptor for device " + hardwareDebuggerDescriptor.getDevice() + " does not contain data about the requested debugger " + debugger);
                return 5;
            }
        });
        return debuggers;
    }

    private static List<Map<String, List<DebuggerCondition>>> getDebuggerConditionsForDevice(String device) {
        return DeviceCoreDebuggerDescriptors.getDeviceCoreDebuggerRegistry().getHardwareDebuggerDescriptor().stream().filter(p -> p.getDevice().equals(device)).map(HardwareDebuggerDescriptor::getDebuggersConditions).collect(Collectors.toList());
    }

    private static List<Map<String, List<DebuggerCondition>>> getDebuggerConditionsForFamily(String family) {
        return DeviceCoreDebuggerDescriptors.getDeviceCoreDebuggerRegistry().getHardwareDebuggerDescriptor().stream().filter(p -> p.getFamily().equals(family)).map(HardwareDebuggerDescriptor::getDebuggersConditions).collect(Collectors.toList());
    }

    public static List<String> getDebuggerByDeviceConditions(String device) {
        return DeviceCoreDebuggerDescriptors.getDeviceCoreDebuggerRegistry().getHardwareDebuggerDescriptor().stream().filter(p -> p.getDevice().equals(device)).map(HardwareDebuggerDescriptor::getDebuggersConditions).flatMap(p -> p.keySet().stream()).distinct().collect(Collectors.toList());
    }

    public static List<String> getDebuggerByDeviceConditions(String device, String core) {
        ArrayList<String> debuggers = new ArrayList<String>();
        List descriptors = DeviceCoreDebuggerDescriptors.getDeviceCoreDebuggerRegistry().getHardwareDebuggerDescriptor().stream().filter(p -> p.getDevice().equals(device)).collect(Collectors.toList());
        for (HardwareDebuggerDescriptor descriptor : descriptors) {
            for (Map.Entry entry : descriptor.getDebuggersConditions().entrySet()) {
                for (DebuggerCondition condition : (List)entry.getValue()) {
                    if (!DeviceCoreDebuggerDescriptors.strongConditionMatches(condition.getCoreCondition(), core) || debuggers.contains(entry.getKey())) continue;
                    debuggers.add((String)entry.getKey());
                }
            }
        }
        return debuggers;
    }

    public static List<DeviceCoreDescriptor> getDeviceCoreDescriptorsByDebuggerId(String device, String debuggerId) {
        return DeviceDescriptors.getDeviceCoreDescriptors((String)device).stream().filter(deviceCoreDescriptor -> debuggerId == null || debuggerId.isEmpty() || DeviceCoreDebuggerDescriptors.getDebuggerByDeviceConditions(device, deviceCoreDescriptor.getCoreId()).contains(debuggerId) || DeviceCoreDebuggerDescriptors.getDebuggerByDeviceCoreConditions(device, deviceCoreDescriptor.getId()).contains(debuggerId)).collect(Collectors.toList());
    }

    public static List<String> getDebuggerByDeviceCoreConditions(String device, String deviceCore) {
        ArrayList<String> debuggers = new ArrayList<String>();
        List descriptors = DeviceCoreDebuggerDescriptors.getDeviceCoreDebuggerRegistry().getHardwareDebuggerDescriptor().stream().filter(p -> p.getDevice().equals(device)).collect(Collectors.toList());
        for (HardwareDebuggerDescriptor descriptor : descriptors) {
            for (Map.Entry entry : descriptor.getDebuggersConditions().entrySet()) {
                for (DebuggerCondition condition : (List)entry.getValue()) {
                    if (!DeviceCoreDebuggerDescriptors.strongConditionMatches(condition.getDeviceCoreCondition(), deviceCore) || debuggers.contains(entry.getKey())) continue;
                    debuggers.add((String)entry.getKey());
                }
            }
        }
        return debuggers;
    }

    public static List<String> getToolChainsByDebuggerConditions(String device, String debugger) {
        return DeviceCoreDebuggerDescriptors.getToolChainsByDebuggerConditions(device, "", debugger, "");
    }

    public static List<String> getToolChainsByDebuggerConditions(String device, String debugger, String core) {
        return DeviceCoreDebuggerDescriptors.getToolChainsByDebuggerConditions(device, "", debugger, core);
    }

    public static List<String> getToolChainsByDebuggerConditions(String device, String deviceRev, String debugger, String core) {
        HashSet<String> families = new HashSet<String>();
        List familyDescs = DeviceDescriptors.getFamilyDescriptors((String)device);
        if (!familyDescs.isEmpty()) {
            familyDescs.forEach(family -> {
                boolean bl = families.add(family.getId());
            });
        }
        return DeviceCoreDebuggerDescriptors.getToolChainsForDebuggerConditions(DeviceCoreDebuggerDescriptors.getDeviceDebuggerConditionsStream(device, families, debugger).filter(p -> DeviceCoreDebuggerDescriptors.weakConditionMatches(p.getCoreCondition(), core) && DeviceCoreDebuggerDescriptors.strongConditionMatches(p.getRevisionCondition(), deviceRev)));
    }

    private static Stream<DebuggerCondition> getDeviceDebuggerConditionsStream(String device, Set<String> families, String debugger) {
        return DeviceCoreDebuggerDescriptors.getDeviceCoreDebuggerRegistry().getHardwareDebuggerDescriptor().stream().filter(p -> p.getDevice().equals(device) || families.contains(p.getFamily())).map(HardwareDebuggerDescriptor::getDebuggersConditions).filter(p -> p.get(debugger) != null).flatMap(p -> ((List)p.get(debugger)).stream()).distinct();
    }

    private static boolean weakConditionMatches(String predicateCond, String targetCond) {
        return predicateCond == null || predicateCond.isEmpty() || predicateCond.equals(targetCond);
    }

    private static boolean strongConditionMatches(String predicateCond, String targetCond) {
        return predicateCond == null || predicateCond.equals(targetCond);
    }

    public static List<String> getToolChainsForDebuggerConditions(Stream<DebuggerCondition> stream) {
        return stream.map(DebuggerCondition::getToolChainCondition).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    private static Predicate<DebuggerCondition> getToolchainPredicate(String arg) {
        return p -> p.getToolChainCondition().equals(arg);
    }

    private static Predicate<DebuggerCondition> getCorePredicate(String arg) {
        return p -> p.getCoreCondition().equals(arg);
    }

    private static Predicate<DebuggerCondition> getRevisionPredicate(String arg) {
        return p -> p.getRevisionCondition().equals(arg);
    }

    private static Predicate<DebuggerCondition> getContributedConditionPredicate(String arg) {
        return p -> p.getContributedCondition().equals(arg);
    }

    private static Predicate<DebuggerCondition> getPlatformPredicate(String arg) {
        return p -> p.getPlatformCondition().equals(arg);
    }

    private static enum RequestType {
        FAMILY,
        DEVICE;

    }
}

