/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.framework.commands;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.framework.Messages;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.change.DefaultConfigChangeContextHelper;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SelectCoreHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = Display.getDefault().getActiveShell();
        assert (shell != null);
        SelectCoreDialog dlg = new SelectCoreDialog(shell);
        if (dlg.open() == 0) {
            ISharedConfiguration sharedCfg = SharedConfigurationFactory.getSharedConfigurationSingleton();
            if (dlg.selectedCore != null && sharedCfg.getCommonConfig().getSelectedCore() != dlg.selectedCore) {
                sharedCfg.getCommonConfig().setSelectedCore(dlg.selectedCore);
                String changeDescr = String.format(Messages.get().SelectCoreDlg_Label, dlg.selectedCore.getName());
                sharedCfg.setDirty(DefaultConfigChangeContextHelper.preferencesChangedCore((ISharedConfiguration)sharedCfg, (String)changeDescr));
            }
        }
        return null;
    }

    static class SelectCoreDialog
    extends MessageDialog {
        ProcessorCore selectedCore;

        SelectCoreDialog(@NonNull Shell parentShell) {
            super(parentShell, Messages.get().SelectCoreDlg_Title, null, null, 5, new String[]{JFaceResources.getString((String)"ok"), JFaceResources.getString((String)"cancel")}, 0);
        }

        public Image getImage() {
            return null;
        }

        protected Control createCustomArea(Composite parent) {
            ISharedConfiguration sharedCfg = SharedConfigurationFactory.getSharedConfigurationSingleton();
            Group grp = new Group(parent, 0);
            grp.setText(String.format(Messages.get().SelectCoreDlg_Label, sharedCfg.getCommonConfig().getPackage()));
            grp.setToolTipText(Messages.get().SelectCoreDlg_Tooltip);
            grp.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
            RowLayout layout = new RowLayout(512);
            layout.marginTop *= 2;
            layout.marginBottom *= 2;
            layout.spacing *= 2;
            layout.marginLeft *= 2;
            grp.setLayout((Layout)layout);
            ProcessorCore selCore = sharedCfg.getCommonConfig().getSelectedCore();
            String selCoreId = selCore != null ? selCore.getID() : "";
            for (final ProcessorCore core : sharedCfg.getCommonConfig().getCores()) {
                Button radio = new Button((Composite)grp, 16);
                radio.setText(core.getName());
                radio.setSelection(selCoreId.equals(core.getID()));
                if (!UtilsText.isEmpty((String)core.getDescription())) {
                    radio.setToolTipText(String.valueOf(core.getName()) + ": " + core.getDescription());
                }
                radio.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        selectedCore = core;
                    }
                });
            }
            if (selCoreId.isEmpty()) {
                Button radio = new Button((Composite)grp, 16);
                radio.setText(Messages.get().SelectCoreDlg_NoSelectedCore_Title);
                radio.setSelection(true);
                radio.setToolTipText(Messages.get().SelectCoreDlg_NoSelectedCore_Tooltip);
                radio.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        selectedCore = null;
                    }
                });
            }
            return grp;
        }
    }
}

