/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.framework.handlers;

import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.provider.configuration.ICommonConfig;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.provider.configuration.storage.Shield;
import com.nxp.swtools.utils.httpserver.AHandler;
import com.nxp.swtools.utils.httpserver.HttpRequest;
import com.nxp.swtools.utils.httpserver.Response;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@NonNullByDefault
public class HttpConfigurationHandler
extends AHandler {
    protected static final Logger LOGGER = LogManager.getLogger(HttpConfigurationHandler.class);
    public static final String PREFIX = "/common/configuration";

    public void handle(HttpRequest request) {
        ISharedConfiguration configuration = SharedConfigurationFactory.getSharedConfigurationSingleton();
        if (configuration.isModificationInProgress()) {
            request.setResponse(new Response(500, "Configuration is being modified right now"));
            return;
        }
        JSONObject response = new JSONObject();
        ICommonConfig commonConfig = configuration.getCommonConfig();
        try {
            response.put("board", (Object)commonConfig.getBoard());
            response.put("board_revision", (Object)commonConfig.getBoardRevision());
            Collection cores = commonConfig.getCores();
            response.put("cores", (Object)HttpConfigurationHandler.processCores(cores));
            response.put("description", (Object)commonConfig.getDescription());
            response.put("kit", (Object)commonConfig.getKit());
            response.put("kit_or_board", (Object)commonConfig.getKitOrBoard());
            response.put("mcu", (Object)commonConfig.getMcu());
            response.put("mcu_identification", (Object)HttpConfigurationHandler.processMcuIdentification(commonConfig.getMcuIdentification()));
            response.put("name", (Object)commonConfig.getName());
            response.put("package", (Object)commonConfig.getPackage());
            response.put("sdk_version", (Object)commonConfig.getSdkVersion());
            ProcessorCore selectedCore = commonConfig.getSelectedCore();
            if (selectedCore != null) {
                response.put("selected_core", (Object)HttpConfigurationHandler.processCore(selectedCore));
            }
            response.put("session_index", commonConfig.getSessionIndex());
            response.put("session_uuid", (Object)commonConfig.getSessionUUID());
            Collection shields = commonConfig.getShields();
            if (shields != null) {
                response.put("shields", (Object)HttpConfigurationHandler.processShields(shields));
            }
        }
        catch (JSONException e) {
            String message = MessageFormat.format("Problem with serializing shared configuration to JSON object in {0}: {1}", HttpConfigurationHandler.class, e.getLocalizedMessage());
            LOGGER.log(Level.SEVERE, message);
            request.setResponse(new Response(500, message));
        }
        request.setResponse(new Response(200, response.toString()));
    }

    public boolean canHandle(HttpRequest request) {
        return request.getLocation().equalsIgnoreCase(PREFIX);
    }

    private static JSONObject processMcuIdentification(IMcuIdentification mcuIdentification) throws JSONException {
        JSONObject jsonMcuIdentification = new JSONObject();
        jsonMcuIdentification.put("board", (Object)mcuIdentification.getBoard());
        jsonMcuIdentification.put("kit", (Object)mcuIdentification.getKit());
        jsonMcuIdentification.put("mcu", (Object)mcuIdentification.getMcu());
        jsonMcuIdentification.put("package", (Object)mcuIdentification.getPackage());
        jsonMcuIdentification.put("sdk_version", (Object)mcuIdentification.getSdkVersion());
        return jsonMcuIdentification;
    }

    private static JSONArray processShields(Collection<Shield> shields) throws JSONException {
        JSONArray jsonShields = new JSONArray();
        for (Shield shield : shields) {
            JSONObject jsonShield = HttpConfigurationHandler.processShield(shield);
            jsonShields.put((Object)jsonShield);
        }
        return jsonShields;
    }

    private static JSONObject processShield(Shield shield) throws JSONException {
        JSONObject jsonShield = new JSONObject();
        jsonShield.put("name", (Object)shield.getName());
        jsonShield.put("revision", (Object)shield.getRevision());
        return jsonShield;
    }

    private static JSONArray processCores(Collection<ProcessorCore> cores) throws JSONException {
        JSONArray jsonCores = new JSONArray();
        for (ProcessorCore core : cores) {
            JSONObject jsonCore = HttpConfigurationHandler.processCore(core);
            jsonCores.put((Object)jsonCore);
        }
        return jsonCores;
    }

    private static JSONObject processCore(ProcessorCore core) throws JSONException {
        JSONObject jsonCore = new JSONObject();
        jsonCore.put("id", (Object)core.getID());
        jsonCore.put("name", (Object)core.getName());
        jsonCore.put("description", (Object)core.getDescription());
        jsonCore.put("is_master", core.isMaster());
        return jsonCore;
    }
}

