/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.framework.wizards.processordata;

import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.ui.utils.swt.dialogs.KExProgressMonitorDialog;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.runtime.JobsHelper;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.common.utils.zip.ZipUtils;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.ITemplateInfo;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.framework.Messages;
import com.nxp.swtools.framework.ui.downloadmanager.DataManager;
import com.nxp.swtools.framework.ui.newconfig.ProcessorNode;
import com.nxp.swtools.framework.ui.newconfig.containers.ProcessorSelectionContainer;
import com.nxp.swtools.framework.wizards.processordata.ExportImportProcessorDataUtils;
import com.nxp.swtools.provider.processors.DataPackage;
import com.nxp.swtools.provider.processors.KExProcessorsProvider;
import com.nxp.swtools.utils.preferences.KEPreferences;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiPredicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipInputStream;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;

public class ImportProcessorDataPage
extends WizardPage {
    @Nullable
    protected Text userFileNameText = null;
    @Nullable
    protected String lastSelectedPath = null;
    @Nullable
    protected Button archiveButton;
    @Nullable
    protected Button dirButton;
    @Nullable
    protected CheckboxTreeViewer viewer;
    @Nullable
    private Path workTempDir;
    static Logger LOGGER = LogManager.getLogger(ImportProcessorDataPage.class);
    @Nullable
    private File extractedArchive;
    static final BiPredicate<ITemplateInfo, @Nullable ITemplateInfo> templateVersionUpdatePredicate = (t1, t2) -> t2 == null || KExProcessorsProvider.isVersionHigher((String)t1.getVersion(), (String)t2.getVersion());
    static final BiPredicate<IProcessorMasterToolInfo, ISupportedDerivativesForSwTools> processorVersionUpdatePredicate = (it, sharedDerivatives) -> Objects.isNull(sharedDerivatives.getProcessorMasterToolInfo(it.getId(), it.getSWToolsDataFolderID())) || sharedDerivatives.getProcessorMasterToolInfos(it.getId()).anyMatch(p -> KExProcessorsProvider.isVersionHigher((String)it.getVersion(), (String)p.getVersion()));

    protected ImportProcessorDataPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.get().ImportProcessorDataPage_ImportProcessorData);
        try {
            this.workTempDir = Files.createTempDirectory("exported_data", new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Cannot create temp. directory");
            e.printStackTrace();
        }
    }

    protected String getSelectedFile() {
        Text exportTextLoc = this.userFileNameText;
        assert (exportTextLoc != null);
        return exportTextLoc.getText();
    }

    protected Object[] getSelection() {
        return ExportImportProcessorDataUtils.getSelection(this.getViewer());
    }

    protected boolean isArchiveSelected() {
        if (this.archiveButton != null) {
            return this.archiveButton.getSelection();
        }
        return true;
    }

    public @Nullable Path getWorkingDir() {
        return this.isArchiveSelected() ? this.workTempDir : Paths.get(this.getSelectedFile(), new String[0]);
    }

    protected CheckboxTreeViewer getViewer() {
        assert (this.viewer != null);
        return this.viewer;
    }

    public void createControl(@NonNull Composite parent) {
        Composite pageComposite = new Composite(parent, 0);
        pageComposite.setLayout((Layout)new GridLayout(1, false));
        pageComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).minSize(600, 200).create());
        this.setControl((Control)pageComposite);
        Composite composite = new Composite(pageComposite, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        GridData data = GridDataFactory.fillDefaults().grab(true, false).indent(0, 0).create();
        composite.setLayoutData((Object)data);
        this.createImportDataControl(composite);
        composite = new Composite(pageComposite, 0);
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, false).indent(0, 0).create());
        Label importFromLabel = new Label(composite, 0);
        importFromLabel.setText(Messages.get().ImportProcessorDataPage_ImportFrom);
        this.archiveButton = this.createRadioButton(composite, Messages.get().ImportProcessorDataPage_Archive, true);
        this.createRadioButton(composite, Messages.get().ImportProcessorDataPage_Directory, false);
        Label seriesLabel = new Label(pageComposite, 0);
        GridData gridData = new GridData();
        gridData.verticalIndent = 10;
        seriesLabel.setLayoutData((Object)gridData);
        seriesLabel.setText(Messages.get().ImportProcessorDataPage_SelectWhatToImport);
        CheckboxTreeViewer viewerLoc = this.viewer = ExportImportProcessorDataUtils.createTreeWithProcessorData(pageComposite, null);
        viewerLoc.setAutoExpandLevel(2);
        viewerLoc.addCheckStateListener(event -> this.checkStateChanged(event));
        ImportProcessorDataPage.createStatusColumn((TreeViewer)viewerLoc, SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools());
        this.validatePage();
    }

    protected @Nullable Button createRadioButton(Composite composite, String label, boolean selected) {
        Button button = new Button(composite, 16);
        button.setSelection(selected);
        button.setText(label);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportProcessorDataPage.this.validatePage();
            }
        });
        return button;
    }

    protected void createImportDataControl(Composite composite) {
        Text userFileNameTextLoc;
        Label userFileNameLabel = new Label(composite, 0);
        GridData gridData = new GridData();
        userFileNameLabel.setLayoutData((Object)gridData);
        userFileNameLabel.setText(Messages.get().ImportProcessorDataPage_Source);
        this.userFileNameText = userFileNameTextLoc = new Text(composite, 2048);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)userFileNameTextLoc, "DownloadProcessorDataCustomDirectoryText");
        userFileNameTextLoc.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        userFileNameTextLoc.addModifyListener(e -> this.validatePage());
        Button findButton = new Button(composite, 0);
        findButton.setText(Messages.get().ExportProcessorDataPage_Browse);
        Shell shell = composite.getShell();
        findButton.addListener(13, event -> {
            String selectedPath = null;
            if (this.isArchiveSelected()) {
                FileDialog dialog = new FileDialog(shell, 4096);
                dialog.setText(UtilsText.safeString((String)Messages.get().ImportProcessorDataPage_SelectSourceArchive));
                dialog.setFilterExtensions(ExportImportProcessorDataUtils.ZIP_EXTENSIONS);
                dialog.setFileName(userFileNameTextLoc.getText());
                selectedPath = dialog.open();
            } else {
                DirectoryDialog dialog = new DirectoryDialog(shell, 4096);
                dialog.setText(UtilsText.safeString((String)Messages.get().ImportProcessorDataPage_SelectSourceDir));
                dialog.setFilterPath(KEPreferences.getLastSaveFolderPath());
                selectedPath = dialog.open();
                if (selectedPath != null) {
                    KEPreferences.setLastSaveFolderPath((String)selectedPath);
                }
            }
            if (selectedPath != null && !selectedPath.isEmpty()) {
                this.lastSelectedPath = userFileNameTextLoc.getText();
                userFileNameTextLoc.setText(selectedPath);
                this.lastSelectedPath = selectedPath;
            }
        });
    }

    private static void createStatusColumn(final TreeViewer treeViewer, final ISupportedDerivativesForSwTools derivatives) {
        TreeViewerColumn viewerColumn = new TreeViewerColumn(treeViewer, 0);
        TreeColumn column = viewerColumn.getColumn();
        column.setText(Messages.get().ProcessorProvider_StatusColumn);
        column.setWidth(250);
        viewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public @Nullable String getText(Object element) {
                if (element instanceof ProcessorNode) {
                    return null;
                }
                if (ProcessorSelectionContainer.isElementAvailableOffline(element, derivatives)) {
                    String cachVer = ProcessorSelectionContainer.getOfflineElementVersion(element, derivatives);
                    Object input = treeViewer.getInput();
                    if (!$assertionsDisabled && input == null) {
                        throw new AssertionError();
                    }
                    String importVer = ProcessorSelectionContainer.getOfflineElementVersion(element, (ISupportedDerivativesForSwTools)input);
                    if (KExProcessorsProvider.isVersionHigher((String)importVer, (String)cachVer)) {
                        return MessageFormat.format(Messages.get().ImportProcessorDataPage_ImportStatusNewer, cachVer, importVer);
                    }
                    if (KExProcessorsProvider.isVersionHigher((String)cachVer, (String)importVer)) {
                        return MessageFormat.format(Messages.get().ImportProcessorDataPage_ImportStatusOlder, cachVer, importVer);
                    }
                    return MessageFormat.format(Messages.get().ImportProcessorDataPage_ImportStatusSame, cachVer, importVer);
                }
                return Messages.get().ImportProcessorDataPage_ImportStatusNew;
            }
        });
    }

    protected static boolean isUpdateAvailable(TreeViewer viewer, Object element, ISupportedDerivativesForSwTools derivatives) {
        if (element instanceof ITemplateInfo) {
            ITemplateInfo template = (ITemplateInfo)element;
            switch (template.getTemplateType()) {
                case ttTemplate: {
                    return false;
                }
                case ttBoard: {
                    return templateVersionUpdatePredicate.test(template, derivatives.getBoardById(template.getId(), template.getSWToolsDataFolderID()));
                }
                case ttKit: {
                    return templateVersionUpdatePredicate.test(template, derivatives.getKitById(template.getId(), template.getSWToolsDataFolderID()));
                }
            }
            assert (false) : "unsupported template type";
        } else if (element instanceof IProcessorMasterToolInfo) {
            IProcessorMasterToolInfo info = (IProcessorMasterToolInfo)element;
            ISupportedDerivativesForSwTools input = (ISupportedDerivativesForSwTools)viewer.getInput();
            if (input == null) {
                return false;
            }
            return input.getProcessorMasterToolInfos(info.getId()).anyMatch(it -> processorVersionUpdatePredicate.test((IProcessorMasterToolInfo)it, derivatives));
        }
        return false;
    }

    private void checkStateChanged(CheckStateChangedEvent event) {
        DataManager.checkSubTreeAndParents(event);
        this.validatePage();
    }

    protected void validatePage() {
        String errMessage = null;
        String warnMessage = null;
        boolean valid = true;
        File file = new File(this.getSelectedFile());
        // Could not load outer class - annotation placement on inner may be incorrect
        CollectionsUtils.Pair<FileStatus, @Nullable String> fileStatus = ImportProcessorDataPage.validateInput(file, this.isArchiveSelected());
        switch ((FileStatus)((Object)fileStatus.getFirst())) {
            case FILE_OK: {
                break;
            }
            case FILE_WARNING: {
                warnMessage = (String)fileStatus.getSecond();
                break;
            }
            case FILE_ERROR: {
                valid = false;
                errMessage = (String)fileStatus.getSecond();
            }
        }
        this.updateViewer(file, valid, this.isArchiveSelected());
        if (valid && this.getSelection().length == 0) {
            errMessage = Messages.get().ExportProcessorDataPage_NoDataSelected;
            valid = false;
        }
        this.setMessage(warnMessage, 2);
        this.setErrorMessage(errMessage);
        this.setPageComplete(valid);
    }

    protected void updateViewer(File file, boolean valid, boolean isArchive) {
        if (valid) {
            this.getViewer().getTree().setEnabled(true);
            if (this.isRefreshNeeded(file, isArchive)) {
                if (isArchive) {
                    this.runLongOperation(monitor -> {
                        monitor.beginTask(UtilsText.safeString((String)Messages.get().ImportProcessorDataPage_ExtractingArchive), -1);
                        this.extractArchive(file);
                    });
                    this.refreshTreeContent(this.workTempDir);
                } else {
                    this.refreshTreeContent(file.toPath());
                }
                this.getViewer().expandAll();
            }
        } else {
            this.getViewer().getTree().setEnabled(false);
        }
    }

    protected void runLongOperation(IRunnableWithProgress runnable) {
        KExProgressMonitorDialog.run((Shell)this.getShell(), (boolean)false, null, (IRunnableWithProgress)runnable);
    }

    private boolean isRefreshNeeded(File file, boolean archive) {
        if (archive) {
            return !file.equals(this.extractedArchive);
        }
        if (this.getViewer().getInput() == null) {
            return true;
        }
        return this.lastSelectedPath != null && this.userFileNameText != null && !this.lastSelectedPath.equals(UtilsText.safeString((String)this.getSelectedFile()));
    }

    protected void refreshTreeContent(@Nullable Path path) {
        assert (path != null);
        SupportedDerivativesForSwTools supportedDerivatives = new SupportedDerivativesForSwTools(path.toString());
        this.getViewer().setInput((Object)supportedDerivatives);
        this.checkNotConflictingItems((ISupportedDerivativesForSwTools)supportedDerivatives, SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools());
    }

    private void checkNotConflictingItems(ISupportedDerivativesForSwTools tempDerivatives, ISupportedDerivativesForSwTools sharedDerivatives) {
        tempDerivatives.getAllProcessorMasterToolInfos().filter(it -> processorVersionUpdatePredicate.test((IProcessorMasterToolInfo)it, sharedDerivatives)).distinct().forEach(it -> this.setTreeElementCheckedState(it, true));
        tempDerivatives.getAllBoardsInfos().stream().filter(it -> templateVersionUpdatePredicate.test((ITemplateInfo)it, sharedDerivatives.getBoardById(it.getId(), it.getSWToolsDataFolderID()))).forEach(it -> this.setTreeElementCheckedState(it, true));
        tempDerivatives.getAllKitsInfos().stream().filter(it -> templateVersionUpdatePredicate.test((ITemplateInfo)it, sharedDerivatives.getKitById(it.getId(), it.getSWToolsDataFolderID()))).forEach(it -> this.setTreeElementCheckedState(it, true));
    }

    private void setTreeElementCheckedState(Object element, boolean status) {
        this.getViewer().setChecked(element, status);
        DataManager.checkSubTreeAndParents(this.getViewer(), element, status);
    }

    private void extractArchive(File archive) {
        if (archive.equals(this.extractedArchive)) {
            return;
        }
        this.extractedArchive = null;
        Path workTempDirLoc = this.workTempDir;
        if (workTempDirLoc == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.get().NewConfigDialog_ErrorDialogTitle, (String)Messages.get().ImportProcessorDataPage_CannotExtractTotemp);
            return;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ZipInputStream zip = new ZipInputStream(new FileInputStream(archive));){
                this.cleanupTempDir(true);
                ZipUtils.extractZip((ZipInputStream)zip, (File)workTempDirLoc.toFile(), (boolean)true);
                this.extractedArchive = archive;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.severe(e.getMessage());
        }
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    CollectionsUtils.Pair<FileStatus, @Nullable String> validateInput(File file, boolean isArchive) {
        ArrayList<String> messages = new ArrayList<String>();
        if (isArchive) {
            messages.add(Messages.get().ExportProcessorDataPage_InvalidFileName);
            messages.add(Messages.get().ImportProcessorDataPage_NotDataArchive);
        } else {
            messages.add(Messages.get().ImportProcessorDataPage_InvalidDirName);
            messages.add(Messages.get().ImportProcessorDataPage_NotDataDirectory);
        }
        if (!file.exists()) {
            return new CollectionsUtils.Pair((Object)FileStatus.FILE_ERROR, (Object)((String)messages.get(0)));
        }
        try {
            Properties props = DataPackage.getManifestAsproperties((File)file, (boolean)isArchive);
            if (props == null) {
                return new CollectionsUtils.Pair((Object)FileStatus.FILE_ERROR, (Object)((String)messages.get(1)));
            }
            String dataVersion = props.getProperty("data_version");
            if (UtilsText.isEmpty((String)dataVersion)) {
                return new CollectionsUtils.Pair((Object)FileStatus.FILE_ERROR, (Object)((String)messages.get(1)));
            }
            if (KExProcessorsProvider.isVersionHigher((String)dataVersion, (String)KExProcessorsProvider.getRestApiDataVersion())) {
                return new CollectionsUtils.Pair((Object)FileStatus.FILE_ERROR, (Object)Messages.get().ImportProcessorDataPage_IncompatibleData);
            }
            if (KExProcessorsProvider.isVersionHigher((String)KExProcessorsProvider.getRestApiDataVersion(), (String)dataVersion)) {
                return new CollectionsUtils.Pair((Object)FileStatus.FILE_WARNING, (Object)Messages.get().ImportProcessorDataPage_OldVersionData);
            }
            return new CollectionsUtils.Pair((Object)FileStatus.FILE_OK, null);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Getting properties manifest file...", e);
            return new CollectionsUtils.Pair((Object)FileStatus.FILE_ERROR, (Object)Messages.get().ExportProcessorDataPage_InvalidFileName);
        }
    }

    public void dispose() {
        JobsHelper.runjob((String)UtilsText.safeString((String)Messages.get().ImportProcessorDataPage_CleaningTemporaryFiles), () -> this.cleanupTempDir(false));
        super.dispose();
    }

    protected void cleanupTempDir(boolean contentOnly) {
        if (this.workTempDir != null) {
            UtilsFile.deleteDirectory((File)this.workTempDir.toFile(), (boolean)contentOnly);
        }
    }

    static enum FileStatus {
        FILE_OK,
        FILE_WARNING,
        FILE_ERROR;

    }
}

