/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.jface.viewers;

import com.nxp.s32ds.ext.rcp.jface.viewers.TreeContentCheckStateHolder;
import com.nxp.s32ds.ext.rcp.jface.viewers.TreeContentCheckStateProvider;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class ContainerFilteredCheckboxTreeViewer
extends CheckboxTreeViewer {
    private final TreeContentCheckStateHolder stateHolder = new TreeContentCheckStateHolder(() -> this.getContentProvider());
    private final TreeContentCheckStateProvider stateProvider = new TreeContentCheckStateProvider(this.stateHolder);
    private final ListenerList<StrucureChangedListener> listenerList = new ListenerList();
    private boolean insidePreservingSelection;

    public ContainerFilteredCheckboxTreeViewer(Composite parent) {
        super(parent);
        this.initViewer();
    }

    public ContainerFilteredCheckboxTreeViewer(Composite parent, int style) {
        super(parent, style);
        this.initViewer();
    }

    public ContainerFilteredCheckboxTreeViewer(Tree tree) {
        super(tree);
        this.initViewer();
    }

    public void setAllChecked(boolean state) {
        ITreeContentProvider contentProvider = this.getContentProvider();
        if (contentProvider == null) {
            throw new IllegalStateException("setAllChecked method should be called after setContentProvider");
        }
        Object[] objectArray = contentProvider.getElements(this.getInput());
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            this.stateHolder.setChecked(object, state);
            ++n2;
        }
        this.refresh();
    }

    private void initViewer() {
        this.setCheckStateProvider(this.stateProvider);
        this.setUseHashlookup(true);
        this.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ContainerFilteredCheckboxTreeViewer.this.doCheckStateChanged(event.getElement(), event.getChecked());
            }
        });
        this.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                ContainerFilteredCheckboxTreeViewer.this.initializeElement(event.getElement());
            }
        });
    }

    public Object[] getCheckedElements() {
        return this.stateHolder.getCheckedElements();
    }

    public void setCheckedElements(Object[] elements) {
        super.setCheckedElements(elements);
        int i = 0;
        while (i < elements.length) {
            this.doCheckStateChanged(elements[i], true);
            ++i;
        }
    }

    protected void setExpanded(Item item, boolean expand) {
        super.setExpanded(item, expand);
        if (expand && item instanceof TreeItem) {
            this.initializeElement(item.getData());
        }
    }

    protected void doCheckStateChanged(Object element, boolean checked) {
        TreeItem treeItem;
        if (!this.insidePreservingSelection) {
            this.stateHolder.setChecked(element, checked);
        }
        if ((treeItem = this.findTreeItem(element)) == null) {
            return;
        }
        treeItem.setGrayed(false);
        this.updateChildrenItems(treeItem);
        this.updateParentItems(treeItem.getParentItem());
    }

    protected TreeItem findTreeItem(Object element) {
        Widget widget = super.doFindItem(element);
        if (widget instanceof TreeItem) {
            return (TreeItem)widget;
        }
        return null;
    }

    protected void initializeElement(Object object) {
        TreeItem treeItem = this.findTreeItem(object);
        if (treeItem == null) {
            return;
        }
        this.updateChildrenItems(treeItem);
    }

    protected void updateChildrenItems(TreeItem treeItem) {
        Item[] children = this.getChildren((Widget)treeItem);
        int i = 0;
        while (i < children.length) {
            TreeItem curr = (TreeItem)children[i];
            if (this.updateItemCheckedState(curr)) {
                this.updateChildrenItems(curr);
            }
            ++i;
        }
    }

    protected void updateParentItems(TreeItem treeItem) {
        if (treeItem == null) {
            return;
        }
        if (this.updateItemCheckedState(treeItem)) {
            this.updateParentItems(treeItem.getParentItem());
        }
    }

    private boolean updateItemCheckedState(TreeItem treeItem) {
        Object data = treeItem.getData();
        if (data == null) {
            return false;
        }
        treeItem.setGrayed(this.stateProvider.isGrayed(data));
        treeItem.setChecked(this.stateProvider.isChecked(data));
        return true;
    }

    protected boolean isInsidePreservingSelection() {
        return this.insidePreservingSelection;
    }

    protected void preservingSelection(Runnable updateCode) {
        this.insidePreservingSelection = true;
        try {
            super.preservingSelection(updateCode);
        }
        finally {
            this.insidePreservingSelection = false;
        }
    }

    public ITreeContentProvider getContentProvider() {
        return (ITreeContentProvider)super.getContentProvider();
    }

    public void addStrucureChangedListener(StrucureChangedListener listener) {
        this.listenerList.add((Object)listener);
    }

    public void removeStrucureChangedListener(StrucureChangedListener listener) {
        this.listenerList.remove((Object)listener);
    }

    protected void fireStrucureChanged() {
        for (final StrucureChangedListener listener : this.listenerList) {
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    listener.structureChanged((TreeViewer)ContainerFilteredCheckboxTreeViewer.this);
                }
            });
        }
    }

    public void add(Object parentElementOrTreePath, Object childElement) {
        this.fireStrucureChanged();
        super.add(parentElementOrTreePath, childElement);
    }

    public void add(Object parentElementOrTreePath, Object ... childElements) {
        this.fireStrucureChanged();
        super.add(parentElementOrTreePath, childElements);
    }

    protected void inputChanged(Object input, Object oldInput) {
        this.stateHolder.clear();
        this.fireStrucureChanged();
        super.inputChanged(input, oldInput);
    }

    public void insert(Object parentElementOrTreePath, Object element, int position) {
        this.fireStrucureChanged();
        super.insert(parentElementOrTreePath, element, position);
    }

    public void refresh() {
        this.fireStrucureChanged();
        super.refresh();
    }

    public void refresh(boolean updateLabels) {
        this.fireStrucureChanged();
        super.refresh(updateLabels);
    }

    public void refresh(Object element) {
        this.fireStrucureChanged();
        super.refresh(element);
    }

    public void refresh(Object element, boolean updateLabels) {
        this.fireStrucureChanged();
        super.refresh(element, updateLabels);
    }

    public void remove(Object elementsOrTreePaths) {
        this.fireStrucureChanged();
        super.remove(elementsOrTreePaths);
    }

    public void remove(Object parent, Object ... elements) {
        this.fireStrucureChanged();
        super.remove(parent, elements);
    }

    public void remove(Object ... elementsOrTreePaths) {
        this.fireStrucureChanged();
        super.remove(elementsOrTreePaths);
    }

    public void replace(Object parentElementOrTreePath, int index, Object element) {
        this.fireStrucureChanged();
        super.replace(parentElementOrTreePath, index, element);
    }

    public void setChildCount(Object elementOrTreePath, int count) {
        this.fireStrucureChanged();
        super.setChildCount(elementOrTreePath, count);
    }

    public void setContentProvider(IContentProvider provider) {
        if (!(provider instanceof ITreeContentProvider)) {
            throw new IllegalArgumentException("provider smust be instance of ITreeContentProvider");
        }
        this.fireStrucureChanged();
        super.setContentProvider(provider);
    }

    public void setHasChildren(Object elementOrTreePath, boolean hasChildren) {
        this.fireStrucureChanged();
        super.setHasChildren(elementOrTreePath, hasChildren);
    }

    public static interface StrucureChangedListener {
        public void structureChanged(TreeViewer var1);
    }
}

