/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.jface.viewers;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.eclipse.jface.viewers.ITreeContentProvider;

public class TreeContentCheckStateHolder {
    private final Set<Object> selectedElements = new HashSet<Object>();
    private final Supplier<ITreeContentProvider> contentProviderSupplier;

    public TreeContentCheckStateHolder(Supplier<ITreeContentProvider> contentProviderSupplier) {
        this.contentProviderSupplier = contentProviderSupplier;
    }

    public void clear() {
        this.selectedElements.clear();
    }

    public Object[] getCheckedElements() {
        return this.selectedElements.toArray();
    }

    public boolean isChecked(Object element) {
        return this.selectedElements.contains(element);
    }

    public boolean isChildChecked(Object element) {
        Object[] children = this.contentProviderSupplier.get().getChildren(element);
        if (children == null) {
            return false;
        }
        Object[] objectArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object chid = objectArray[n2];
            if (this.isChecked(chid) || this.isChildChecked(chid)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setChecked(Object element, boolean checked) {
        this.applyState(element, checked);
        this.updateChildrenElements(element, checked);
        this.updateParentElement(element, checked);
    }

    protected void applyState(Object element, boolean checked) {
        if (checked) {
            this.selectedElements.add(element);
        } else {
            this.selectedElements.remove(element);
        }
    }

    protected void updateChildrenElements(Object element, boolean checked) {
        Object[] children = this.contentProviderSupplier.get().getChildren(element);
        if (children == null) {
            return;
        }
        Object[] objectArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            this.applyState(child, checked);
            this.updateChildrenElements(child, checked);
            ++n2;
        }
    }

    protected void updateParentElement(Object element, boolean checked) {
        ITreeContentProvider contentProvider = this.contentProviderSupplier.get();
        Object parent = contentProvider.getParent(element);
        if (parent == null) {
            return;
        }
        if (checked) {
            Object[] objectArray = contentProvider.getChildren(parent);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (!this.isChecked(child)) {
                    checked = false;
                    break;
                }
                ++n2;
            }
        }
        this.applyState(parent, checked);
        this.updateParentElement(parent, checked);
    }
}

