/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkproject;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.provider.toolchainproject.ISdkComponentInProject;
import java.util.Objects;
import org.osgi.framework.Version;

public class SdkComponentInProject
implements ISdkComponentInProject {
    @NonNull
    private final String compId;
    @Nullable
    private final String versionStr;
    @Nullable
    private final String revisionStr;

    public SdkComponentInProject(@NonNull String compId, @Nullable String version) {
        this.revisionStr = null;
        this.compId = compId;
        this.versionStr = version;
    }

    public String getID() {
        return this.compId;
    }

    public String getVersionStr() {
        return this.versionStr;
    }

    public Version getVersion() {
        String strVersion = this.getVersionStr();
        return strVersion != null ? new Version(strVersion) : null;
    }

    public @Nullable String getRevision() {
        return this.revisionStr;
    }

    public String toString() {
        return String.valueOf(this.compId) + ", " + 'v' + UtilsText.safeString((String)this.versionStr) + (this.revisionStr != null ? "[" + this.revisionStr + "]" : "");
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.compId.hashCode();
        result = 31 * result + Objects.hashCode(this.versionStr);
        result = 31 * result + Objects.hashCode(this.revisionStr);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SdkComponentInProject other = (SdkComponentInProject)obj;
        return this.compId.equals(other.compId) && Objects.equals(this.versionStr, other.versionStr) && Objects.equals(this.revisionStr, other.revisionStr);
    }
}

