/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkproject;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.provider.SWToolsPlatform;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.toolchainproject.EclipseProjectAdapterParams;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectWithSdk;
import com.nxp.swtools.sdkproject.internal.ToolchainProject4ConfigTools;
import java.nio.file.Path;
import java.util.Objects;
import java.util.logging.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class ToolchainProjectFactory {
    @NonNull
    protected static final Logger LOGGER = LogManager.getLogger(ToolchainProjectFactory.class);

    public static @NonNull IToolchainProjectWithSdk createToolchainProjectForImport(@NonNull Path toolchainPrjPath, @Nullable IProgressMonitor monitor) {
        assert (!SWToolsPlatform.isRunningInEclipseIde());
        return new ToolchainProject4ConfigTools(toolchainPrjPath, monitor);
    }

    public static @Nullable IToolchainProjectWithSdk createToolchainProjectForImport(@NonNull IProject eclipsePrj) {
        assert (SWToolsPlatform.isRunningInEclipseIde());
        @Nullable IToolchainProjectWithSdk prj = (IToolchainProjectWithSdk)Platform.getAdapterManager().getAdapter((Object)new EclipseProjectAdapterParams(null, eclipsePrj), IToolchainProjectWithSdk.class);
        if (Objects.isNull(prj)) {
            prj = (IToolchainProjectWithSdk)Adapters.adapt((Object)new EclipseProjectAdapterParams(null, eclipsePrj), IToolchainProjectWithSdk.class, (boolean)true);
        }
        return prj;
    }

    public static @NonNull IToolchainProjectWithSdk getToolchainProjectForJUnitTests(@NonNull Path toolchainPrjPath, @NonNull IProcessorMasterToolInfo processor, @NonNull String partNumber) {
        return new ToolchainProject4ConfigTools(toolchainPrjPath, processor, partNumber);
    }

    public static @Nullable IProject getEclipseProjectFromToolchainProject() {
        assert (SWToolsPlatform.isRunningInEclipseIde());
        @Nullable IToolchainProjectWithSdk prj = SharedConfigurationFactory.getSharedConfigurationSingleton().getToolchainProject();
        if (prj != null) {
            return prj.getEclipseProject();
        }
        return null;
    }
}

