/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkproject.parsers;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.files.XmlDomProvider;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.common.utils.xml.UtilsW3cXml;
import com.nxp.swtools.common.utils.xml.W3cElementListIterator;
import com.nxp.swtools.configuration.logging.UserLogger;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectWithSdk;
import com.nxp.swtools.sdkproject.Messages;
import com.nxp.swtools.sdkproject.SdkComponentInProject;
import com.nxp.swtools.sdkproject.parsers.GenericPrjAdapterWithCmsisParser;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

abstract class GenericEclipsePrjAdapter
extends GenericPrjAdapterWithCmsisParser {
    @NonNull
    public static final String ECLIPSE_PROJECT_FILENAME = ".project";
    @NonNull
    public static final String ECLIPSE_CPROJECT_FILENAME = ".cproject";

    GenericEclipsePrjAdapter(@NonNull File prjFile, @NonNull File prjDir, @NonNull IToolchainProjectWithSdk existingProcessorDetector) {
        super(prjFile, prjDir, existingProcessorDetector);
    }

    private static @NonNull String replaceEnvVariable(@NonNull String uri) {
        String endStr;
        if (uri.startsWith("${")) {
            endStr = "}";
        } else if (uri.startsWith("$%7B")) {
            endStr = "%7D";
        } else {
            return uri;
        }
        int endPos = uri.indexOf(endStr);
        if (endPos <= endStr.length() + 2) {
            return uri;
        }
        String envVariable = uri.substring(1 + endStr.length(), endPos);
        if (!envVariable.matches("[a-z,A-Z,_][a-z,A-Z,_,0-9]*")) {
            return uri;
        }
        String value = System.getenv(envVariable);
        if (value == null) {
            String logMsg = String.valueOf(Messages.get().ImportToolchainProject_LogMissingEnvVariable) + " " + envVariable;
            LOGGER.severe(logMsg);
            UserLogger.error((String)logMsg, (String)"Toolchain/IDE project", null);
            return uri;
        }
        return String.valueOf(value) + UtilsFile.convertToOSPathFormat((String)uri.substring(endPos + endStr.length()));
    }

    private void retrieveLinkedSources(@NonNull Element root, @NonNull Set<@NonNull Path> prjSources) {
        ArrayList<@NonNull E> linkElems = new ArrayList();
        UtilsW3cXml.findElementsOnPath((Element)root, (String)"linkedResources/link", linkElems, (UtilsW3cXml.ISearchElemsFilter)UtilsW3cXml.SEARCH_ALL_ELEMS_NONRECUSIVELY, null, null);
        Path prjRootDir = Objects.requireNonNull(this.getToolchainPrjFilePath().getParent());
        for (Element elem : linkElems) {
            Element typeElem = UtilsW3cXml.findFirstElement((Element)elem, (String)"type", (UtilsW3cXml.ISearchElemsFilter)UtilsW3cXml.SEARCH_ALL_ELEMS_NONRECUSIVELY, null);
            if (typeElem == null || !"1".equals(typeElem.getTextContent())) continue;
            Element locUriElem = UtilsW3cXml.findFirstElement((Element)elem, (String)"locationURI", (UtilsW3cXml.ISearchElemsFilter)UtilsW3cXml.SEARCH_ALL_ELEMS_NONRECUSIVELY, null);
            if (locUriElem == null) {
                locUriElem = UtilsW3cXml.findFirstElement((Element)elem, (String)"location", (UtilsW3cXml.ISearchElemsFilter)UtilsW3cXml.SEARCH_ALL_ELEMS_NONRECUSIVELY, null);
            }
            if (locUriElem != null) {
                String locURI = GenericEclipsePrjAdapter.replaceEnvVariable(UtilsText.safeString((String)locUriElem.getTextContent()));
                if (locURI.startsWith("PARENT-") && "-PROJECT_LOC/".equals(locURI.substring(8, 21)) && locURI.charAt(7) >= '0' && locURI.charAt(7) <= '9') {
                    Path filePath = Paths.get(UtilsFile.convertToOSPathFormat((String)locURI.substring(21)), new String[0]);
                    int parent = locURI.charAt(7) - 48;
                    while (--parent >= 0) {
                        filePath = Paths.get("..", new String[0]).resolve(filePath);
                    }
                    if (!prjRootDir.resolve(filePath).normalize().toFile().isFile()) {
                        LOGGER.severe("Project file not found: " + filePath.toString());
                        continue;
                    }
                    prjSources.add(filePath);
                    continue;
                }
                File locFile = new File(locURI);
                if (locFile.isAbsolute()) {
                    prjSources.add(locFile.toPath());
                    continue;
                }
                LOGGER.severe("Failed to parse `locationURI`: " + locURI);
                continue;
            }
            LOGGER.severe("`locationURI` element not found in `" + elem.toString() + '`');
        }
    }

    private void retrieveSourcesOnDisk(@NonNull Path prjRoot, @NonNull File dir, @NonNull Set<@NonNull Path> prjSources) {
        File[] files = dir.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    this.retrieveSourcesOnDisk(prjRoot, file, prjSources);
                } else if (file.getName().endsWith(".c") || file.getName().endsWith(".h")) {
                    prjSources.add(prjRoot.relativize(file.toPath()));
                }
                ++n2;
            }
        }
    }

    protected @NonNull List<@NonNull Element> retrieveCProjectOptions(@NonNull Element root, final @NonNull String optionId) {
        return UtilsW3cXml.findXmlElements((Element)root, (String)"option", (UtilsW3cXml.ISearchElemsFilter)new UtilsW3cXml.SearchElemsRecursiveAdapter(){

            public boolean accept(@NonNull Element elem, @Nullable Object data) {
                return UtilsText.safeString((String)elem.getAttribute("id")).startsWith(optionId);
            }
        }, null);
    }

    protected @NonNull Collection<@NonNull String> getCProjectListOptionValues(@NonNull Element root, @NonNull String optionId) {
        HashSet<@NonNull String> result = new HashSet<String>();
        List<@NonNull Element> options = this.retrieveCProjectOptions(root, optionId);
        for (Element inclPathElem : options) {
            W3cElementListIterator iter = new W3cElementListIterator(inclPathElem.getElementsByTagName("listOptionValue"));
            while (iter.hasNext()) {
                result.add(UtilsText.safeString((String)iter.next().getAttribute("value")));
            }
        }
        return result;
    }

    protected abstract boolean parseCProject(@NonNull Element var1, @NonNull List<@NonNull Path> var2, @NonNull Collection<@NonNull SdkComponentInProject> var3, @NonNull IProgressMonitor var4);

    @Override
    boolean parse(@NonNull Element root, @NonNull Collection<@NonNull SdkComponentInProject> componentsInPrjFile, @NonNull Set<@NonNull Path> prjSources, @NonNull List<@NonNull Path> inclPaths, @NonNull IProgressMonitor monitor) {
        boolean result = this.parseCProject(root, inclPaths, componentsInPrjFile, monitor);
        if (!result) {
            return false;
        }
        String projectFilePath = this.prjPath.resolve(ECLIPSE_PROJECT_FILENAME).toString();
        Document projectDoc = XmlDomProvider.getAsW3CDom((String)projectFilePath, null);
        if (projectDoc == null) {
            LOGGER.severe("Failed to load XML file: " + projectFilePath);
            return false;
        }
        Element projectRoot = projectDoc.getDocumentElement();
        assert (projectRoot != null);
        monitor.worked(10);
        this.retrieveLinkedSources(projectRoot, prjSources);
        monitor.worked(10);
        Path prjRoot = Objects.requireNonNull(this.getToolchainPrjFilePath().getParent());
        this.retrieveSourcesOnDisk(prjRoot, prjRoot.toFile(), prjSources);
        monitor.worked(10);
        Element prjNameElem = UtilsW3cXml.findFirstElement((Element)projectRoot, (String)"name", (UtilsW3cXml.ISearchElemsFilter)UtilsW3cXml.SEARCH_ALL_ELEMS_NONRECUSIVELY, null);
        if (prjNameElem != null) {
            this.detectedProjectName = Objects.requireNonNull(prjNameElem.getTextContent()).trim();
        }
        return result;
    }

    protected boolean retrieveProcessorFromDefinedSymbols(@NonNull Collection<@NonNull String> symbols) {
        boolean result = false;
        for (String defSymbol : symbols) {
            if (!defSymbol.startsWith("CPU_")) continue;
            int pos = defSymbol.indexOf(61);
            if (pos > 0) {
                defSymbol = defSymbol.substring(0, pos);
            }
            if (!this.setDetectedPartNumberFromSymbol(defSymbol.substring(4))) continue;
            result = true;
        }
        return result;
    }
}

