/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.efuse.model.mcu;

import com.nxp.annotation.Nullable;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.efuse.model.FuseWord;
import com.nxp.swtools.efuse.model.mcu.IMcu;
import com.nxp.swtools.efuse.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.efuse.xml.settings.EfuseXmlConfiguration;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class Mcu
implements IMcu {
    private final IMcuIdentification mcuIdentification;
    private final Collection<@NonNull ProcessorCore> cores;
    private final IProcessorMasterToolInfo masterToolInfo;
    private EfuseXmlConfiguration eFuseXmlConfig;
    private List<FuseWord> allFuseWords = new ArrayList<FuseWord>();
    private List<ABaseUIComponentSetting> allGuiComponentSettings = new ArrayList<ABaseUIComponentSetting>();
    private ByteBuffer templateAppBinaryContent = ByteBuffer.allocate(0);
    private ByteBuffer elfTemplateAppBinaryContent = ByteBuffer.allocate(0);

    public Mcu(IMcuIdentification mcuIdentification, Collection<ProcessorCore> cores, IProcessorMasterToolInfo masterToolInfo, EfuseXmlConfiguration eFuseXmlConfig) {
        this.mcuIdentification = mcuIdentification;
        this.cores = cores;
        this.masterToolInfo = masterToolInfo;
        this.eFuseXmlConfig = eFuseXmlConfig;
        this.allGuiComponentSettings = new ArrayList<ABaseUIComponentSetting>();
    }

    public @NonNull String getPartNumber() {
        return this.mcuIdentification.getMcu();
    }

    public @NonNull String getSeries() {
        return this.masterToolInfo.getSeries();
    }

    public @NonNull String getFamily() {
        return this.masterToolInfo.getFamily();
    }

    public @NonNull String getDataVersion() {
        return this.masterToolInfo.getVersion();
    }

    public @NonNull JSONObject getCoresList() {
        JSONObject res = new JSONObject();
        for (ProcessorCore oneCore : this.cores) {
            JSONObject core = new JSONObject();
            try {
                core.put("core", (Object)oneCore.getName());
                core.put("id", (Object)oneCore.getID());
                core.put("description", (Object)oneCore.getDescription());
                core.put("enabled", true);
                res.put(oneCore.getID(), (Object)core);
            }
            catch (JSONException e) {
                assert (false) : e.getMessage();
            }
        }
        return res;
    }

    public String getPackage() {
        return this.mcuIdentification.getPackage();
    }

    public String getSdkVersion() {
        return this.mcuIdentification.getSdkVersion();
    }

    public @Nullable String getBoard() {
        return this.mcuIdentification.getBoard();
    }

    public @Nullable String getKit() {
        return this.mcuIdentification.getKit();
    }

    public @Nullable String getMexVariant() {
        return this.mcuIdentification.getMexVariant();
    }

    @Override
    public @NonNull IMcuIdentification getMcuIdentification() {
        return this.mcuIdentification;
    }

    @Override
    public @NonNull Collection<@NonNull ProcessorCore> getCores() {
        return this.cores;
    }

    @Override
    public EfuseXmlConfiguration getEfuseXmlConfig() {
        return this.eFuseXmlConfig;
    }

    @Override
    public List<ABaseUIComponentSetting> getAllGuiComponentSettings() {
        return this.allGuiComponentSettings;
    }

    @Override
    public List<FuseWord> getAllFuseWords() {
        return this.allFuseWords;
    }

    @Override
    public ByteBuffer getTemplateAppBinaryContent() {
        return this.templateAppBinaryContent;
    }

    @Override
    public void setTemplateAppBinaryContent(ByteBuffer binaryTemplate) {
        this.templateAppBinaryContent = binaryTemplate;
    }

    @Override
    public ByteBuffer getElfTemplateAppBinaryContent() {
        return this.elfTemplateAppBinaryContent;
    }

    @Override
    public void setElfTemplateAppBinaryContent(ByteBuffer binaryTemplate) {
        this.elfTemplateAppBinaryContent = binaryTemplate;
    }
}

