/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.efuse.model.mcu;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsDecryption;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.efuse.model.FuseField;
import com.nxp.swtools.efuse.model.FuseWord;
import com.nxp.swtools.efuse.model.mcu.IMcu;
import com.nxp.swtools.efuse.model.mcu.Mcu;
import com.nxp.swtools.efuse.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.efuse.ui.xml.settings.BoolSetting;
import com.nxp.swtools.efuse.ui.xml.settings.EnumSetting;
import com.nxp.swtools.efuse.ui.xml.settings.IntegerSetting;
import com.nxp.swtools.efuse.ui.xml.settings.StructSetting;
import com.nxp.swtools.efuse.ui.xml.settings.TabSetting;
import com.nxp.swtools.efuse.xml.settings.EfuseXmlConfiguration;
import com.nxp.swtools.efuse.xml.settings.FieldSetting;
import com.nxp.swtools.efuse.xml.settings.FuseFieldsTable;
import com.nxp.swtools.efuse.xml.settings.FuseSetting;
import com.nxp.swtools.efuse.xml.settings.FuseWordsTable;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.provider.SWToolsPlatform;
import com.nxp.swtools.provider.configuration.ICommonConfig;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.utils.resources.DataDirectoryUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class McuFactory {
    private static final Logger LOGGER = LogManager.getLogger(McuFactory.class);

    public static @Nullable IMcu create(ISupportedDerivativesForSwTools supportedDerivatives, ICommonConfig commonConfig) {
        File elfTemplateAppFile;
        IMcuIdentification mcuSelection = commonConfig.getMcuIdentification();
        String sdkVersion = mcuSelection.getSdkVersion();
        String mcuName = mcuSelection.getMcu();
        SWToolsPlatform.CoresInfoLoader coresInfo = SWToolsPlatform.getCoresInfo((String)mcuName, (String)sdkVersion, (ISupportedDerivativesForSwTools)supportedDerivatives);
        ArrayList<ProcessorCore> cores = coresInfo == null ? new ArrayList<ProcessorCore>() : coresInfo.cores;
        IProcessorMasterToolInfo masterToolInfo = supportedDerivatives.getProcessorMasterToolInfo(mcuName, sdkVersion);
        assert (masterToolInfo != null);
        String eFuseXmlModelFile = DataDirectoryUtils.getDbFile((IMcuIdentification)mcuSelection, (String)"efuse_model");
        if (eFuseXmlModelFile.isEmpty()) {
            if (SWToolsProperties.isVerificationOn()) {
                LOGGER.severe("Cannot load eFUSE configuration for: " + mcuSelection);
            }
            return null;
        }
        String eFuseXmlFilePath = String.valueOf(supportedDerivatives.getDataDir()) + File.separator + eFuseXmlModelFile + File.separator + mcuName + ".xml";
        EfuseXmlConfiguration eFuseConfig = McuFactory.getEfuseXmlConfig(eFuseXmlFilePath);
        if (eFuseConfig == null) {
            if (SWToolsProperties.isVerificationOn()) {
                LOGGER.severe("Cannot read the xml file for: " + mcuSelection);
            }
            return null;
        }
        Mcu mcu = new Mcu(mcuSelection, cores, masterToolInfo, eFuseConfig);
        mcu.getAllFuseWords().addAll(McuFactory.getAllFuseWords(eFuseConfig));
        mcu.getAllGuiComponentSettings().addAll(McuFactory.getAllUIComponentsSettings(eFuseConfig));
        File templateAppFile = new File(String.valueOf(supportedDerivatives.getDataDir()) + File.separator + eFuseXmlModelFile + File.separator + "templateApplication.bin");
        if (templateAppFile.exists()) {
            McuFactory.readTemplateBinaryContentFromFile(templateAppFile, mcu);
        }
        if ((elfTemplateAppFile = new File(String.valueOf(supportedDerivatives.getDataDir()) + File.separator + eFuseXmlModelFile + File.separator + "templateApplication.elf")).exists()) {
            McuFactory.readElfTemplateBinaryContentFromFile(elfTemplateAppFile, mcu);
        }
        return mcu;
    }

    private static void readTemplateBinaryContentFromFile(File templateAppFile, IMcu selectedMcu) {
        try {
            byte[] data = Files.readAllBytes(Paths.get(templateAppFile.getPath(), new String[0]));
            ByteBuffer templateBinaryContent = ByteBuffer.allocate(data.length);
            templateBinaryContent.put(data);
            selectedMcu.setTemplateAppBinaryContent(templateBinaryContent);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Error while reading from file ", e);
        }
    }

    private static void readElfTemplateBinaryContentFromFile(File templateAppFile, IMcu selectedMcu) {
        try {
            byte[] data = Files.readAllBytes(Paths.get(templateAppFile.getPath(), new String[0]));
            ByteBuffer templateBinaryContent = ByteBuffer.allocate(data.length);
            templateBinaryContent.put(data);
            selectedMcu.setElfTemplateAppBinaryContent(templateBinaryContent);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Error while reading from file ", e);
        }
    }

    private static @Nullable EfuseXmlConfiguration getEfuseXmlConfig(String filePath) {
        File eFuseConfigFile = new File(filePath);
        if (!eFuseConfigFile.exists()) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream eFuseConfInStr = UtilsDecryption.getFileInputStream((File)eFuseConfigFile);){
                EfuseXmlConfiguration eFuseConfig = EfuseXmlConfiguration.loadEfuseXmlConfig(eFuseConfInStr);
                if (eFuseConfig != null) {
                    return eFuseConfig;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOGGER.severe("Cannot read the eFUSE config file." + e.getMessage());
        }
        return null;
    }

    private static List<FuseWord> getAllFuseWords(EfuseXmlConfiguration eFuseConfig) {
        ArrayList<FuseWord> fuses = new ArrayList<FuseWord>();
        FuseWordsTable xmlFusesTable = eFuseConfig.getFusesList();
        for (FuseSetting fuseSetting : xmlFusesTable.getFusesList()) {
            FuseWord newFuseWord = new FuseWord(fuseSetting);
            McuFactory.setFieldsList(newFuseWord);
            fuses.add(newFuseWord);
        }
        return fuses;
    }

    private static void setFieldsList(FuseWord fuseWord) {
        FuseSetting fuseSetting = fuseWord.getXmlSetting();
        FuseFieldsTable fieldsTable = fuseSetting.getFuseFields();
        if (fieldsTable != null) {
            for (FieldSetting fieldSetting : fieldsTable.getFieldsList()) {
                FuseField field = new FuseField(fieldSetting, fuseWord);
                fuseWord.getFuseFields().add(field);
            }
        }
    }

    private static List<ABaseUIComponentSetting> getAllUIComponentsSettings(EfuseXmlConfiguration eFuseConfig) {
        ArrayList<ABaseUIComponentSetting> allUIComponents = new ArrayList<ABaseUIComponentSetting>();
        for (TabSetting tabSetting : eFuseConfig.getLayoutComponents().getTabSettings()) {
            StructSetting tabContent = tabSetting.getTabContent();
            McuFactory.addToListAllScalarSettingFromStruct(tabContent, allUIComponents);
        }
        return allUIComponents;
    }

    private static void addToListAllScalarSettingFromStruct(StructSetting structSetting, List<ABaseUIComponentSetting> list) {
        McuFactory.initCurrentValuesForAllScalarComponents(structSetting);
        list.addAll(structSetting.getChildrenComponents());
        for (StructSetting childStruct : structSetting.getStructSettings()) {
            McuFactory.addToListAllScalarSettingFromStruct(childStruct, list);
        }
    }

    private static void initCurrentValuesForAllScalarComponents(StructSetting structSetting) {
        for (BoolSetting boolSetting : structSetting.getBoolSettings()) {
            boolSetting.setCurrentValue(boolSetting.getInitValue());
        }
        for (EnumSetting enumSetting : structSetting.getEnumSettings()) {
            enumSetting.setCurrentValue(enumSetting.getInitValue());
        }
        for (IntegerSetting integerSetting : structSetting.getIntegerSettings()) {
            integerSetting.setCurrentValue(integerSetting.getInitValue());
        }
    }
}

