/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.efuse.model.utils;

import com.nxp.swtools.bootimage.utils.BootUtils;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.number.NumberFormatValidator;
import com.nxp.swtools.efuse.model.FuseField;
import com.nxp.swtools.efuse.model.FuseWord;
import com.nxp.swtools.efuse.model.mcu.IMcu;
import com.nxp.swtools.efuse.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.efuse.ui.xml.settings.BoolSetting;
import com.nxp.swtools.efuse.ui.xml.settings.EnumSetting;
import com.nxp.swtools.efuse.ui.xml.settings.IntegerSetting;
import com.nxp.swtools.efuse.ui.xml.settings.ItemSetting;
import com.nxp.swtools.efuse.xml.settings.FuseStructSetting;
import com.nxp.swtools.efuse.xml.settings.HeaderSetting;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class EfuseUtils {
    public static final Pattern PARENTHESIS_GROUP_REGEX = Pattern.compile("\\((.*?)\\)", 8);
    private static boolean isSwitchingBetweenModesInProgress = false;
    private static Mode currentMode = Mode.STANDARD;
    private static boolean isImportProcessRunning = false;

    public static void calculateFuseValueBasedOnFields(FuseWord fuseWord) {
        if (!fuseWord.getFuseFields().isEmpty()) {
            long fuseValue = 0L;
            for (FuseField fuseField : fuseWord.getFuseFields()) {
                int fieldOffset = fuseField.getXmlSetting().getOffset();
                int fieldSize = fuseField.getXmlSetting().getSizeValueInBits();
                long fieldValueInWord = fuseField.getValueToWrite() << fieldOffset - fieldSize + 1;
                if ((fuseValue & fieldValueInWord) == fieldValueInWord) continue;
                fuseValue = fuseValue + fieldValueInWord & 0xFFFFFFFFFFFFFFFFL;
            }
            fuseWord.setValueToWrite(fuseValue);
        }
    }

    public static @Nullable FuseWord getFuseWordByID(List<FuseWord> allFuses, String id) {
        for (FuseWord fuseWord : allFuses) {
            if (!id.equalsIgnoreCase(fuseWord.getXmlSetting().getId())) continue;
            return fuseWord;
        }
        return null;
    }

    public static @Nullable FuseField getFuseFieldByID(FuseWord parentFuse, String id) {
        for (FuseField field : parentFuse.getFuseFields()) {
            if (!id.equalsIgnoreCase(field.getXmlSetting().getId())) continue;
            return field;
        }
        return null;
    }

    public static long getLongValueFromString(String valueStr) {
        if (NumberFormatValidator.isValidXmlHexFormat((String)valueStr)) {
            return NumberFormatValidator.getDecimalLongFromXmlHex((String)valueStr);
        }
        return NumberFormatValidator.getLongValueFromString((String)valueStr);
    }

    public static long getValueBasedOnBitOperation(long value, String operator, long mask) {
        switch (operator) {
            case "AND": {
                return value & mask;
            }
            case "OR": {
                return value | mask;
            }
            case "<<": {
                return value << (int)mask;
            }
            case ">>": {
                return value >> (int)mask;
            }
            case ">>>": {
                return value >>> (int)mask;
            }
        }
        return 0L;
    }

    public static byte[] extractBytesFromBinaryImage(byte[] binaryInput, int offset, int size) {
        byte[] extractedBytes = new byte[size];
        int i = 0;
        while (i < size) {
            extractedBytes[i] = binaryInput[offset + i];
            ++i;
        }
        return extractedBytes;
    }

    public static long getUIComponentDefaultValue(ABaseUIComponentSetting componentSetting) {
        long defaultValue = 0L;
        if (componentSetting instanceof BoolSetting) {
            BoolSetting boolSetting = (BoolSetting)componentSetting;
            defaultValue = boolSetting.getDefaultValue() ? 1L : 0L;
        } else if (componentSetting instanceof EnumSetting) {
            EnumSetting enumSetting = (EnumSetting)componentSetting;
            ItemSetting defaultSelectedItem = enumSetting.getItemById(enumSetting.getInitValue());
            if (defaultSelectedItem != null) {
                defaultValue = defaultSelectedItem.getValueToWrite();
            }
        } else if (componentSetting instanceof IntegerSetting) {
            defaultValue = ((IntegerSetting)componentSetting).getDefaultValue();
        }
        return defaultValue;
    }

    public static @Nullable ABaseUIComponentSetting getComponentSettingById(IMcu mcu, String id) {
        for (ABaseUIComponentSetting component : mcu.getAllGuiComponentSettings()) {
            if (!component.getFuseFieldID().equals(id)) continue;
            return component;
        }
        return null;
    }

    public static boolean isFuseFieldAssociatedWithMultipleComponents(IMcu mcu, String fuseFieldId) {
        return mcu.getAllGuiComponentSettings().stream().filter(c -> c.getFuseFieldID().equals(fuseFieldId)).count() > 1L;
    }

    public static @Nullable ABaseUIComponentSetting getComponentSettingByFuseWord(IMcu mcu, String id) {
        for (ABaseUIComponentSetting component : mcu.getAllGuiComponentSettings()) {
            if (!component.getParentFuseWordID().equals(id) || component.isEccField() || !component.getFuseFieldID().isEmpty()) continue;
            return component;
        }
        return null;
    }

    public static @Nullable ABaseUIComponentSetting getEccProtectedComponentSettingByFuseWord(IMcu mcu, String id) {
        for (ABaseUIComponentSetting component : mcu.getAllGuiComponentSettings()) {
            if (!component.getParentFuseWordID().equals(id) || !component.isEccField()) continue;
            return component;
        }
        return null;
    }

    public static List<String> getAllAndConditions(String condition) {
        String[] tempValuesBuffer;
        ArrayList<String> allConditions = new ArrayList<String>();
        String[] stringArray = tempValuesBuffer = condition.split("\\ And ");
        int n = tempValuesBuffer.length;
        int n2 = 0;
        while (n2 < n) {
            String tempStr = stringArray[n2];
            allConditions.add(tempStr);
            ++n2;
        }
        return allConditions;
    }

    public static int getSizeOfEntireFusesStruct(IMcu selectedMcu) {
        int size = 0;
        HeaderSetting efuseHeader = selectedMcu.getEfuseXmlConfig().getHeader();
        if (efuseHeader != null) {
            size += efuseHeader.getSizeValueInBytes();
        }
        for (FuseWord fuseWord : selectedMcu.getAllFuseWords()) {
            FuseStructSetting fuseStruct = fuseWord.getXmlSetting().getFuseStructure();
            if (fuseStruct == null) continue;
            size += fuseStruct.getSizeValueInBytes();
        }
        return size;
    }

    public static void setSwitchingBetweenModes(boolean value) {
        isSwitchingBetweenModesInProgress = value;
    }

    public static boolean isSwitchingBetweenModesInProgress() {
        return isSwitchingBetweenModesInProgress;
    }

    public static void setCurrentMode(Mode mode) {
        currentMode = mode;
    }

    public static Mode getCurrentMode() {
        return currentMode;
    }

    public static long getFuseFieldValueFromFuseWord(FuseField fuseField, FuseWord fuseWord) {
        int offset = fuseField.getXmlSetting().getOffset();
        int size = fuseField.getXmlSetting().getSizeValueInBits();
        long mask = BootUtils.getBitsMaskValue((int)offset, (int)size);
        return (fuseWord.getValueToWrite() & mask) >> offset - size + 1;
    }

    public static void setIsImportProcessRunning(boolean value) {
        isImportProcessRunning = value;
    }

    public static boolean isImportProcessRunning() {
        return isImportProcessRunning;
    }

    public static enum Mode {
        STANDARD("standard_mode"),
        ADVANCED("advanced_mode");

        private String tabId;

        private Mode(String tabId) {
            this.tabId = tabId;
        }

        public String getTabId() {
            return this.tabId;
        }
    }
}

