/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.efuse.model.utils;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.efuse.ui.xml.settings.BitsSetting;
import com.nxp.swtools.efuse.ui.xml.settings.BoolSetting;
import com.nxp.swtools.efuse.ui.xml.settings.EnumSetting;
import com.nxp.swtools.efuse.ui.xml.settings.IntegerSetting;
import com.nxp.swtools.efuse.ui.xml.settings.StructSetting;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EfuseXmlSettingsUtils {
    private static final Pattern CONDITION_REGEX = Pattern.compile("(.+)(=)(.+)");

    public static @Nullable BoolSetting getBoolSettingById(List<BoolSetting> boolSettings, String id) {
        for (BoolSetting setting : boolSettings) {
            if (!id.equals(setting.getId())) continue;
            return setting;
        }
        return null;
    }

    public static @Nullable EnumSetting getEnumSettingById(List<EnumSetting> enumSettings, String id) {
        for (EnumSetting setting : enumSettings) {
            if (!id.equals(setting.getId())) continue;
            return setting;
        }
        return null;
    }

    public static @Nullable IntegerSetting getIntegerSettingById(List<IntegerSetting> integerSettings, String id) {
        for (IntegerSetting setting : integerSettings) {
            if (!id.equals(setting.getId())) continue;
            return setting;
        }
        return null;
    }

    public static @Nullable StructSetting getStructSettingById(List<StructSetting> structSettings, String id) {
        for (StructSetting setting : structSettings) {
            if (!id.equals(setting.getId())) continue;
            return setting;
        }
        return null;
    }

    public static @Nullable BitsSetting getBitsSettingById(List<BitsSetting> bitsSettings, String id) {
        for (BitsSetting setting : bitsSettings) {
            if (!id.equals(setting.getId())) continue;
            return setting;
        }
        return null;
    }

    public static @Nullable String getConditionField(String condition) {
        Matcher matcher = CONDITION_REGEX.matcher(condition);
        if (matcher.find() && matcher.groupCount() == 3) {
            return matcher.group(1);
        }
        return "";
    }

    public static @Nullable String getConditionValue(String condition) {
        Matcher matcher = CONDITION_REGEX.matcher(condition);
        if (matcher.find() && matcher.groupCount() == 3) {
            return matcher.group(3);
        }
        return "";
    }
}

