/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.efuse.ui.xml.settings;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.efuse.model.utils.EfuseXmlSettingsUtils;
import com.nxp.swtools.efuse.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.efuse.ui.xml.settings.ArraySetting;
import com.nxp.swtools.efuse.ui.xml.settings.BitsSetting;
import com.nxp.swtools.efuse.ui.xml.settings.BoolSetting;
import com.nxp.swtools.efuse.ui.xml.settings.ButtonSetting;
import com.nxp.swtools.efuse.ui.xml.settings.EnumSetting;
import com.nxp.swtools.efuse.ui.xml.settings.IntegerSetting;
import com.nxp.swtools.efuse.ui.xml.settings.LayoutSetting;
import com.nxp.swtools.efuse.ui.xml.settings.LayoutType;
import com.nxp.swtools.efuse.ui.xml.settings.TextSetting;
import java.util.ArrayList;
import java.util.List;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Root(name="struct", strict=false)
public class StructSetting
extends ABaseUIComponentSetting {
    @Element(name="layout", required=false)
    private LayoutSetting layoutSetting;
    @ElementList(inline=true, required=false)
    private List<StructSetting> structSettings;
    @ElementList(inline=true, required=false)
    private List<BoolSetting> boolSettings;
    @ElementList(inline=true, required=false)
    private List<EnumSetting> enumSettings;
    @ElementList(inline=true, required=false)
    private List<IntegerSetting> integerSettings;
    @ElementList(inline=true, required=false)
    private List<BitsSetting> bitsSettings;
    @ElementList(inline=true, required=false)
    private List<ButtonSetting> buttonSettings;
    @ElementList(inline=true, required=false)
    private List<ArraySetting> arraySettings;
    @ElementList(inline=true, required=false)
    private List<TextSetting> textSettings;
    @Attribute(name="showBinaryConfiguration", required=false)
    private boolean showBinaryConfiguration;

    public StructSetting() {
        this.layoutSetting = new LayoutSetting();
        this.structSettings = new ArrayList<StructSetting>();
        this.boolSettings = new ArrayList<BoolSetting>();
        this.enumSettings = new ArrayList<EnumSetting>();
        this.integerSettings = new ArrayList<IntegerSetting>();
        this.bitsSettings = new ArrayList<BitsSetting>();
        this.buttonSettings = new ArrayList<ButtonSetting>();
        this.arraySettings = new ArrayList<ArraySetting>();
        this.textSettings = new ArrayList<TextSetting>();
        this.showBinaryConfiguration = false;
    }

    public StructSetting(String id, StructSetting structSetting) {
        super(id, structSetting);
        this.layoutSetting = structSetting.layoutSetting;
        this.structSettings = new ArrayList<StructSetting>(structSetting.structSettings);
        this.boolSettings = structSetting.boolSettings;
        this.enumSettings = new ArrayList<EnumSetting>();
        int i = 0;
        while (i < structSetting.enumSettings.size()) {
            EnumSetting enumS = new EnumSetting(structSetting.enumSettings.get(i), (ABaseUIComponentSetting)this);
            this.enumSettings.add(enumS);
            ++i;
        }
        this.integerSettings = new ArrayList<IntegerSetting>();
        i = 0;
        while (i < structSetting.integerSettings.size()) {
            IntegerSetting intS = new IntegerSetting(structSetting.integerSettings.get(i));
            this.integerSettings.add(intS);
            ++i;
        }
        this.bitsSettings = structSetting.bitsSettings;
        this.buttonSettings = structSetting.buttonSettings;
        this.arraySettings = structSetting.arraySettings;
        this.textSettings = structSetting.textSettings;
        this.showBinaryConfiguration = structSetting.showBinaryConfiguration;
    }

    public LayoutSetting getLayoutSetting() {
        return this.layoutSetting;
    }

    public List<StructSetting> getStructSettings() {
        return this.structSettings;
    }

    public @Nullable StructSetting getStructSettingById(String id) {
        return EfuseXmlSettingsUtils.getStructSettingById(this.structSettings, id);
    }

    public List<BoolSetting> getBoolSettings() {
        return this.boolSettings;
    }

    public @Nullable BoolSetting getBoolSettingById(String id) {
        return EfuseXmlSettingsUtils.getBoolSettingById(this.boolSettings, id);
    }

    public List<EnumSetting> getEnumSettings() {
        return this.enumSettings;
    }

    public @Nullable EnumSetting getEnumSettingById(String id) {
        return EfuseXmlSettingsUtils.getEnumSettingById(this.enumSettings, id);
    }

    public List<IntegerSetting> getIntegerSettings() {
        return this.integerSettings;
    }

    public @Nullable IntegerSetting getIntegerSettingById(String id) {
        return EfuseXmlSettingsUtils.getIntegerSettingById(this.integerSettings, id);
    }

    public List<BitsSetting> getBitsSettings() {
        return this.bitsSettings;
    }

    public @Nullable BitsSetting getBitsSettingById(String id) {
        return EfuseXmlSettingsUtils.getBitsSettingById(this.bitsSettings, id);
    }

    public List<ButtonSetting> getButtonSettings() {
        return this.buttonSettings;
    }

    public @Nullable ButtonSetting getButtonSettingById(String id) {
        for (ButtonSetting setting : this.buttonSettings) {
            if (!id.equalsIgnoreCase(setting.getId())) continue;
            return setting;
        }
        return null;
    }

    public List<ArraySetting> getArraySettings() {
        return this.arraySettings;
    }

    public @Nullable ArraySetting getArraySettingById(String id) {
        for (ArraySetting setting : this.arraySettings) {
            if (!id.equalsIgnoreCase(setting.getId())) continue;
            return setting;
        }
        return null;
    }

    public List<TextSetting> getTextSettings() {
        return this.textSettings;
    }

    public @Nullable TextSetting getTextSettingById(String id) {
        for (TextSetting setting : this.textSettings) {
            if (!id.equalsIgnoreCase(setting.getId())) continue;
            return setting;
        }
        return null;
    }

    public LayoutType getLayoutType() {
        return this.layoutSetting.getType();
    }

    public List<ABaseUIComponentSetting> getChildrenComponents() {
        ArrayList<ABaseUIComponentSetting> scalarComponents = new ArrayList<ABaseUIComponentSetting>();
        this.structSettings.forEach(setting -> {
            boolean bl = scalarComponents.add((ABaseUIComponentSetting)setting);
        });
        this.boolSettings.forEach(setting -> {
            boolean bl = scalarComponents.add((ABaseUIComponentSetting)setting);
        });
        this.enumSettings.forEach(setting -> {
            boolean bl = scalarComponents.add((ABaseUIComponentSetting)setting);
        });
        this.integerSettings.forEach(setting -> {
            boolean bl = scalarComponents.add((ABaseUIComponentSetting)setting);
        });
        this.bitsSettings.forEach(setting -> {
            boolean bl = scalarComponents.add((ABaseUIComponentSetting)setting);
        });
        this.arraySettings.forEach(setting -> {
            boolean bl = scalarComponents.add((ABaseUIComponentSetting)setting);
        });
        this.textSettings.forEach(setting -> {
            boolean bl = scalarComponents.add((ABaseUIComponentSetting)setting);
        });
        return scalarComponents;
    }

    @Override
    public long getValueToWrite() {
        return -1L;
    }

    public boolean shouldShowBinaryConfiguration() {
        return this.showBinaryConfiguration;
    }
}

