/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.efuse.xml.settings;

import com.nxp.swtools.efuse.model.utils.EfuseUtils;
import com.nxp.swtools.efuse.model.utils.EfuseXmlSettingsUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import org.simpleframework.xml.Attribute;

public class AComponentStateSetting {
    @Attribute(name="id", required=true)
    private String id;
    @Attribute(name="state", required=true)
    private boolean state = false;
    @Attribute(name="condition", required=true)
    private String condition;
    @Attribute(name="value_to_write", required=false)
    private String valueToWrite;

    public AComponentStateSetting(String id, boolean state, String condition, String valueToWrite) {
        this.id = id;
        this.state = state;
        this.condition = condition;
        this.valueToWrite = valueToWrite;
    }

    public AComponentStateSetting() {
        this.id = "";
        this.state = false;
        this.condition = "";
        this.valueToWrite = "";
    }

    public String getId() {
        return this.id;
    }

    public boolean getState() {
        return this.state;
    }

    public String getCondition() {
        return this.condition;
    }

    public long getValueToWrite() {
        return EfuseUtils.getLongValueFromString(this.valueToWrite);
    }

    public List<String> getAllOrConditions() {
        String[] tempValuesBuffer;
        ArrayList<String> allConditions = new ArrayList<String>();
        String[] stringArray = tempValuesBuffer = this.condition.split("\\|");
        int n = tempValuesBuffer.length;
        int n2 = 0;
        while (n2 < n) {
            String tempStr = stringArray[n2];
            allConditions.add(tempStr);
            ++n2;
        }
        return allConditions;
    }

    public List<String> getAllAndConditions() {
        return EfuseUtils.getAllAndConditions(this.condition);
    }

    public String getValueToWriteAsString() {
        return this.valueToWrite;
    }

    public boolean existsOrConditionWithFieldId(String condFieldId) {
        for (String conditionLoc : this.getAllOrConditions()) {
            Matcher parenthesisGroupMatcher = EfuseUtils.PARENTHESIS_GROUP_REGEX.matcher(conditionLoc);
            if (parenthesisGroupMatcher.find() && parenthesisGroupMatcher.groupCount() == 1) {
                String exprString = parenthesisGroupMatcher.group(1);
                if (exprString == null) continue;
                List<String> allAndConditions = EfuseUtils.getAllAndConditions(exprString);
                for (String andCondition : allAndConditions) {
                    String fieldId = EfuseXmlSettingsUtils.getConditionField(andCondition);
                    if (fieldId == null || !fieldId.equals(condFieldId)) continue;
                    return true;
                }
                continue;
            }
            String fieldId = EfuseXmlSettingsUtils.getConditionField(conditionLoc);
            if (fieldId == null || !fieldId.equals(condFieldId)) continue;
            return true;
        }
        return false;
    }
}

