/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.efuse.xml.settings;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.efuse.ui.xml.settings.LayoutComponents;
import com.nxp.swtools.efuse.xml.settings.ConstraintsTable;
import com.nxp.swtools.efuse.xml.settings.FuseWordsTable;
import com.nxp.swtools.efuse.xml.settings.HeaderSetting;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Persister;

@Root(name="config_efuse", strict=false)
@Namespace(prefix="efuse", reference="http://swtools.freescale.net/XSD/efuse/1.0")
public class EfuseXmlConfiguration {
    private static final Logger LOGGER = LogManager.getLogger(EfuseXmlConfiguration.class);
    @Attribute(name="schemaLocation", required=false)
    @Namespace(prefix="xsi", reference="http://www.w3.org/2001/XMLSchema-instance")
    private String schemaLocation;
    @Attribute(name="id", required=true)
    private String id;
    @Attribute(name="label", required=false)
    private String label;
    @Element(name="fuses", required=true)
    private FuseWordsTable fuses;
    @Element(name="layout_components", required=true)
    private LayoutComponents layoutComponents;
    @Element(name="constraints", required=false)
    private ConstraintsTable contraints;
    @ElementList(inline=true)
    private List<HeaderSetting> headerList;

    public EfuseXmlConfiguration(String id, String label, FuseWordsTable fuses, LayoutComponents layoutComponents, ConstraintsTable constraints, List<HeaderSetting> headerList) {
        this.schemaLocation = "http://swtools.freescale.net/XSD/efuse/1.0 http://swtools.freescale.net/XSD/efuse/1.0/efuse.xsd";
        this.id = id;
        this.label = label;
        this.fuses = fuses;
        this.layoutComponents = layoutComponents;
        this.contraints = constraints;
        this.headerList = headerList;
    }

    public EfuseXmlConfiguration() {
        this.schemaLocation = "";
        this.id = "";
        this.label = "";
        this.fuses = new FuseWordsTable();
        this.layoutComponents = new LayoutComponents();
        this.contraints = new ConstraintsTable();
        this.headerList = new ArrayList<HeaderSetting>();
    }

    public static @Nullable EfuseXmlConfiguration loadEfuseXmlConfig(InputStream xmlFile) {
        try {
            Persister serializer = new Persister();
            EfuseXmlConfiguration eFuseConfig = (EfuseXmlConfiguration)serializer.read(EfuseXmlConfiguration.class, xmlFile);
            return eFuseConfig;
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Error loading the eFuse definition xml. Exception: " + ex);
            return null;
        }
    }

    public FuseWordsTable getFusesList() {
        return this.fuses;
    }

    public LayoutComponents getLayoutComponents() {
        return this.layoutComponents;
    }

    public ConstraintsTable getConstraints() {
        return this.contraints;
    }

    public List<HeaderSetting> getHeaderList() {
        return this.headerList;
    }

    public @Nullable HeaderSetting getHeader() {
        for (HeaderSetting header : this.headerList) {
            if (!header.getId().equals("efuse_header")) continue;
            return header;
        }
        return null;
    }

    public @Nullable HeaderSetting getSerialBootHeader() {
        for (HeaderSetting header : this.headerList) {
            if (!header.getId().equals("serial_boot_header")) continue;
            return header;
        }
        return null;
    }
}

