/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.cdt.dsf.cmd;

import com.nxp.s32ds.ext.cdt.dsf.DsfRequest;
import com.nxp.s32ds.ext.cdt.dsf.DsfRequestType;
import com.nxp.s32ds.ext.cdt.dsf.DsfRequestor;
import com.nxp.s32ds.ext.cdt.dsf.DsfResponse;
import com.nxp.s32ds.ext.cdt.dsf.DsfSessionInactiveException;
import com.nxp.s32ds.ext.cdt.dsf.cmd.DsfCmdErrorCode;
import com.nxp.s32ds.ext.cdt.dsf.session.DsfSessionDsfServiceTrackerManager;
import com.nxp.s32ds.ext.cdt.internal.dsf.CdtDsfActivator;
import com.nxp.s32ds.ext.cdt.internal.dsf.DsfCmdAnswerParser;
import com.nxp.s32ds.ext.cdt.internal.dsf.Messages;
import com.nxp.s32ds.ext.rcp.statushandlers.RcpStatusHandlers;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateDataRequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.command.commands.CLICommand;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConsoleStreamOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOOBRecord;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;

public abstract class DsfCmdRequestor<B, V, R>
extends DsfRequestor<B, V, R> {
    public static final String ERROR_HANDLER = "com.nxp.s32ds.ext.cdt.dsf.cmd.error.handler";

    @Override
    protected CompletableFuture<DsfResponse<B, R>> performRead(final DsfRequest<B, ?> request) throws DsfSessionInactiveException {
        IGDBControl gdbControl = (IGDBControl)DsfSessionDsfServiceTrackerManager.getInstance().computeIfAbsent(request.session).getService(IGDBControl.class);
        if (gdbControl == null || !gdbControl.isActive()) {
            throw new DsfSessionInactiveException(request.session);
        }
        final CompletableFuture<DsfResponse<B, R>> future = new CompletableFuture<DsfResponse<B, R>>();
        IRunControl.IContainerDMContext containerContext = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)request.idmContext, IRunControl.IContainerDMContext.class);
        final String command = this.getReadCommand(request);
        CLICommand cliCommand = new CLICommand((IDMContext)containerContext, this.getReadCommand(request));
        DataRequestMonitor<MIInfo> monitor = new DataRequestMonitor<MIInfo>((Executor)request.session.getExecutor(), null){

            protected void handleSuccess() {
                try {
                    DsfResponse svdDsfResponse = new DsfResponse(request);
                    MIOOBRecord[] outputRecords = ((MIInfo)this.getData()).getMIOutput().getMIOOBRecords();
                    MIConsoleStreamOutput consoleOutput = DsfCmdRequestor.this.retrieveFromOutput(outputRecords, command);
                    if (consoleOutput != null) {
                        svdDsfResponse = DsfCmdRequestor.this.createResponse(request, consoleOutput);
                    }
                    future.complete(svdDsfResponse);
                }
                catch (Exception e) {
                    future.completeExceptionally(e);
                }
            }

            protected void handleCancel() {
                future.cancel(false);
            }

            protected void handleErrorOrWarning() {
                future.completeExceptionally((Throwable)new CoreException(DsfCmdAnswerParser.parseError(this.getStatus())));
            }

            protected void handleFailure() {
                super.handleFailure();
            }
        };
        gdbControl.queueCommand((ICommand)cliCommand, (DataRequestMonitor)monitor);
        return future;
    }

    protected MIConsoleStreamOutput retrieveFromOutput(MIOOBRecord[] outputRecords, String command) {
        if (outputRecords == null || outputRecords.length < 1) {
            return null;
        }
        return DsfCmdAnswerParser.parseData(outputRecords, command);
    }

    @Override
    protected CompletableFuture<DsfResponse<B, R>> performWrite(final DsfRequest<B, V> request) throws DsfSessionInactiveException {
        final CompletableFuture<DsfResponse<B, R>> future = new CompletableFuture<DsfResponse<B, R>>();
        IGDBControl gdbControl = (IGDBControl)DsfSessionDsfServiceTrackerManager.getInstance().computeIfAbsent(request.session).getService(IGDBControl.class);
        CLICommand command = new CLICommand(request.idmContext, this.getWriteCommand(request));
        gdbControl.queueCommand((ICommand)command, (DataRequestMonitor)new ImmediateDataRequestMonitor<MIInfo>(){

            protected void handleSuccess() {
                future.complete(new DsfResponse(request));
            }

            protected void handleCancel() {
                future.cancel(false);
            }

            protected void handleErrorOrWarning() {
                future.completeExceptionally((Throwable)new CoreException(DsfCmdAnswerParser.parseError(this.getStatus())));
            }
        });
        return future;
    }

    protected abstract String getReadCommand(DsfRequest<B, ?> var1);

    protected abstract String getWriteCommand(DsfRequest<B, V> var1);

    protected abstract DsfResponse<B, R> createResponse(DsfRequest<B, ?> var1, MIConsoleStreamOutput var2);

    protected String getCriticalErrorMessage(DsfRequest<B, ?> request, IStatus status) {
        return NLS.bind((String)Messages.DsfCmdRequestor_0_1_failed_with_critical_error, (Object)this.getAction(request), (Object)this.getRequestDescription(request));
    }

    protected String getErrorMessage(DsfRequest<B, ?> request, IStatus status) {
        return NLS.bind((String)Messages.DsfCmdRequestor_0_1_failed, (Object)this.getAction(request), (Object)this.getRequestDescription(request));
    }

    private String getAction(DsfRequest<B, ?> request) {
        return request.type == DsfRequestType.READ ? Messages.DsfCmdRequestor_reading_of : Messages.DsfCmdRequestor_writing_to;
    }

    protected abstract String getRequestDescription(DsfRequest<B, ?> var1);

    @Override
    protected final void handleError(DsfRequest<B, ?> request, IStatus status) {
        if (status.getCode() != DsfCmdErrorCode.BUS_ERROR.getCode()) {
            DsfCmdRequestor.handleError(status, this.getErrorMessage(request, status));
            return;
        }
        String errorMessage = this.getCriticalErrorMessage(request, status);
        if (errorMessage == null) {
            throw new IllegalStateException("Error message required for bus error!");
        }
        DsfCmdRequestor.handleError(status, errorMessage);
        this.terminateSession(request);
    }

    private static void handleError(IStatus status, String errorMessage) {
        if (errorMessage != null) {
            try {
                RcpStatusHandlers.handleStatus((String)ERROR_HANDLER, (IStatus)status, (Object)errorMessage);
            }
            catch (CoreException e) {
                CdtDsfActivator.getInstance().log(e.getStatus());
            }
        }
    }

    protected void terminateSession(DsfRequest<B, ?> request) {
    }
}

