/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.cdt.internal.dsf;

import com.nxp.s32ds.ext.cdt.internal.dsf.CdtDsfActivator;
import com.nxp.s32ds.ext.cdt.internal.dsf.DsfCmdError;
import com.nxp.s32ds.ext.cdt.internal.dsf.Messages;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConsoleStreamOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOOBRecord;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;

public class DsfCmdAnswerParser {
    private static final String NEW_LINE = "\n";
    private static final Pattern S32DEBUGGER_PATTERN = Pattern.compile("(^\\[S32Debugger\\])(.*)");
    private static final Pattern S32DEBUGGER_ERROR_PATTERN = Pattern.compile("(^\\[S32Debugger\\]Error: )(\\-?[0-9]+)", 8);

    public static IStatus parseError(IStatus status) {
        DsfCmdError error = DsfCmdError.UNKNOWN;
        String statusMessage = status.getMessage();
        if (S32DEBUGGER_ERROR_PATTERN.matcher(statusMessage).find()) {
            error = DsfCmdAnswerParser.parseS32DebuggerError(statusMessage);
        }
        String message = error.getDetails() == null ? NLS.bind((String)Messages.DsfAnswerProceedingDelegate_type_0_code_1_see_2, (Object[])new Object[]{error.getType(), error.getCodeString(), Messages.DsfAnswerProceedingDelegate_see_gdb_traces}) : NLS.bind((String)Messages.DsfAnswerProceedingDelegate_type_0_code_1_details_2_see_3, (Object[])new Object[]{error.getType(), error.getCodeString(), error.getDetails(), Messages.DsfAnswerProceedingDelegate_see_gdb_traces});
        return CdtDsfActivator.getInstance().createMultiStatus(error.getCode(), message, status);
    }

    public static MIConsoleStreamOutput parseData(MIOOBRecord[] outputRecords, String command) {
        MIConsoleStreamOutput consoleStreamOutput = null;
        int i = 0;
        block0: while (i < outputRecords.length) {
            if (outputRecords[i].toString().contains(command)) {
                int resultIndex = i + 1;
                while (resultIndex < outputRecords.length) {
                    String toParse;
                    Matcher s32Matcher;
                    if (outputRecords[resultIndex] instanceof MIConsoleStreamOutput && (s32Matcher = S32DEBUGGER_PATTERN.matcher(toParse = ((MIConsoleStreamOutput)outputRecords[resultIndex]).getCString())).find() && s32Matcher.groupCount() > 1) {
                        String data = s32Matcher.group(2);
                        consoleStreamOutput = new MIConsoleStreamOutput();
                        consoleStreamOutput.setCString(data);
                        break block0;
                    }
                    ++resultIndex;
                }
                break;
            }
            ++i;
        }
        return consoleStreamOutput;
    }

    public static DsfCmdError parseS32DebuggerError(String message) {
        boolean errorFound = false;
        Integer errorCode = null;
        ArrayList<String> details = new ArrayList<String>();
        String[] stringArray = message.split(NEW_LINE);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line != null && !line.trim().isEmpty()) {
                if (!errorFound) {
                    Matcher errorMatcher = S32DEBUGGER_ERROR_PATTERN.matcher(line);
                    if (errorMatcher.find()) {
                        errorFound = true;
                        String group = errorMatcher.group(2);
                        try {
                            errorCode = Integer.parseInt(group);
                        }
                        catch (NumberFormatException e) {
                            CdtDsfActivator.getInstance().logError("Cannot parse error code '" + group + "'", e);
                        }
                    }
                } else {
                    details.add(line.trim());
                }
            }
            ++n2;
        }
        String detailsMessage = details.size() == 0 ? null : String.join((CharSequence)NEW_LINE, details);
        return new DsfCmdError(errorCode, detailsMessage);
    }
}

