/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.config;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.lang.CollectionMap;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.periphs.model.emit.CodeEmitter;
import com.nxp.swtools.provider.configuration.dependencies.IDependency;
import com.nxp.swtools.provider.configuration.storage.periphs.AStoragePeriphsSetting;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsConfigSet;
import com.nxp.swtools.resourcetables.model.config.CacheHelper;
import com.nxp.swtools.resourcetables.model.config.ChildContext;
import com.nxp.swtools.resourcetables.model.config.ChildProviderHelper;
import com.nxp.swtools.resourcetables.model.config.ChildStorageHelper;
import com.nxp.swtools.resourcetables.model.config.ChildValidationHelper;
import com.nxp.swtools.resourcetables.model.config.DependencyResponseConfig;
import com.nxp.swtools.resourcetables.model.config.DumpFormatOptions;
import com.nxp.swtools.resourcetables.model.config.DumpHelper;
import com.nxp.swtools.resourcetables.model.config.ExpressionContext;
import com.nxp.swtools.resourcetables.model.config.ICacheable;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IChildProvidable;
import com.nxp.swtools.resourcetables.model.config.IConfigSetConfig;
import com.nxp.swtools.resourcetables.model.config.IPresettable;
import com.nxp.swtools.resourcetables.model.config.ISettingConfig;
import com.nxp.swtools.resourcetables.model.config.QuickSelectionHelper;
import com.nxp.swtools.resourcetables.model.config.SettingConfigHelper;
import com.nxp.swtools.resourcetables.model.config.StructConfig;
import com.nxp.swtools.resourcetables.model.data.IConfigSet;
import com.nxp.swtools.resourcetables.model.data.IQuickSelection;
import com.nxp.swtools.resourcetables.model.data.IQuickSelectionGroup;
import com.nxp.swtools.resourcetables.model.data.Level;
import com.nxp.swtools.resourcetables.model.data.SettingUtils;
import com.nxp.swtools.resourcetables.model.data.Validation;
import com.nxp.swtools.resourcetables.model.data.setting.ISetting;
import com.nxp.swtools.resourcetables.model.emit.ICodeEmitter;
import com.nxp.swtools.resourcetables.model.mcu.ICommonMcu;
import com.nxp.swtools.utils.profiler.Profiler;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class ConfigSetConfig
implements IConfigSetConfig {
    private static final Logger LOGGER = LogManager.getLogger(ConfigSetConfig.class);
    private final ICodeEmitter codeEmitter;
    private final String id;
    private final String name;
    protected final IConfigSet configSet;
    protected final Map<String, ISettingConfig> settings = new HashMap<String, ISettingConfig>();
    @Nullable
    protected IQuickSelection quickSelection = null;
    protected final StoragePeriphsConfigSet storageConfigSet;
    protected final IContext expressionContext;
    protected final ChildContext childContext;
    protected final ICommonMcu mcu;
    protected final Map<String, Object> cache = new HashMap<String, Object>();
    protected final CollectionMap<String, CollectionsUtils.Pair<String, ICacheable>> dependencies = new CollectionMap();

    protected ConfigSetConfig(String id, IConfigSet configSet, ChildContext parentContext, ICommonMcu mcu, boolean global) {
        this.name = global ? "#global" : configSet.getId();
        this.mcu = mcu;
        this.childContext = parentContext.createForChild((IChild)this);
        this.childContext.setConfigSetConfig((IConfigSetConfig)this);
        this.expressionContext = new ExpressionContext(this.childContext, mcu);
        this.id = id;
        this.configSet = configSet;
        this.storageConfigSet = new StoragePeriphsConfigSet();
        this.storageConfigSet.setName(configSet.getId());
        this.quickSelection = QuickSelectionHelper.getDefaultQuickSelection((IPresettable)this);
        this.storageConfigSet.setQuick_selection(this.quickSelection != null ? this.quickSelection.getId() : null);
        this.addAllRequiredSettings();
        this.populateRelatedSettingsList(null);
        this.codeEmitter = new CodeEmitter(this);
    }

    public ConfigSetConfig(String id, IConfigSet configSet, StoragePeriphsConfigSet storageConfigSet, ChildContext parentContext, ICommonMcu mcu, boolean global) {
        this.name = global ? "#global" : configSet.getId();
        this.mcu = mcu;
        this.childContext = parentContext.createForChild((IChild)this);
        this.childContext.setConfigSetConfig((IConfigSetConfig)this);
        this.expressionContext = new ExpressionContext(this.childContext, mcu);
        this.id = id;
        this.configSet = configSet;
        this.storageConfigSet = storageConfigSet;
        this.codeEmitter = new CodeEmitter(this);
        this.quickSelection = (IQuickSelection)CollectionsUtils.nullableOptionalGet(QuickSelectionHelper.getAvailableQuickSelections((IPresettable)this).stream().filter(x -> x.getId().equals(storageConfigSet.getQuick_selection())).findFirst());
        HashMap<String, AStoragePeriphsSetting> storagesMap = new HashMap<String, AStoragePeriphsSetting>();
        storageConfigSet.getSettings().forEach(x -> {
            AStoragePeriphsSetting aStoragePeriphsSetting = storagesMap.put(x.getName(), (AStoragePeriphsSetting)x);
        });
        configSet.getSettingsList().forEach(x -> {
            String settingName = x.getId();
            String childId = SettingUtils.buildId((String[])new String[]{id, settingName});
            AStoragePeriphsSetting storageSetting = (AStoragePeriphsSetting)storagesMap.get(settingName);
            storagesMap.remove(settingName);
            if (storageSetting != null) {
                this.settings.put(settingName, this.childContext.getRoot().getConfigFactory().createSettingConfig(childId, x, this.childContext, storageSetting, mcu));
            } else {
                ISettingConfig createSettingConfig = this.childContext.getRoot().getConfigFactory().createSettingConfig(childId, settingName, x, this.childContext, mcu);
                this.settings.put(settingName, createSettingConfig);
            }
        });
        if (!storagesMap.isEmpty()) {
            this.populateRelatedSettingsList(storagesMap);
        }
        if (!storagesMap.isEmpty()) {
            LOGGER.warning(String.format("[DATA] The following settings of the configSet %s could not be restored: %s because the component does not contain them anymore", configSet.getId(), storagesMap.keySet()));
        }
        this.updateStorageSettings();
    }

    public void delayedInitAfterCreation() {
        for (ISettingConfig setting : this.settings.values()) {
            setting.delayedInitAfterCreation();
        }
    }

    private void updateStorageSettings() {
        ArrayList storages = new ArrayList();
        this.getChildren().forEach(sc -> {
            storages.add(sc.getStorageSetting());
            storages.addAll(sc.getStorageOfRelatedSettings());
        });
        this.getStorageConfigSet().setSettings(storages);
    }

    public void applySelectedQuickSelection() {
        Profiler profiler;
        BigInteger index = profiler.start(StructConfig.class, (Object)(!(profiler = Profiler.getInstance((Object)"Peripherals")).isEnabled() ? "" : "Apply quick selection on setting " + this.getId()));
        if (this.quickSelection != null) {
            this.getChildren().forEach(x -> x.deInitialize());
            this.applyQuickSelection(this.quickSelection);
        }
        this.getChildren().forEach(x -> x.initValue());
        profiler.stop(index, StructConfig.class, null);
    }

    private void addAllRequiredSettings() {
        for (ISetting setting : this.configSet.getSettingsList()) {
            if (this.settings.containsKey(setting.getId())) continue;
            String childId = SettingUtils.buildId((String[])new String[]{this.getId(), setting.getId()});
            ISettingConfig settingConfig = this.childContext.getRoot().getConfigFactory().createSettingConfig(childId, setting.getId(), setting, this.childContext, this.mcu);
            this.settings.put(setting.getId(), settingConfig);
            if (!settingConfig.isStorable()) continue;
            this.storageConfigSet.getSettings().add(settingConfig.getStorageSetting());
        }
    }

    public void updateStorageAvailability() {
        ChildStorageHelper.updateStorageAvailability((List)this.getStorageConfigSet().getSettings(), this.getChildren());
        this.getChildren().forEach(child -> this.getStorageConfigSet().addSettings((Collection)child.getStorageOfRelatedSettings()));
    }

    public Map<String, Object> getCache() {
        return this.cache;
    }

    public CollectionMap<String, CollectionsUtils.Pair<String, ICacheable>> getDependencyMap() {
        return this.dependencies;
    }

    public ChildContext getChildContext() {
        return this.childContext;
    }

    public IDependency @Nullable [] getOwnDependencies(String source) {
        return ChildValidationHelper.getDependencies((Validation)this.configSet.getValidation(), (IContext)this.getExpressionContext(), (String)source, (String)this.makeOriginatorId(this.childContext));
    }

    public void applyQuickSelection(@Nullable IQuickSelection quickSel) {
        this.getChildren().forEach(x -> x.applyQuickSelection(quickSel, (IChild)this));
    }

    public StoragePeriphsConfigSet getStorageConfigSet() {
        return this.storageConfigSet;
    }

    public IContext getExpressionContext() {
        return this.expressionContext;
    }

    public @Nullable IQuickSelection getQuickSelection() {
        return this.quickSelection;
    }

    public void setQuickSelection(@Nullable IQuickSelection quickSelection) {
        this.quickSelection = quickSelection;
        this.storageConfigSet.setQuick_selection(quickSelection != null ? quickSelection.getId() : null);
    }

    public ConfigSetConfig getValue() {
        return (ConfigSetConfig)CacheHelper.getValueCaching((ICacheable)this, (String)(String.valueOf(this.getId()) + "*value"), () -> this);
    }

    public @Nullable IChild getChild(String childName) {
        return (IChild)this.settings.get(childName);
    }

    public @Nullable IChild getChildById(String childId) {
        return ChildProviderHelper.getChildRelative((IChildProvidable)this, (String)childId);
    }

    public ICodeEmitter getCodeEmitter() {
        return this.codeEmitter;
    }

    public IConfigSet getConfigSet() {
        return this.configSet;
    }

    public @Nullable String getValueName() {
        return this.quickSelection != null ? this.quickSelection.getUIName(this.expressionContext) : null;
    }

    public List<ISettingConfig> getChildren() {
        return SettingConfigHelper.getConfigsOf((Map)this.configSet.getSettings(), this.settings);
    }

    public boolean isAvailable() {
        IChildProvidable parent = this.childContext.getParent();
        return this.configSet.isAvailable(this.expressionContext) && (parent == null || parent.isAvailable());
    }

    public boolean isEnabled() {
        IChildProvidable parent = this.childContext.getParent();
        return this.configSet.isEnabled(this.expressionContext) && (parent == null || parent.isEnabled());
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getUiName() {
        return this.configSet.getUIName(this.expressionContext);
    }

    public @Nullable String getDescription() {
        return this.configSet.getResolvedDescription(this.expressionContext);
    }

    public String @Nullable [] getOwnProblems(Level level) {
        return (String[])CacheHelper.getValueCaching((ICacheable)this, (String)(String.valueOf(this.getId()) + "*own_problems*" + level), () -> this.isEnabled() ? ChildValidationHelper.getValidationProblems((Validation)this.configSet.getValidation(), (IContext)this.expressionContext, (Level)level) : null);
    }

    public boolean isOptionSet(String option) {
        return this.configSet.isOptionSet(option) && this.isOptionAvailable(option);
    }

    public boolean isOptionAvailable(String option) {
        return this.configSet.isOptionAvailable(option, this.expressionContext);
    }

    public @Nullable Object getOptionValue(String option) {
        return this.configSet.getOptionValue(option, this.getExpressionContext());
    }

    public @Nullable String getError() {
        return (String)CacheHelper.getValueCaching((ICacheable)this, (String)"*error", () -> this.getProblems(Level.ERROR));
    }

    public @Nullable String getWarning() {
        return (String)CacheHelper.getValueCaching((ICacheable)this, (String)"*warning", () -> this.getProblems(Level.WARNING));
    }

    public @Nullable String getInfo() {
        return (String)CacheHelper.getValueCaching((ICacheable)this, (String)"*info", () -> this.getProblems(Level.INFO));
    }

    public @Nullable String getProblems(Level level) {
        return (String)CacheHelper.getValueCaching((ICacheable)this, (String)("*problems*" + level), () -> super.getProblems(level));
    }

    public @Nullable String getNestedProblems(Level level) {
        return (String)CacheHelper.getValueCaching((ICacheable)this, (String)("*nested_problems*" + level), () -> super.getNestedProblems(level));
    }

    public List<String> getProblemsPaths(Level level) {
        List cachedValue = (List)CacheHelper.getValueCaching((ICacheable)this, (String)("*problems_paths*" + level), () -> super.getProblemsPaths(level));
        return cachedValue == null ? CollectionsUtils.emptyList() : cachedValue;
    }

    public String toString() {
        return "ConfigSet: [Id: " + this.getId() + "]";
    }

    public @NonNull IConfigSet getModelData() {
        return this.configSet;
    }

    public @NonNull IQuickSelectionGroup getQuickSelectionGroup() {
        return this.getModelData();
    }

    public @Nullable String getTypeName() {
        return "config_set";
    }

    public List<ISettingConfig> getAllStorableSettings() {
        List allChildren = ChildProviderHelper.getAllSettings((IChildProvidable)this);
        return (List)allChildren.stream().filter(IChild::isStorable).collect(CollectorsUtils.toList());
    }

    public List<ISettingConfig> getAllVisibleSettings() {
        List allChildren = ChildProviderHelper.getAllSettings((IChildProvidable)this);
        return (List)allChildren.stream().filter(ISettingConfig::isVisible).collect(CollectorsUtils.toList());
    }

    public List<DependencyResponseConfig> getDependencyResponses() {
        Validation validation = this.configSet.getValidation();
        ArrayList<DependencyResponseConfig> result = new ArrayList<DependencyResponseConfig>((Collection)validation.getDependencyResponses().stream().map(r -> new DependencyResponseConfig((IChild)this, r)).collect(CollectorsUtils.toList()));
        for (ISettingConfig settingConfig : this.getChildren()) {
            result.addAll(settingConfig.getDependencyResponses());
        }
        validation.getDependencyResponses().forEach(r -> {
            DependencyResponseConfig dependencyResponseConfig = new DependencyResponseConfig((IChild)this, r);
        });
        return result;
    }

    public void synchronizeValue(@Nullable IChild config) {
        this.getChildren().forEach(setting -> setting.synchronizeValue(null));
    }

    public boolean isSynchronizationEnabled() {
        IChildProvidable parent = this.childContext.getParent();
        return this.configSet.isOptionAvailable("SYNC_VALUE", this.expressionContext) || parent != null && parent.isOptionAvailable("SYNC_VALUE");
    }

    public void dispose() {
        for (ISettingConfig setting : this.settings.values()) {
            setting.dispose();
        }
        this.settings.clear();
        this.cache.clear();
        this.dependencies.clear();
        this.childContext.dispose();
    }

    public void populateRelatedSettingsList(@Nullable Map<String, AStoragePeriphsSetting> storageConfigs) {
        this.getChildren().forEach(setting -> setting.populateRelatedSettingsList(storageConfigs));
    }

    public StringBuilder dump(StringBuilder builder, DumpFormatOptions options) {
        return DumpHelper.dump((StringBuilder)builder, (DumpFormatOptions)options, (IChildProvidable)this);
    }
}

