/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.config;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.periphs.model.Messages;
import com.nxp.swtools.periphs.model.config.ComponentInstanceConfig;
import com.nxp.swtools.periphs.model.config.DummyComponentInstanceConfig;
import com.nxp.swtools.provider.configuration.ICommonConfig;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsComponentInstance;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsFuncGroup;
import com.nxp.swtools.resourcetables.model.config.ChildContext;
import com.nxp.swtools.resourcetables.model.config.ChildProviderHelper;
import com.nxp.swtools.resourcetables.model.config.DumpFormatOptions;
import com.nxp.swtools.resourcetables.model.config.DumpHelper;
import com.nxp.swtools.resourcetables.model.config.ExpressionContext;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IChildProvidable;
import com.nxp.swtools.resourcetables.model.config.IComponentConfig;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.resourcetables.model.config.IFunctionalGroup;
import com.nxp.swtools.resourcetables.model.config.IRoot;
import com.nxp.swtools.resourcetables.model.data.Category;
import com.nxp.swtools.resourcetables.model.data.Level;
import com.nxp.swtools.resourcetables.model.mcu.ICommonMcu;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;

public class FunctionalGroup
implements IFunctionalGroup {
    public static final String NAME_PREFIX_FOR_ADDING = "PeriphsFunc_";
    public static final String NAME_DEFAULT = "BOARD_InitPeripherals";
    public static final String NAME_RESERVED = "BOARD_InitBootPeripherals";
    private static final Logger LOGGER = LogManager.getLogger(FunctionalGroup.class);
    private String name = "BOARD_InitPeripherals";
    private String description = "";
    private final Map<String, Integer> orderMap = new HashMap<String, Integer>();
    private final Comparator<String> comparator = new Comparator<String>(){

        @Override
        public int compare(String key1, String key2) {
            Integer index1 = FunctionalGroup.this.orderMap.get(key1);
            Integer index2 = FunctionalGroup.this.orderMap.get(key2);
            if (index1 == null) {
                return 1;
            }
            if (index2 == null) {
                return -1;
            }
            return index1.compareTo(index2);
        }
    };
    private final TreeMap<String, IComponentInstanceConfig> instances = new TreeMap(this.comparator);
    private final StoragePeriphsFuncGroup storageFuncGroup;
    protected final ChildContext childContext;
    protected final ExpressionContext expressionContext;
    protected final ICommonMcu mcu;
    private boolean calledFromDefaultInit;
    private String idPrefix = "";
    private String selectedCoreId = "";

    public FunctionalGroup(ChildContext parentContext, ICommonMcu mcu) {
        this.mcu = mcu;
        this.childContext = parentContext.createForChild((IChild)this);
        this.childContext.setGroup((IFunctionalGroup)this);
        this.expressionContext = new ExpressionContext(this.childContext, this.mcu);
        this.storageFuncGroup = new StoragePeriphsFuncGroup();
        this.updateStorage();
    }

    public FunctionalGroup(ChildContext parentContext, StoragePeriphsFuncGroup storageFuncGroup, ICommonMcu mcu) {
        this.mcu = mcu;
        this.childContext = parentContext.createForChild((IChild)this);
        this.childContext.setGroup((IFunctionalGroup)this);
        this.expressionContext = new ExpressionContext(this.childContext, this.mcu);
        this.storageFuncGroup = storageFuncGroup;
        this.name = storageFuncGroup.getName();
        this.calledFromDefaultInit = storageFuncGroup.isCalledFromInit();
        this.description = storageFuncGroup.getDescription();
        this.idPrefix = storageFuncGroup.getId_prefix();
        String funcGrSelCore = storageFuncGroup.getSelectedCore();
        ProcessorCore coreFromStorage = this.mcu.getCore(funcGrSelCore);
        if (coreFromStorage != null) {
            this.selectedCoreId = coreFromStorage.getID();
        } else {
            String selectedCore = parentContext.getRoot().getActiveCoreId();
            if (funcGrSelCore.isEmpty() && !selectedCore.isEmpty()) {
                this.setCore(selectedCore);
            } else {
                this.setMasterCoreAsUsed();
            }
        }
        ArrayList componentInstances = new ArrayList(storageFuncGroup.getInstances());
        componentInstances.forEach(x -> {
            IComponentConfig componentConfig = this.childContext.getRoot().getComponent(x.getType());
            if (componentConfig != null) {
                new ComponentInstanceConfig(componentConfig.getComponent(), this, (StoragePeriphsComponentInstance)x, componentConfig.getChildContext(), mcu);
            } else {
                LOGGER.severe("[DATA] Component with id not found: " + x.getType());
            }
        });
        this.updateStorage();
    }

    public FunctionalGroup(IFunctionalGroup original, IRoot root) {
        this.mcu = original.getMcu();
        this.childContext = root.getChildContext().createForChild((IChild)this);
        this.childContext.setRoot(root);
        this.childContext.setGroup((IFunctionalGroup)this);
        this.expressionContext = new ExpressionContext(this.childContext, this.mcu);
        this.storageFuncGroup = new StoragePeriphsFuncGroup(original.getStorageFuncGroup());
        this.name = this.storageFuncGroup.getName();
        this.calledFromDefaultInit = this.storageFuncGroup.isCalledFromInit();
        this.description = this.storageFuncGroup.getDescription();
        this.idPrefix = this.storageFuncGroup.getId_prefix();
        this.setCore(original.getCore());
        for (Map.Entry entry : original.getInstances().entrySet()) {
            IComponentInstanceConfig value = (IComponentInstanceConfig)entry.getValue();
            if (value instanceof ComponentInstanceConfig) {
                ComponentInstanceConfig duplicatedInstance = new ComponentInstanceConfig((ComponentInstanceConfig)value, this, false);
                this.getInstancesMapInternal().put((String)entry.getKey(), duplicatedInstance);
                continue;
            }
            if (value instanceof DummyComponentInstanceConfig) {
                this.getInstancesMapInternal().put((String)entry.getKey(), value);
                continue;
            }
            LOGGER.log(java.util.logging.Level.SEVERE, "[TOOL] [FUNC_GROUP_DUPLICATION] Unknown implementation of interface IComponentInstanceConfig: {0}", value.getClass().getName());
        }
        this.updateStorage();
    }

    private Map<String, IComponentInstanceConfig> getInstancesMapInternal() {
        return this.instances;
    }

    public void initializeAfterCreatedFromStorage() {
        for (IComponentInstanceConfig instance : this.getInstancesInternal()) {
            instance.initializeAfterCreatedFromStorage();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.storageFuncGroup.setName(name);
    }

    public @NonNull String getIdForTooltip() {
        return this.getName();
    }

    public Map<String, IComponentInstanceConfig> getInstances() {
        return CollectionsUtils.unmodifiableMap(this.getInstancesMapInternal());
    }

    public Collection<IComponentInstanceConfig> getInstancesOfType(String type) {
        return (Collection)this.getInstancesInternal().stream().filter(x -> type.equals(x.getComponent().getId())).collect(CollectorsUtils.toList());
    }

    public Collection<IComponentInstanceConfig> getInstancesOfCategory(String category) {
        return (Collection)this.getInstancesInternal().stream().filter(x -> category.equals(x.getComponent().getCategory())).collect(CollectorsUtils.toList());
    }

    public Collection<IComponentInstanceConfig> getInstancesWithoutMatchingCategory(Collection<Category> categories) {
        return (Collection)this.getInstancesInternal().stream().filter(cic -> categories.stream().noneMatch(cat -> cat.getId().equals(cic.getComponent().getCategory()))).collect(CollectorsUtils.toList());
    }

    private Collection<IComponentInstanceConfig> getInstancesInternal() {
        return this.getInstancesMapInternal().values();
    }

    public void addInstance(IComponentInstanceConfig componentConfig) {
        String key = componentConfig.getName();
        Integer index = this.orderMap.get(key);
        if (index == null) {
            index = this.orderMap.size();
        }
        this.putIndexToOrderMapInternal(key, index);
        this.putInstanceInternal(key, componentConfig);
        this.updateStorage();
    }

    private @Nullable IComponentInstanceConfig putInstanceInternal(String key, IComponentInstanceConfig instance) {
        return this.getInstancesMapInternal().put(key, instance);
    }

    public @Nullable IComponentInstanceConfig getComponentInstance(String type, String instanceName) {
        IComponentInstanceConfig instance = this.getInstancesMapInternal().get(instanceName);
        if (instance != null && !type.equals(instance.getType())) {
            LOGGER.severe("[DATA] Component instance with name " + instanceName + " does not match the required component type: " + type);
            return null;
        }
        return instance;
    }

    public void setConfiguredComponents(Map<String, IComponentInstanceConfig> configuredComponents) {
        this.getInstancesMapInternal().clear();
        this.orderMap.clear();
        for (Map.Entry<String, IComponentInstanceConfig> entry : configuredComponents.entrySet()) {
            this.addInstance(entry.getValue());
        }
        this.updateStorage();
    }

    public @Nullable IComponentInstanceConfig getInstance(String instanceName) {
        return this.getInstancesMapInternal().get(instanceName);
    }

    public @Nullable IComponentInstanceConfig getInstanceByUUID(String uuid) {
        return (IComponentInstanceConfig)CollectionsUtils.nullableOptionalGet(this.getInstancesMapInternal().entrySet().stream().map(x -> (IComponentInstanceConfig)x.getValue()).filter(x -> x.getUUID().equals(uuid)).findAny());
    }

    public List<IComponentInstanceConfig> getInstancesByPeripheral(String peripheral) {
        return (List)this.getInstancesMapInternal().entrySet().stream().map(x -> (IComponentInstanceConfig)x.getValue()).filter(x -> peripheral.equals(x.getPeripheral())).collect(CollectorsUtils.toList());
    }

    public void renameInstance(String oldName, String newName) {
        IComponentInstanceConfig instance = this.getInstancesMapInternal().get(oldName);
        if (instance != null) {
            instance.setName(newName);
            Integer previousPosition = this.orderMap.get(oldName);
            if (previousPosition == null) {
                previousPosition = this.orderMap.size();
            }
            this.removeInstanceInternal(oldName);
            this.orderMap.remove(oldName);
            this.putIndexToOrderMapInternal(newName, previousPosition);
            if (this.putInstanceInternal(newName, instance) != null) {
                String message = MessageFormat.format("[TOOL] Component with ID {0}, of type {1} and name {2} was renamed to {3}, which caused a name conflict", instance.getId(), instance.getComponent().getId(), oldName, newName);
                LOGGER.warning(message);
                this.updateStorage();
            }
        }
    }

    public void setInstancesOrder(Map<String, Integer> map) {
        HashMap<String, IComponentInstanceConfig> instancesLoc = new HashMap<String, IComponentInstanceConfig>(this.getInstancesMapInternal());
        this.getInstancesMapInternal().clear();
        this.orderMap.clear();
        this.orderMap.putAll(map);
        this.getInstancesMapInternal().putAll(instancesLoc);
        this.updateStorage();
        this.updateStorageAvailability();
    }

    public boolean moveInstance(String toBeMoved, String afterWhichInstance) {
        Integer position = this.orderMap.get(afterWhichInstance);
        if (position == null) {
            return false;
        }
        Integer wantedPosition = position + 1;
        Integer originalPosition = this.orderMap.get(toBeMoved);
        if (originalPosition == null) {
            return false;
        }
        IComponentInstanceConfig instanceToBeMoved = this.getInstance(toBeMoved);
        if (instanceToBeMoved == null) {
            return false;
        }
        this.removeInstance(toBeMoved);
        ArrayList<String> keysToBeUpdated = new ArrayList<String>();
        for (Map.Entry<String, Integer> entry : this.orderMap.entrySet()) {
            String key = entry.getKey();
            Integer index = entry.getValue();
            if (index.compareTo(position) <= 0) continue;
            keysToBeUpdated.add(key);
        }
        for (String key : keysToBeUpdated) {
            Integer indexToUpdate = this.orderMap.get(key);
            if (indexToUpdate == null) {
                LOGGER.severe(() -> MessageFormat.format("Key \"{0}\" does not exist in order map", key));
                continue;
            }
            Integer newIndex = indexToUpdate + 1;
            this.putIndexToOrderMapInternal(key, newIndex);
        }
        this.putIndexToOrderMapInternal(toBeMoved, wantedPosition);
        this.putInstanceInternal(toBeMoved, instanceToBeMoved);
        return true;
    }

    public boolean removeInstance(String instanceName) {
        boolean result = this.removeInstanceInternal(instanceName) != null;
        Integer indexToBeRemoved = this.orderMap.get(instanceName);
        if (indexToBeRemoved == null) {
            LOGGER.severe(() -> MessageFormat.format("Index {0} does not exist in ordering map of functional group {1}", indexToBeRemoved, this.getName()));
            return false;
        }
        ArrayList<String> keysToBeUpdated = new ArrayList<String>();
        for (Map.Entry<String, Integer> entry : this.orderMap.entrySet()) {
            String key = entry.getKey();
            Integer index = entry.getValue();
            if (index.compareTo(indexToBeRemoved) <= 0) continue;
            keysToBeUpdated.add(key);
        }
        this.orderMap.remove(instanceName);
        for (String key : keysToBeUpdated) {
            Integer indexToUpdate = this.orderMap.get(key);
            if (indexToUpdate == null) {
                LOGGER.severe(() -> MessageFormat.format("Key \"{0}\" does not exist in order map", key));
                continue;
            }
            Integer newIndex = indexToUpdate - 1;
            this.putIndexToOrderMapInternal(key, newIndex);
        }
        this.updateStorage();
        return result;
    }

    private @Nullable IComponentInstanceConfig removeInstanceInternal(String instanceName) {
        return this.getInstancesMapInternal().remove(instanceName);
    }

    private @Nullable Integer putIndexToOrderMapInternal(String key, Integer index) {
        return this.orderMap.put(key, index);
    }

    public boolean removeAllInstances(String type) {
        boolean result = this.getInstancesInternal().removeIf(x -> x.getComponent().getId().equals(type));
        if (result) {
            this.updateStorage();
        }
        return result;
    }

    private void updateStorage() {
        this.storageFuncGroup.setName(this.name);
        this.storageFuncGroup.setCalledFromInit(this.calledFromDefaultInit);
        this.storageFuncGroup.setDescription(this.description);
        this.storageFuncGroup.setId_prefix(this.idPrefix);
        this.storageFuncGroup.setSelectedCore(this.selectedCoreId);
        this.storageFuncGroup.getInstances().clear();
        this.getInstancesMapInternal().values().forEach(x -> {
            boolean bl = this.storageFuncGroup.getInstances().add(x.getStorageComponent());
        });
    }

    public StoragePeriphsFuncGroup getStorageFuncGroup() {
        return this.storageFuncGroup;
    }

    public String getId() {
        return this.name;
    }

    public Object getValue() {
        return this;
    }

    public boolean isAvailable() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    public @Nullable IChild getChildById(String id) {
        return ChildProviderHelper.getChildRelative((IChildProvidable)this, (String)id);
    }

    public @Nullable IChild getChild(String childName) {
        return this.getInstance(childName);
    }

    public List<? extends IChild> getChildren() {
        ArrayList<IComponentInstanceConfig> children = new ArrayList<IComponentInstanceConfig>(this.getInstancesInternal());
        return children;
    }

    public @NonNull String getUiName() {
        return this.name;
    }

    public @NonNull String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.storageFuncGroup.setDescription(description);
    }

    public ChildContext getChildContext() {
        return this.childContext;
    }

    public IContext getExpressionContext() {
        return this.expressionContext;
    }

    public ICommonMcu getMcu() {
        return this.mcu;
    }

    public String getCore() {
        return this.selectedCoreId;
    }

    public void setCore(String newCore) {
        this.selectedCoreId = newCore;
        this.storageFuncGroup.setSelectedCore(newCore);
    }

    public boolean isRemovable() {
        return this.childContext.getRoot().getFunctionalGroups().size() > 1;
    }

    public boolean isCalledFromDefaultInit() {
        return this.calledFromDefaultInit;
    }

    public void setCalledFromDefaultInit(boolean calledFromDefaultInit) {
        this.calledFromDefaultInit = calledFromDefaultInit;
        this.storageFuncGroup.setCalledFromInit(calledFromDefaultInit);
    }

    public boolean canBeCalledFromDefaultInit() {
        return true;
    }

    public String @Nullable [] getOwnProblems(Level level) {
        if (level.equals((Object)Level.WARNING)) {
            String activeCoreId = this.getChildContext().getRoot().getActiveCoreId();
            String funcGroupCoreId = this.getCore();
            if (!UtilsText.isEmpty((String)activeCoreId) && !activeCoreId.equals(funcGroupCoreId)) {
                return new String[]{MessageFormat.format(UtilsText.safeString((String)Messages.get().FunctionalGroup_DifferentSelectedCore), UtilsText.safeString((String)this.mcu.getCoreUiName(funcGroupCoreId)), UtilsText.safeString((String)this.mcu.getCoreUiName(activeCoreId)))};
            }
        }
        return null;
    }

    public String getIdPrefix() {
        return this.idPrefix;
    }

    public void setIdPrefix(String idPrefix) {
        this.idPrefix = idPrefix;
        this.storageFuncGroup.setId_prefix(idPrefix);
    }

    public boolean isPeripheralUsed(String peripheralName) {
        for (IComponentInstanceConfig component : this.getInstancesInternal()) {
            if (!component.isPeripheralUsed(peripheralName)) continue;
            return true;
        }
        return false;
    }

    public void setMasterCoreAsUsed() {
        this.setCore(FunctionalGroup.getMasterCore(this.getMcu()));
    }

    public boolean setCoreFrom(ICommonConfig commonConfig) {
        ProcessorCore coreFromMcu;
        ProcessorCore coreFromCommonConfig = commonConfig.getSelectedCore();
        if (coreFromCommonConfig != null && (coreFromMcu = this.mcu.getCore(coreFromCommonConfig.getID())) != null) {
            this.setCore(coreFromMcu.getID());
            return true;
        }
        return false;
    }

    public static final String getMasterCore(ICommonMcu mcuWithCores) {
        return mcuWithCores.getMasterCore();
    }

    public List<String> getListOfFinalInstanceNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (IComponentInstanceConfig instance : this.getInstances().values()) {
            result.add(this.createIdentifier(instance.getId()));
        }
        return result;
    }

    public String createIdentifier(String id) {
        return String.valueOf(this.getIdPrefix().toUpperCase()) + "_" + this.getCore() + "_" + id.toUpperCase();
    }

    public void updateStorageAvailability() {
        this.getInstancesInternal().forEach(c -> c.updateStorageAvailability());
    }

    public @NonNull String getSettingsSummary() {
        ProcessorCore coreFromStorage;
        ArrayList<String> summary = new ArrayList<String>();
        if (this.mcu.getCores().size() > 1 && (coreFromStorage = this.mcu.getCore(this.storageFuncGroup.getSelectedCore())) != null) {
            summary.add(UtilsText.format((String)Messages.get().FunctionalGroup_selectedCore, (Object[])new Object[]{coreFromStorage.getName()}));
        }
        Integer componentsConfiguredCount = this.getInstancesMapInternal().size();
        summary.add(UtilsText.format((String)Messages.get().FunctionalGroup_componentsConfiguredCount, (Object[])new Object[]{componentsConfiguredCount}));
        return UtilsText.join(summary, (String)"<br/>");
    }

    public void dispose() {
        for (IComponentInstanceConfig instance : this.getInstancesInternal()) {
            instance.dispose();
        }
        this.getInstancesMapInternal().clear();
        this.childContext.dispose();
    }

    public StringBuilder dump(StringBuilder builder, DumpFormatOptions options) {
        return DumpHelper.dump((StringBuilder)builder, (DumpFormatOptions)options, (IChildProvidable)this);
    }

    public List<String> getAvailablePeripherals(String type) {
        return (List)this.mcu.getPeripherals(type).stream().filter(p -> this.mcu.isPeripheralAvailableForCore(this.getCore(), p)).collect(CollectorsUtils.toList());
    }
}

