/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.files.UtilsDecryption;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.xml.UtilsXML;
import com.nxp.swtools.configuration.PEConfiguration;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.periphs.model.data.XMLConstants;
import com.nxp.swtools.resourcetables.model.XSDUtils;
import com.nxp.swtools.resourcetables.model.data.Category;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Platform;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.convert.AnnotationStrategy;
import org.simpleframework.xml.core.Persister;
import org.simpleframework.xml.strategy.Strategy;
import org.simpleframework.xml.stream.Format;
import org.xml.sax.SAXException;

@Root(name="categories", strict=false)
@Namespace(prefix="categories", reference="http://swtools.freescale.net/XSD/categories/1.0")
public class Categories {
    private static final Logger LOGGER = LogManager.getLogger(Categories.class);
    private static final String LOCAL_SCHEMA = XMLConstants.CATEGORIES_SCHEMA_FILENAME;
    public static final String CATEGORIES_FILE_NAME_REGEX = "categories.*\\.xml";
    @ElementList(inline=true, required=true)
    private List<Category> categories;
    @Attribute(name="schemaLocation", required=false)
    @Namespace(prefix="xsi", reference="http://www.w3.org/2001/XMLSchema-instance")
    private String schemaLocation;

    @Deprecated
    protected Categories() {
        this(new ArrayList<Category>());
    }

    public Categories(List<Category> categories) {
        this.categories = categories;
        this.schemaLocation = XMLConstants.CATEGORIES_SCHEMA_LOC;
    }

    public boolean addCategory(Category category) {
        return this.categories.add(category);
    }

    public List<Category> getCategories() {
        return CollectionsUtils.unmodifiableList(this.categories);
    }

    public @Nullable String getCategoryLabel(String id, IContext context) {
        return (String)CollectionsUtils.nullableOptionalGet(this.getCategories().stream().filter(cat -> id.equals(cat.getId())).map(cat -> cat.getUIName(context)).findAny());
    }

    public String getSchemaLocation() {
        String[] locPair = this.schemaLocation.split(" ");
        if (2 != locPair.length) {
            if (SWToolsProperties.isVerificationOn()) {
                LOGGER.severe(MessageFormat.format("[DATA] Component categories file specifies an invalid schema location {0}", this.schemaLocation));
            }
            return "";
        }
        String loc = locPair[1];
        return loc;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [categories(fst " + 3 + ")=" + CollectionsUtils.firstN(this.getCategories(), (int)3) + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.categories.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Categories other = (Categories)obj;
        return this.categories.equals(other.categories);
    }

    public boolean saveToFile(String fileName) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileOutputStream out = new FileOutputStream(fileName);){
                this.saveToStream(out);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "[TOOL] Error saving component file " + fileName, e);
            return false;
        }
        return true;
    }

    public void saveToStream(OutputStream out) throws Exception {
        Format format = new Format(4, "<?xml version=\"1.0\" encoding= \"UTF-8\" ?>");
        AnnotationStrategy strategy = new AnnotationStrategy();
        Persister serializer = new Persister((Strategy)strategy, format);
        serializer.write((Object)this, out);
    }

    public static @Nullable Categories loadCategoriesFromFile(File source) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream categoriesInStr = UtilsDecryption.getFileInputStream((File)source);){
                Persister serializer = new Persister();
                Categories result = (Categories)serializer.read(Categories.class, categoriesInStr);
                if (SWToolsProperties.isVerificationOn()) {
                    try {
                        URL schema;
                        try {
                            schema = new URL(result.getSchemaLocation());
                            XSDUtils.verifySchemaVersion((URL)schema, (File)source);
                        }
                        catch (MalformedURLException e) {
                            LOGGER.log(Level.SEVERE, "[DATA] Invalid schema URL in component categories file " + source.getAbsolutePath(), e);
                            schema = null;
                        }
                        UtilsXML.validXml((InputStream)UtilsDecryption.getFileInputStream((File)source), (URL)schema, (Path)Categories.getFallbackSchemaLocation());
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.SEVERE, "[DATA] Missing schema for component categories file " + source.getAbsolutePath(), e);
                    }
                    catch (SAXException e) {
                        LOGGER.log(Level.SEVERE, "[DATA] Invalid component categories file " + source.getAbsolutePath(), e);
                    }
                }
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "[DATA] Error loading component categories file " + source.getAbsolutePath(), e);
            return null;
        }
    }

    private static Path getFallbackSchemaLocation() {
        return Paths.get(Platform.isRunning() ? PEConfiguration.getSystemDirectory() : "", "categories", "schemas", LOCAL_SCHEMA);
    }
}

