/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.yaml.converters;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.common.utils.yaml.IYamlStorable;
import com.nxp.swtools.common.utils.yaml.YamlStorableList;
import com.nxp.swtools.common.utils.yaml.YamlStorableValue;
import com.nxp.swtools.provider.configuration.storage.periphs.AStoragePeriphsSetting;
import com.nxp.swtools.provider.configuration.storage.periphs.AStoragePeriphsStructuredSetting;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsComponent;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsComponentInstance;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsConfigSet;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsScalarSetting;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsSetSetting;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsStructSetting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;

public class StorageYamlConverter {
    private static final Logger LOGGER = LogManager.getLogger(StorageYamlConverter.class);
    public static final String TYPE_ID = "type_id";
    public static final String INSTANCE = "instance";
    public static final String CONFIG_SETS = "config_sets";
    public static final String CUSTOM_NAME_ENABLED = "custom_name_enabled";
    public static final String FROM_USE_CASE = "from_use_case";
    public static final String QUICK_SELECTION = "quick_selection";
    public static final String PERIPHERAL = "peripheral";
    public static final String COMMENT = "comment";
    public static final String EDITING_LOCK = "editing_lock";
    public static final String FUNCTIONAL_GROUP = "functional_group";
    public static final String MODE = "mode";
    public static final String TYPE = "type";
    public static final String NAME = "name";
    public static final String COMPONENT = "component";

    public static IYamlStorable toYamlStorable(AStoragePeriphsSetting storageSetting) {
        YamlStorableValue result;
        if (storageSetting instanceof AStoragePeriphsStructuredSetting) {
            AStoragePeriphsStructuredSetting structuredStorageSetting = (AStoragePeriphsStructuredSetting)storageSetting;
            List<IYamlStorable> children = StorageYamlConverter.toYamlStorables(structuredStorageSetting.getSettings());
            String quickSelection = null;
            if (storageSetting instanceof StoragePeriphsConfigSet) {
                quickSelection = ((StoragePeriphsConfigSet)storageSetting).getQuick_selection();
            } else if (storageSetting instanceof StoragePeriphsStructSetting) {
                quickSelection = ((StoragePeriphsStructSetting)storageSetting).getQuickSelection();
            }
            if (quickSelection != null) {
                children.add((IYamlStorable)new YamlStorableValue(QUICK_SELECTION, quickSelection));
            }
            result = new YamlStorableList(storageSetting.getName(), children, Boolean.FALSE);
        } else if (storageSetting instanceof StoragePeriphsScalarSetting) {
            result = new YamlStorableValue(storageSetting.getName(), ((StoragePeriphsScalarSetting)storageSetting).getValue());
        } else if (storageSetting instanceof StoragePeriphsSetSetting) {
            String selectedItems = (String)((StoragePeriphsSetSetting)storageSetting).getSelected().stream().collect(CollectorsUtils.joining((CharSequence)" "));
            result = new YamlStorableValue(storageSetting.getName(), selectedItems);
        } else {
            result = new YamlStorableValue(storageSetting.getName(), "");
            LOGGER.warning("[TOOL] Cannot convert storage setting to yaml storable due to unknown type: " + storageSetting.getClass());
        }
        return result;
    }

    public static List<IYamlStorable> toYamlStorables(Collection<? extends AStoragePeriphsSetting> storageSettings) {
        return (List)storageSettings.stream().map(s -> StorageYamlConverter.toYamlStorable(s)).collect(CollectorsUtils.toList());
    }

    public static IYamlStorable toYamlStorable(StoragePeriphsComponentInstance storageComponent, @Nullable String functionalGroup, @Nullable String componentTypeId) {
        String peripheral;
        String originalUseCase;
        String comment;
        ArrayList<Object> yamlComponent = new ArrayList<Object>();
        yamlComponent.add(new YamlStorableValue(NAME, storageComponent.getName()));
        yamlComponent.add(new YamlStorableValue(TYPE, storageComponent.getType()));
        yamlComponent.add(new YamlStorableValue(MODE, storageComponent.getMode()));
        yamlComponent.add(new YamlStorableValue(CUSTOM_NAME_ENABLED, String.valueOf(storageComponent.isCustomName())));
        if (storageComponent.isEditingLocked()) {
            yamlComponent.add(new YamlStorableValue(EDITING_LOCK, Boolean.TRUE.toString()));
        }
        if (!UtilsText.isEmpty((String)(comment = storageComponent.getComment()))) {
            yamlComponent.add(new YamlStorableValue(COMMENT, comment.replaceAll("\\r\\n|\\n", "\\\\n")));
        }
        if ((originalUseCase = storageComponent.getOriginalUseCase()) != null) {
            yamlComponent.add(new YamlStorableValue(FROM_USE_CASE, originalUseCase));
        }
        if (componentTypeId != null) {
            yamlComponent.add(new YamlStorableValue(TYPE_ID, componentTypeId));
        }
        if (functionalGroup != null) {
            yamlComponent.add(new YamlStorableValue(FUNCTIONAL_GROUP, functionalGroup));
        }
        if ((peripheral = storageComponent.getPeripheral()) != null) {
            yamlComponent.add(new YamlStorableValue(PERIPHERAL, peripheral));
        }
        List<IYamlStorable> yamlConfigSets = StorageYamlConverter.toYamlStorables(storageComponent.getConfig_sets());
        yamlComponent.add(new YamlStorableList(CONFIG_SETS, yamlConfigSets, Boolean.FALSE));
        return new YamlStorableList(INSTANCE, yamlComponent, Boolean.FALSE);
    }

    public static IYamlStorable toYamlStorable(StoragePeriphsComponent storageComponent) {
        ArrayList<Object> yamlComponent = new ArrayList<Object>();
        yamlComponent.add(new YamlStorableValue(TYPE, storageComponent.getName()));
        yamlComponent.add(new YamlStorableValue(TYPE_ID, storageComponent.getTypeId()));
        StoragePeriphsConfigSet configSet = storageComponent.getConfig_set_global();
        if (configSet != null) {
            yamlComponent.add(StorageYamlConverter.toYamlStorable((AStoragePeriphsSetting)configSet));
        }
        return new YamlStorableList(COMPONENT, yamlComponent, Boolean.FALSE);
    }
}

