/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.variables.internal.preferences;

import com.nxp.s32ds.cle.ide.variables.internal.preferences.CleDynamicVariableImpl;
import com.nxp.s32ds.cle.ide.variables.internal.preferences.CleValueDescriptor;
import com.nxp.s32ds.cle.ide.variables.internal.preferences.CleValueVariableImpl;
import com.nxp.s32ds.cle.ide.variables.internal.preferences.CleVariableCategoryImpl;
import com.nxp.s32ds.cle.ide.variables.internal.preferences.CleVariableImpl;
import com.nxp.s32ds.cle.ide.variables.internal.preferences.CleVariablesPreferencesActivator;
import com.nxp.s32ds.cle.ide.variables.internal.preferences.Messages;
import com.nxp.s32ds.cle.ide.variables.internal.preferences.eclipse.CleEclipseDynamicVariableDescriptor;
import com.nxp.s32ds.cle.ide.variables.internal.preferences.eclipse.CleEclipseValueVariableDescriptor;
import com.nxp.s32ds.cle.ide.variables.internal.preferences.eclipse.CleEclipseVariableDescriptor;
import com.nxp.s32ds.cle.ide.variables.internal.preferences.extension.CleVariableCategoryDescriptor;
import com.nxp.s32ds.cle.ide.variables.preferences.CleVariable;
import com.nxp.s32ds.cle.ide.variables.preferences.CleVariableCategory;
import com.nxp.s32ds.cle.ide.variables.preferences.CleVariablesManager;
import com.nxp.s32ds.ext.rcp.runtime.ExtensionDiagnostic;
import com.nxp.s32ds.ext.rcp.runtime.ExtensionDiagnostician;
import com.nxp.s32ds.ext.rcp.runtime.ExtensionValidator;
import com.nxp.s32ds.ext.rcp.runtime.RcpBundle;
import com.nxp.s32ds.ext.rcp.runtime.RcpConfigurationElementDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.osgi.util.NLS;

public class CleVariablesManagerImpl
extends CleVariablesManager {
    public static final String S32DS_PREFIX = "S32DS";
    private final List<CleVariableImpl> variables;
    private final Set<CleVariableCategoryImpl> categories;
    private final List<CleEclipseVariableDescriptor> eclipseVariableDescriptors;

    public CleVariablesManagerImpl(IStringVariableManager stringVariableManager, List<IConfigurationElement> categoriesConfigrationElements, List<IConfigurationElement> valueVariableConfigrationElements, List<IConfigurationElement> dynamicVariableConfigrationElements) {
        this.eclipseVariableDescriptors = Stream.concat(valueVariableConfigrationElements.stream().map(e -> new CleEclipseValueVariableDescriptor(stringVariableManager, (IConfigurationElement)e)), dynamicVariableConfigrationElements.stream().map(e -> new CleEclipseDynamicVariableDescriptor(stringVariableManager, (IConfigurationElement)e))).filter(d -> CleVariablesPreferencesActivator.getInstance().validate((ExtensionValidator)d)).collect(Collectors.toList());
        List categoriesList = categoriesConfigrationElements.stream().map(CleVariableCategoryDescriptor::new).filter(d -> CleVariablesPreferencesActivator.getInstance().validate((ExtensionValidator)d)).map(c -> new CleVariableCategoryImpl((RcpConfigurationElementDescriptor)c, (Collection<CleVariableImpl>)c.getVariableDescriptors().stream().map(this::createVariable).filter(Objects::nonNull).collect(Collectors.toList()))).filter(c -> !c.getVariables().isEmpty()).collect(Collectors.toList());
        this.variables = categoriesList.stream().flatMap(c -> c.getVariablesImpl().stream()).collect(Collectors.toList());
        this.variables.stream().collect(Collectors.groupingBy(CleVariable::getName, Collectors.mapping(CleVariableImpl::getDescriptor, Collectors.toList()))).entrySet().stream().forEach(e -> CleVariablesManagerImpl.reportDuplicates(e, Messages.CleVariablesManagerImpl_duplicated_variable_0_definition));
        this.categories = categoriesList.stream().collect(Collectors.toMap(cd -> cd.getName(), cd -> new CleVariableCategoryImpl(cd.getDescriptor(), new HashSet<CleVariableImpl>(cd.getVariablesImpl())), (left, right) -> {
            left.addVariables(right.getVariablesImpl());
            return left;
        })).values().stream().collect(Collectors.toSet());
        Set names = this.variables.stream().map(CleVariable::getName).collect(Collectors.toSet());
        Set<CleVariableImpl> unregisteredVariables = this.eclipseVariableDescriptors.stream().filter(e -> e.getName().startsWith(S32DS_PREFIX) && !names.contains(e.getName())).map(e -> CleVariablesManagerImpl.createVariable(null, e)).filter(Objects::nonNull).collect(Collectors.toSet());
        if (!unregisteredVariables.isEmpty()) {
            this.variables.addAll(unregisteredVariables);
            this.categories.add(new CleVariableCategoryImpl(CleVariableCategory.UNCATEGORIZED_NAME, unregisteredVariables));
        }
    }

    @Override
    public Collection<CleVariable> getVariables() {
        return Collections.unmodifiableCollection(this.variables);
    }

    @Override
    public Collection<CleVariableCategory> getCategories() {
        return Collections.unmodifiableCollection(this.categories);
    }

    private CleVariableImpl createVariable(RcpConfigurationElementDescriptor descriptor) {
        String name = descriptor.getName();
        CleEclipseVariableDescriptor eclipseVariableDescriptor = this.findEclipseVariableDescriptor(name);
        if (eclipseVariableDescriptor == null) {
            ExtensionDiagnostician.log((RcpBundle)CleVariablesPreferencesActivator.getInstance(), (ExtensionDiagnostic)new ExtensionDiagnostic(descriptor.getElement(), NLS.bind((String)Messages.CleVariablesManagerImpl_variable_0_is_not_declared, (Object)name)));
            return null;
        }
        return CleVariablesManagerImpl.createVariable(descriptor, eclipseVariableDescriptor);
    }

    private static CleVariableImpl createVariable(RcpConfigurationElementDescriptor descriptor, CleEclipseVariableDescriptor eclipseVariableDescriptor) {
        if (eclipseVariableDescriptor instanceof CleEclipseDynamicVariableDescriptor) {
            return new CleDynamicVariableImpl(descriptor, (CleEclipseDynamicVariableDescriptor)eclipseVariableDescriptor);
        }
        if (eclipseVariableDescriptor instanceof CleEclipseValueVariableDescriptor) {
            CleValueDescriptor cleValueDescriptor = ((CleEclipseValueVariableDescriptor)eclipseVariableDescriptor).getValueDescriptor();
            if (!CleVariablesPreferencesActivator.getInstance().validate((ExtensionValidator)cleValueDescriptor)) {
                return null;
            }
            return new CleValueVariableImpl(descriptor, (CleEclipseValueVariableDescriptor)eclipseVariableDescriptor);
        }
        CleVariablesPreferencesActivator.getInstance().logError(NLS.bind((String)"Unknown type ''{0}'' of variable with name ''{1}''", (Object)((Object)((Object)eclipseVariableDescriptor)).getClass().getName(), (Object)descriptor.getName()));
        return null;
    }

    private CleEclipseVariableDescriptor findEclipseVariableDescriptor(String name) {
        return this.eclipseVariableDescriptors.stream().filter(h -> h.getName() != null && h.getName().equals(name)).findFirst().orElse(null);
    }

    private static <T extends RcpConfigurationElementDescriptor> void reportDuplicates(Map.Entry<String, List<T>> entry, String message) {
        List<T> descriptors = entry.getValue();
        if (descriptors.size() > 1) {
            for (RcpConfigurationElementDescriptor descriptor : descriptors) {
                ExtensionDiagnostician.log((RcpBundle)CleVariablesPreferencesActivator.getInstance(), (ExtensionDiagnostic)new ExtensionDiagnostic(descriptor.getElement(), NLS.bind((String)message, (Object)entry.getKey())));
            }
        }
    }
}

