/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.status;

import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.status.UpdateStatus;
import java.util.ArrayList;
import java.util.Arrays;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BuildStepUpdateStatus
extends UpdateStatus {
    public static final String BUILD_STEP_UPDATE_STATUS_ELEMENT = "buildStep";
    public static final String BUILD_STEP_UPDATE_STATUS_OLD_COMMAND_ATTRIBUTE = "oldCommand";
    public static final String BUILD_STEP_UPDATE_STATUS_NEW_COMMAND_ATTRIBUTE = "newCommand";
    public static final String BUILD_STEP_UPDATE_STATUS_OLD_DESCRIPTION_ATTRIBUTE = "oldDescription";
    public static final String BUILD_STEP_UPDATE_STATUS_NEW_DESCRIPTION_ATTRIBUTE = "newDescription";
    public static final String BUILD_STEP_UPDATE_STATUS_IS_PRE_BUILD_STEP_ATTRIBUTE = "isPreBuildStep";
    private final boolean isPreBuildStep;

    public BuildStepUpdateStatus(String configurationName, String message, boolean isPreBuildStep) {
        super(configurationName, message);
        this.isPreBuildStep = isPreBuildStep;
    }

    public BuildStepUpdateStatus(Element updateStatusElement, String configurationName) {
        super(updateStatusElement, configurationName);
        this.isPreBuildStep = Boolean.parseBoolean(updateStatusElement.getAttribute(BUILD_STEP_UPDATE_STATUS_IS_PRE_BUILD_STEP_ATTRIBUTE));
    }

    public void setSourceValues(String commandValue, String descriptionValue) {
        this.setSourceValues(Arrays.asList(commandValue, descriptionValue));
    }

    public void setTargetValues(String commandValue, String descriptionValue) {
        this.setTargetValues(Arrays.asList(commandValue, descriptionValue));
    }

    public String getSourceCommand() {
        ArrayList<String> values = new ArrayList<String>(this.getSourceValues());
        return !values.isEmpty() ? (String)values.get(0) : "";
    }

    public String getTargetCommand() {
        ArrayList<String> values = new ArrayList<String>(this.getTargetValues());
        return !values.isEmpty() ? (String)values.get(0) : "";
    }

    public String getSourceDescription() {
        ArrayList<String> values = new ArrayList<String>(this.getSourceValues());
        return values.size() > 1 ? (String)values.get(1) : "";
    }

    public String getTargetDescription() {
        ArrayList<String> values = new ArrayList<String>(this.getTargetValues());
        return values.size() > 1 ? (String)values.get(1) : "";
    }

    public boolean isPreBuildStep() {
        return this.isPreBuildStep;
    }

    @Override
    public Element convertToXml(Document document, Element holderElement) {
        Element element = document.createElement(BUILD_STEP_UPDATE_STATUS_ELEMENT);
        this.convertAttributesToXml(element);
        holderElement.appendChild(element);
        return element;
    }

    @Override
    protected void convertAttributesToXml(Element holderElement) {
        holderElement.setAttribute(BUILD_STEP_UPDATE_STATUS_IS_PRE_BUILD_STEP_ATTRIBUTE, String.valueOf(this.isPreBuildStep));
        holderElement.setAttribute(BUILD_STEP_UPDATE_STATUS_OLD_COMMAND_ATTRIBUTE, this.getSourceCommand());
        holderElement.setAttribute(BUILD_STEP_UPDATE_STATUS_OLD_DESCRIPTION_ATTRIBUTE, this.getSourceDescription());
        holderElement.setAttribute(BUILD_STEP_UPDATE_STATUS_NEW_COMMAND_ATTRIBUTE, this.getTargetCommand());
        holderElement.setAttribute(BUILD_STEP_UPDATE_STATUS_NEW_DESCRIPTION_ATTRIBUTE, this.getTargetDescription());
    }

    @Override
    protected void initializeAttributesFromXml(Element element) {
        this.setSourceValues(element.getAttribute(BUILD_STEP_UPDATE_STATUS_OLD_COMMAND_ATTRIBUTE), element.getAttribute(BUILD_STEP_UPDATE_STATUS_OLD_DESCRIPTION_ATTRIBUTE));
        this.setTargetValues(element.getAttribute(BUILD_STEP_UPDATE_STATUS_NEW_COMMAND_ATTRIBUTE), element.getAttribute(BUILD_STEP_UPDATE_STATUS_NEW_DESCRIPTION_ATTRIBUTE));
    }

    @Override
    public String getIdentifier() {
        return "";
    }
}

