/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.project.configuration.core.validators;

import com.nxp.s32ds.cle.cdt.project.configuration.internal.core.Messages;
import com.nxp.s32ds.cle.cdt.project.configuration.internal.core.ProjectConfigurationCoreActivator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class OptionsValidator {
    public IStatus validateOption(IConfiguration configuration, String optionId, String expectedOptionValue) {
        return this.validateOption(configuration, optionId, expectedOptionValue, true);
    }

    public IStatus validateOption(IConfiguration configuration, String optionId, String expectedOptionValue, boolean isCheckEquality) {
        if (!OptionsValidator.validateArguments(configuration, optionId, expectedOptionValue)) {
            return Status.CANCEL_STATUS;
        }
        try {
            IOption option2;
            List<String> values;
            IToolChain toolChain = configuration.getToolChain();
            Optional<IOption> optional = Arrays.stream(toolChain.getOptions()).filter(option -> option.getBaseId().equals(optionId)).findFirst();
            if (optional.isPresent() && !OptionsValidator.isValueInvalid(values = OptionsValidator.getOptionValues(option2 = optional.get()), expectedOptionValue, isCheckEquality)) {
                return ProjectConfigurationCoreActivator.getInstance().createError(NLS.bind((String)Messages.OptionsValidator_error_incorrect_toolchain_option_value, (Object[])new Object[]{toolChain.getId(), optionId, option2.getValue()}));
            }
            ITool[] iToolArray = configuration.getTools();
            int n = iToolArray.length;
            int n2 = 0;
            while (n2 < n) {
                List<String> values2;
                ITool tool = iToolArray[n2];
                IOption toolOption = tool.getOptionBySuperClassId(optionId);
                if (toolOption != null && !OptionsValidator.isValueInvalid(values2 = OptionsValidator.getOptionValues(toolOption), expectedOptionValue, isCheckEquality)) {
                    return ProjectConfigurationCoreActivator.getInstance().createError(NLS.bind((String)Messages.OptionsValidator_error_incorrect_tool_option_value, (Object[])new Object[]{tool.getId(), optionId, toolOption.getValue()}));
                }
                ++n2;
            }
        }
        catch (BuildException be) {
            return ProjectConfigurationCoreActivator.getInstance().createError(NLS.bind((String)Messages.OptionsValidator_error_validate_option_value, (Object)optionId), be);
        }
        return Status.OK_STATUS;
    }

    public IStatus validateOptions(IConfiguration configuration, Map<String, String> expectedOptionsValues) {
        MultiStatus result = ProjectConfigurationCoreActivator.getInstance().createMultiStatus();
        expectedOptionsValues.entrySet().forEach(e -> result.add(this.validateOption(configuration, (String)e.getKey(), (String)e.getValue())));
        return result;
    }

    private static List<String> getOptionValues(IOption option) throws BuildException {
        String[] list = null;
        switch (option.getValueType()) {
            case 4: {
                list = option.getIncludePaths();
                break;
            }
            case 8: {
                list = option.getBasicStringListValue();
                break;
            }
            case 5: {
                list = option.getDefinedSymbols();
                break;
            }
            case -5: {
                list = option.getBasicStringListValue();
                break;
            }
            case 9: {
                list = option.getLibraryPaths();
                break;
            }
            case 6: {
                list = option.getLibraries();
                break;
            }
            case 3: {
                list = option.getStringListValue();
                break;
            }
            case 1: 
            case 2: {
                list = new String[]{option.getStringValue()};
                break;
            }
            case 0: {
                list = new String[]{String.valueOf(option.getBooleanValue())};
                break;
            }
        }
        return list != null ? new ArrayList<String>(Arrays.asList(list)) : null;
    }

    private static boolean validateArguments(IConfiguration configuration, String optionId, Object optionValue) {
        return configuration != null && optionId != null && optionValue != null;
    }

    private static boolean isValueInvalid(List<String> optionValues, String checkedOptionValue, boolean isCheckEquality) {
        if (optionValues == null) {
            return false;
        }
        List<Object> checkedOptionValues = null;
        checkedOptionValues = checkedOptionValue == null || checkedOptionValue.isEmpty() ? new ArrayList() : Arrays.stream(checkedOptionValue.split(",")).map(String::trim).collect(Collectors.toList());
        if (isCheckEquality) {
            return optionValues.containsAll(checkedOptionValues);
        }
        return !optionValues.containsAll(checkedOptionValues);
    }
}

