/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.project.configuration.internal.core.checkers;

import com.nxp.s32ds.ext.cdt.core.checker.IResourceChecker;
import com.nxp.s32ds.ext.ide.validation.core.BuildSettingsProjectMarker;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class BuildSettingsProjectResourceChecker
implements IResourceChecker {
    public IStatus check(IResource resource, IProgressMonitor monitor) {
        if (!(resource instanceof IProject)) {
            return Status.OK_STATUS;
        }
        IProject project = (IProject)resource;
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        if (info == null) {
            return Status.OK_STATUS;
        }
        IToolChain toolchain = info.getDefaultConfiguration().getToolChain();
        if (toolchain == null) {
            return Status.OK_STATUS;
        }
        String id = toolchain.getId();
        if (id == null || !id.contains("com.freescale.s32ds.cross") && !id.contains("com.nxp.s32ds.cle.arm.mbs")) {
            return Status.OK_STATUS;
        }
        IConfiguration defConfig = info.getDefaultConfiguration();
        IBuilder builder = defConfig.getToolChain().getBuilder();
        String buildAttr = builder.getBuildAttribute("org.eclipse.cdt.make.core.build.target.inc", "");
        String cleanAttr = builder.getBuildAttribute("org.eclipse.cdt.make.core.build.target.clean", "");
        if ((buildAttr.isEmpty() || cleanAttr.isEmpty()) && !BuildSettingsProjectMarker.containsMarker((IResource)project)) {
            return BuildSettingsProjectMarker.createMarker((IProject)project);
        }
        if (BuildSettingsProjectMarker.containsMarker((IResource)project)) {
            BuildSettingsProjectMarker.delete((IResource)project);
        }
        return Status.OK_STATUS;
    }
}

