/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.project.configuration.internal.core.updaters;

import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.UpdateOperation;
import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.status.BuilderAttributeUpdateStatus;
import com.nxp.s32ds.cle.cdt.project.configuration.internal.core.ProjectConfigurationCoreActivator;
import com.nxp.s32ds.cle.cdt.project.configuration.internal.core.updaters.ProjectConfigurationInfo;
import com.nxp.s32ds.cle.cdt.project.configuration.internal.core.updaters.ProjectSettingsUpdaterBase;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class BuilderAttributesUpdater
extends ProjectSettingsUpdaterBase {
    @Override
    public IStatus update(IConfiguration configuration, String attributeName, String value, UpdateOperation operation) {
        IStatus status = this.validateArguments(configuration, attributeName, value, operation);
        if (!status.isOK()) {
            return status;
        }
        try {
            ProjectConfigurationInfo info = ProjectConfigurationInfo.create(configuration);
            IBuilder builder = info.configuration.getBuilder();
            String sourceValue = builder.getBuildAttribute("org.eclipse.cdt.make.core.build.target.inc", "");
            if (value.equals(sourceValue)) {
                return Status.CANCEL_STATUS;
            }
            BuilderAttributeUpdateStatus updateStatus = new BuilderAttributeUpdateStatus(attributeName, info.configuration.getName(), "");
            updateStatus.setSourceValue(sourceValue);
            updateStatus.setTargetValue(value);
            builder.setBuildAttribute("org.eclipse.cdt.make.core.build.target.inc", value);
            ManagedBuildManager.saveBuildInfo((IProject)info.project, (boolean)true);
            CoreModel.getDefault().setProjectDescription(info.project, info.projectDescription);
            return updateStatus;
        }
        catch (CoreException e) {
            return BuilderAttributesUpdater.handleException("bulder attribute", attributeName, value, e);
        }
    }

    @Override
    protected IStatus validateArguments(IConfiguration configuration, String attributeName, Object value, UpdateOperation operation) {
        IStatus status = super.validateArguments(configuration, attributeName, value, operation);
        if (!status.isOK()) {
            return status;
        }
        if (!"incrementalBuildTarget".equals(attributeName)) {
            return ProjectConfigurationCoreActivator.getInstance().createError(NLS.bind((String)"{0} attribute expected", (Object)"incrementalBuildTarget"), new IllegalStateException());
        }
        return Status.OK_STATUS;
    }
}

