/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.project.configuration.internal.core.updaters;

import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.UpdateOperation;
import com.nxp.s32ds.cle.cdt.project.configuration.internal.core.ProjectConfigurationCoreActivator;
import com.nxp.s32ds.cle.cdt.project.configuration.internal.core.updaters.ProjectSettingsUpdaterBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.CSourceEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class SourceEntriesUpdater
extends ProjectSettingsUpdaterBase {
    @Override
    public IStatus update(IConfiguration configuration, String name, String value, UpdateOperation operation) {
        try {
            IProject project = (IProject)configuration.getOwner();
            ICProjectDescription projectDescription = CoreModel.getDefault().getProjectDescription(project);
            ICConfigurationDescription[] configurationDescriptions = projectDescription.getConfigurations();
            switch (operation) {
                case ADD: {
                    SourceEntriesUpdater.addSourceEntry(value, configuration, configurationDescriptions);
                    break;
                }
                case REMOVE: {
                    SourceEntriesUpdater.removeSourceEntry(value, configuration, configurationDescriptions);
                    break;
                }
                case REPLACE_EXISTING: {
                    SourceEntriesUpdater.replaceExistingSourceEntries(value, configuration, configurationDescriptions);
                    break;
                }
                case CLEAN_EXISTING: {
                    SourceEntriesUpdater.cleanExistingSourceEntries(configuration, configurationDescriptions);
                }
            }
            CoreModel.getDefault().setProjectDescription(project, projectDescription);
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            return SourceEntriesUpdater.handleException("entry", "source", value, e);
        }
    }

    @Override
    public IStatus update(IConfiguration configuration, String name, Collection<String> values, UpdateOperation operation) {
        return ProjectConfigurationCoreActivator.getInstance().createStatus(values.stream().map(v -> this.update(configuration, null, (String)v, operation)).collect(Collectors.toList()));
    }

    private static void addSourceEntry(String path, IConfiguration configForUpdate, ICConfigurationDescription[] configDescriptions) throws CoreException {
        ICConfigurationDescription[] iCConfigurationDescriptionArray = configDescriptions;
        int n = configDescriptions.length;
        int n2 = 0;
        while (n2 < n) {
            ArrayList<ICSourceEntry> sourceEntries;
            ICConfigurationDescription configDescription = iCConfigurationDescriptionArray[n2];
            if ((configForUpdate == null || configDescription.getName().equals(configForUpdate.getName())) && (sourceEntries = SourceEntriesUpdater.getSourceEntries(configDescription)).stream().noneMatch(se -> se.getName().equals(path))) {
                sourceEntries.add(SourceEntriesUpdater.newSourceEntry(Path.fromOSString((String)path), new IPath[0]));
                configDescription.setSourceEntries(sourceEntries.toArray(new ICSourceEntry[0]));
            }
            ++n2;
        }
    }

    private static void removeSourceEntry(String path, IConfiguration configForUpdate, ICConfigurationDescription[] configDescriptions) throws CoreException {
        ICConfigurationDescription[] iCConfigurationDescriptionArray = configDescriptions;
        int n = configDescriptions.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription configDescription = iCConfigurationDescriptionArray[n2];
            if (configForUpdate == null || configDescription.getName().equals(configForUpdate.getName())) {
                ArrayList<ICSourceEntry> sourceEntries = SourceEntriesUpdater.getSourceEntries(configDescription);
                IPath pathToRemove = Path.fromOSString((String)path);
                ICSourceEntry sourceEntry = SourceEntriesUpdater.getMatchedExactlySourceEntry(pathToRemove, sourceEntries);
                if (sourceEntry != null) {
                    sourceEntries.remove(sourceEntry);
                    configDescription.setSourceEntries(sourceEntries.toArray(new ICSourceEntry[0]));
                } else {
                    sourceEntry = SourceEntriesUpdater.getMatchedEnclosedSourceEntry(pathToRemove, sourceEntries);
                    if (sourceEntry != null) {
                        IPath relativeExcludedPath;
                        IPath sourceEntryPath = sourceEntry.getFullPath();
                        ArrayList<IPath> excludedPaths = SourceEntriesUpdater.getExcludedPaths(sourceEntry);
                        if (!excludedPaths.contains(relativeExcludedPath = pathToRemove.makeRelativeTo(sourceEntryPath))) {
                            excludedPaths.add(relativeExcludedPath);
                            sourceEntries.add(SourceEntriesUpdater.newSourceEntry(sourceEntryPath, excludedPaths.toArray(new IPath[0])));
                            sourceEntries.remove(sourceEntry);
                            configDescription.setSourceEntries(sourceEntries.toArray(new ICSourceEntry[0]));
                        }
                    }
                }
            }
            ++n2;
        }
    }

    private static void replaceExistingSourceEntries(String path, IConfiguration configForUpdate, ICConfigurationDescription[] configDescriptions) throws CoreException {
        ICConfigurationDescription[] iCConfigurationDescriptionArray = configDescriptions;
        int n = configDescriptions.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription configDescription = iCConfigurationDescriptionArray[n2];
            if (configForUpdate == null || configDescription.getName().equals(configForUpdate.getName())) {
                ArrayList<ICSourceEntry> sourceEntries = new ArrayList<ICSourceEntry>();
                sourceEntries.add(SourceEntriesUpdater.newSourceEntry(Path.fromOSString((String)path), new IPath[0]));
                configDescription.setSourceEntries(sourceEntries.toArray(new ICSourceEntry[0]));
            }
            ++n2;
        }
    }

    private static void cleanExistingSourceEntries(IConfiguration configForUpdate, ICConfigurationDescription[] configDescriptions) throws CoreException {
        ICConfigurationDescription[] iCConfigurationDescriptionArray = configDescriptions;
        int n = configDescriptions.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription configDescription = iCConfigurationDescriptionArray[n2];
            if (configForUpdate == null || configDescription.getName().equals(configForUpdate.getName())) {
                configDescription.setSourceEntries(new ICSourceEntry[0]);
            }
            ++n2;
        }
    }

    private static ArrayList<ICSourceEntry> getSourceEntries(ICConfigurationDescription configDescription) {
        return new ArrayList<ICSourceEntry>(Arrays.asList(configDescription.getSourceEntries()));
    }

    private static ICSourceEntry newSourceEntry(IPath path, IPath ... excludedPaths) {
        return new CSourceEntry(path, excludedPaths, 24);
    }

    private static ICSourceEntry getMatchedExactlySourceEntry(IPath pathToRemove, List<ICSourceEntry> sourceEntries) {
        return sourceEntries.stream().filter(sourceEntry -> sourceEntry.getFullPath().equals((Object)pathToRemove)).findFirst().orElse(null);
    }

    private static ICSourceEntry getMatchedEnclosedSourceEntry(IPath pathToRemove, List<ICSourceEntry> sourceEntries) {
        return sourceEntries.stream().filter(sourceEntry -> sourceEntry.getFullPath().isPrefixOf(pathToRemove)).max((sourceEntry1, sourceEntry2) -> {
            if (sourceEntry1.getName().length() > sourceEntry2.getName().length()) {
                return 1;
            }
            if (sourceEntry1.getName().length() < sourceEntry2.getName().length()) {
                return -1;
            }
            return 0;
        }).orElse(null);
    }

    private static ArrayList<IPath> getExcludedPaths(ICSourceEntry sourceEntry) {
        return new ArrayList<IPath>(Arrays.asList(sourceEntry.getExclusionPatterns()));
    }
}

