/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.ui.attach;

import com.nxp.s32ds.cle.cdt.sdk.core.attach.checkers.SdkAttachMissingProjectFilesCheckHandler;
import com.nxp.s32ds.cle.cdt.sdk.core.filtering.ProjectCompatibleSdksFilter;
import com.nxp.s32ds.cle.cdt.sdk.core.module.SdkModulesHelper;
import com.nxp.s32ds.cle.cdt.sdk.filtering.SdkFilter;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.Messages;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.SdkUiActivator;
import com.nxp.s32ds.cle.ide.sdk.core.resource.SdkProjectResourcesUtils;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkDescriptor;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SdkAttachMissingFilesUiHandler
implements SdkAttachMissingProjectFilesCheckHandler {
    public boolean isRestoreMissingProjectFiles(Map<String, Set<ResourceSdkDescriptor>> missingProjectFiles, IProject project) {
        if (missingProjectFiles.isEmpty()) {
            return false;
        }
        LinkedHashMap<String, Set<String>> missingProjectPaths = new LinkedHashMap<String, Set<String>>();
        for (Map.Entry<String, Set<ResourceSdkDescriptor>> e : missingProjectFiles.entrySet()) {
            SdkDescriptor sdk = SdkDescriptors.getSdkDescriptor((String)e.getKey());
            Set<ResourceSdkDescriptor> missingProjectResources = e.getValue();
            if (sdk == null || missingProjectResources == null) continue;
            missingProjectResources.stream().sorted((resource1, resource2) -> resource1.getSdkId().compareTo(resource2.getSdkId())).forEach(resource -> {
                SdkDescriptor resourceSdk = SdkDescriptors.getSdkDescriptor((String)resource.getSdkId());
                String projectPath = SdkAttachMissingFilesUiHandler.getResourceProjectPath(resource, resourceSdk, sdk, project);
                String sdkIdentifier = NLS.bind((String)"{0} v {1}", (Object)resourceSdk.getName(), (Object)resourceSdk.getVersion());
                missingProjectPaths.computeIfAbsent(sdkIdentifier, s -> new TreeSet()).add(projectPath);
            });
        }
        MultiStatus status = SdkAttachMissingFilesUiHandler.createWarning(missingProjectPaths, project);
        boolean[] isConfirmed = new boolean[1];
        Shell shell = Display.getDefault().getActiveShell();
        shell.getDisplay().syncExec(() -> {
            boolean bl = blArray[0] = new MissingSdkProjectFilesDialog(shell, (IStatus)status).open() == 0;
        });
        return isConfirmed[0];
    }

    private static String getResourceProjectPath(ResourceSdkDescriptor resource, SdkDescriptor resourceSdk, SdkDescriptor sdk, IProject project) {
        String sdkId = sdk.getId();
        String resourceSdkId = resource.getSdkId();
        if (!resourceSdkId.equals(sdkId) && SdkModulesHelper.getRefModulesSdksDescriptors((String)sdkId, (SdkFilter)new ProjectCompatibleSdksFilter(project)).stream().anyMatch(refSdk -> refSdk.getId().equals(resourceSdkId))) {
            return SdkProjectResourcesUtils.getTargetResource((ResourceSdkDescriptor)resource, (SdkDescriptor)resourceSdk, (IProject)project, (SdkDescriptor)sdk).getProjectRelativePath().toOSString();
        }
        return SdkProjectResourcesUtils.getTargetResource((ResourceSdkDescriptor)resource, (SdkDescriptor)resourceSdk, (IProject)project).getProjectRelativePath().toOSString();
    }

    private static MultiStatus createWarning(Map<String, Set<String>> handledCheckResults, IProject project) {
        String message = handledCheckResults.size() == 1 ? NLS.bind((String)Messages.SdkAttachUiHandler_warning_missed_files_from_attached_sdk, (Object)handledCheckResults.keySet().iterator().next(), (Object)project.getName()) : NLS.bind((String)Messages.SdkAttachUiHandler_warning_missed_files_from_attached_sdks, (Object)project.getName());
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Set<String>> e : handledCheckResults.entrySet()) {
            if (handledCheckResults.size() > 1) {
                sb.append(String.format("[%s]:%n", e.getKey()));
            }
            e.getValue().forEach(filePath -> {
                StringBuilder stringBuilder2 = sb.append(String.format("   - %s%n", filePath));
            });
            sb.append('\n');
        }
        MultiStatus status = SdkUiActivator.getInstance().createMultiStatus(2, message);
        status.add(SdkUiActivator.getInstance().createWarning(sb.toString()));
        return status;
    }

    private static class MissingSdkProjectFilesDialog
    extends ErrorDialog {
        private MissingSdkProjectFilesDialog(Shell parentShell, IStatus status) {
            super(parentShell, Messages.MissingSdkProjectFilesDialog_title, null, status, 2);
        }

        protected boolean shouldShowDetailsButton() {
            return true;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, Messages.MissingSdkProjectFilesDialog_button_restore, false);
            this.createButton(parent, 1, Messages.MissingSdkProjectFilesDialog_button_cancel, false);
            this.createDetailsButton(parent);
        }
    }
}

