/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.ui.attach;

import com.nxp.s32ds.cle.cdt.sdk.core.checkers.files.AbstractSdkProjectFilesChecker;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.attach.SdkAttachProjectResourcesOverrideData;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.Messages;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.SdkUiActivator;
import com.nxp.s32ds.cle.cdt.sdk.ui.attach.ConflictingSdkProjectFilesDialog;
import com.nxp.s32ds.cle.ide.sdk.core.resource.SdkProjectResourcesUtils;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkDescriptor;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SdkAttachUiHandler {
    private SdkAttachUiHandler() {
    }

    public static boolean isConfirmMissedProjectFilesRestoring(Map<String, Set<ResourceSdkDescriptor>> checkResults, IProject project) {
        LinkedHashMap<String, Set> handledCheckResults = new LinkedHashMap<String, Set>();
        for (Map.Entry<String, Set<ResourceSdkDescriptor>> e : checkResults.entrySet()) {
            SdkDescriptor sdkDescriptor = SdkDescriptors.getSdkDescriptor((String)e.getKey());
            if (sdkDescriptor == null) continue;
            String sdkIdentifier = NLS.bind((String)"{0} v {1}", (Object)sdkDescriptor.getName(), (Object)sdkDescriptor.getVersion());
            for (ResourceSdkDescriptor resource : e.getValue()) {
                String projectPath = SdkProjectResourcesUtils.getTargetResource((ResourceSdkDescriptor)resource, (SdkDescriptor)sdkDescriptor, (IProject)project).getProjectRelativePath().toOSString();
                handledCheckResults.computeIfAbsent(sdkIdentifier, s -> new TreeSet()).add(projectPath);
            }
        }
        String message = handledCheckResults.size() == 1 ? NLS.bind((String)Messages.SdkAttachUiHandler_warning_missed_files_from_attached_sdk, handledCheckResults.keySet().iterator().next(), (Object)project.getName()) : NLS.bind((String)Messages.SdkAttachUiHandler_warning_missed_files_from_attached_sdks, (Object)project.getName());
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : handledCheckResults.entrySet()) {
            if (handledCheckResults.size() > 1) {
                sb.append(String.format("[%s]:%n", entry.getKey()));
            }
            ((Set)entry.getValue()).forEach(filePath -> {
                StringBuilder stringBuilder2 = sb.append(String.format("   - %s%n", filePath));
            });
            sb.append('\n');
        }
        MultiStatus multiStatus = SdkUiActivator.getInstance().createMultiStatus(2, message);
        multiStatus.add(SdkUiActivator.getInstance().createWarning(sb.toString()));
        boolean[] isConfirmed = new boolean[1];
        Shell shell = Display.getDefault().getActiveShell();
        shell.getDisplay().syncExec(() -> {
            boolean bl = blArray[0] = new MissingSdkProjectFilesDialog(shell, (IStatus)status).open() == 0;
        });
        return isConfirmed[0];
    }

    public static IStatus checkConflictingProjectFiles(SdkDescriptor sdkDescriptor, IProject project, SdkAttachProjectResourcesOverrideData overrideData) {
        Map conflictingFiles = AbstractSdkProjectFilesChecker.getConflictingFiles((SdkDescriptor)sdkDescriptor, (IProject)project);
        if (!conflictingFiles.isEmpty()) {
            ConflictingSdkProjectFilesDialog conflictingFilesDialog = new ConflictingSdkProjectFilesDialog(Display.getDefault().getActiveShell(), sdkDescriptor, project, conflictingFiles);
            int dialogStatus = conflictingFilesDialog.open();
            IStatus checkStatus = Status.OK_STATUS;
            if (dialogStatus == 0) {
                overrideData.setFilesToOverride(conflictingFilesDialog.getResourcesToOverride());
                overrideData.setBackupFiles(conflictingFilesDialog.isBackupFiles());
            } else if (1 == dialogStatus) {
                checkStatus = SdkUiActivator.getInstance().createStatus(8, Messages.ConflictingSdkProjectFilesDialog_cancelled_msg);
            }
            if (!checkStatus.isOK()) {
                return checkStatus;
            }
        }
        return Status.OK_STATUS;
    }

    public static void openAttachUnavailableSdksError(Collection<SdkDescriptor> unavailableSdks) {
        StringBuilder sb = new StringBuilder();
        unavailableSdks.forEach(sdkDescriptor -> {
            StringBuilder stringBuilder2 = sb.append(String.format("- %s%n", NLS.bind((String)"{0} v {1}", (Object)sdkDescriptor.getName(), (Object)sdkDescriptor.getVersion())));
        });
        Shell shell = Display.getDefault().getActiveShell();
        shell.getDisplay().syncExec(() -> MessageDialog.openError((Shell)shell, (String)Messages.SdkAttachUiHandler_error_cannot_attach_unavailable_sdk_title, (String)NLS.bind((String)Messages.SdkAttachUiHandler_error_cannot_attach_unavailable_sdk_message, (Object)sb.toString())));
    }

    public static void openNotAttachedSdksWarning(List<IStatus> notAttachedSdksStatuses) {
        StringBuilder result = new StringBuilder();
        for (IStatus status : notAttachedSdksStatuses) {
            if (result.length() > 0) {
                result.append('\n');
            }
            result.append(status.getMessage());
        }
        if (result.length() > 0) {
            MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)"SDK Attach Warning", (String)NLS.bind((String)Messages.SdkAttachUiHandler_warning_not_attached_sdks_message, (Object)result.toString()));
        }
    }

    private static class MissingSdkProjectFilesDialog
    extends ErrorDialog {
        private MissingSdkProjectFilesDialog(Shell parentShell, IStatus status) {
            super(parentShell, Messages.MissingSdkProjectFilesDialog_title, null, status, 2);
        }

        protected boolean shouldShowDetailsButton() {
            return true;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, Messages.MissingSdkProjectFilesDialog_button_restore, false);
            this.createButton(parent, 1, Messages.MissingSdkProjectFilesDialog_button_cancel, false);
            this.createDetailsButton(parent);
        }
    }
}

