/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit;

import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkDescriptorUtils;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.SdkCoreActivator;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.ModelSdk;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.SdkHeader;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.ToolChainHolder;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.module.SdkModule;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkType;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.environment.EnvironmentSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.environment.EnvironmentSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkKind;
import com.nxp.s32ds.cle.runtime.sdk.registry.symbol.SymbolSdkKind;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.CoreException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SdkDescriptorParser {
    private SdkType sdkType;

    public SdkDescriptorParser(SdkType sdkType) {
        this.sdkType = sdkType;
    }

    public ModelSdk parseSdkElement(Element sdkElement) {
        SdkHeader sdkHeader = new SdkHeader(true, sdkElement);
        ToolChainHolder rootToolChainHolder = SdkDescriptorParser.createRootToolChain(sdkElement, sdkHeader);
        List<ToolChainHolder> toolChainsHolders = SdkDescriptorParser.createToolChains(sdkElement, sdkHeader);
        ModelSdk sdk = this.createSdk(sdkHeader, rootToolChainHolder, toolChainsHolders.toArray(new ToolChainHolder[0]));
        SdkDescriptorParser.createModules(sdkElement).forEach(sdk::addModule);
        return sdk;
    }

    private static ToolChainHolder createRootToolChain(Element sdkElement, SdkHeader sdkHeader) {
        String rootToolChainId = sdkElement.getAttribute("toolchains");
        ToolChainHolder rootToolChainHolder = new ToolChainHolder(!rootToolChainId.isEmpty() ? rootToolChainId : null);
        SdkDescriptorParser.parseToolChainChildElements(SdkDescriptorParser.retrieveSdkBasePath(sdkHeader), rootToolChainHolder, sdkElement);
        return rootToolChainHolder;
    }

    private static List<ToolChainHolder> createToolChains(Element sdkElement, SdkHeader sdkHeader) {
        ArrayList<ToolChainHolder> toolChainsHolders = new ArrayList<ToolChainHolder>();
        String sdkBasePath = SdkDescriptorParser.retrieveSdkBasePath(sdkHeader);
        for (Element toolChainElement : SdkDescriptorParser.getChildElements(sdkElement, "toolchain")) {
            ToolChainHolder toolChainHolder = new ToolChainHolder(toolChainElement, sdkBasePath);
            toolChainsHolders.add(toolChainHolder);
        }
        return toolChainsHolders;
    }

    private static void parseToolChainChildElements(String sdkBasePath, ToolChainHolder toolChainHolder, Element holderElement) {
        String[] resourceElementsNames = ResourceSdkKind.validValues().stream().map(ResourceSdkKind::getXmlElementName).collect(Collectors.toList()).toArray(new String[0]);
        SdkDescriptorParser.getChildElements(holderElement, resourceElementsNames).forEach(element -> toolChainHolder.process((Element)element, sdkBasePath));
        Arrays.stream(holderElement.getAttribute("symbols").split(",")).map(String::trim).forEach(symbolName -> toolChainHolder.addSymbol((String)symbolName, "", "", SymbolSdkKind.DEFINED_SYMBOL));
        SdkDescriptorParser.getChildElements(holderElement, "symbols").stream().flatMap(symbolsEl -> SdkDescriptorParser.getChildElements(symbolsEl, "symbol").stream()).forEach(toolChainHolder::addSymbol);
    }

    private static Set<SdkModule> createModules(Element sdkElement) {
        LinkedHashSet<SdkModule> modules = new LinkedHashSet<SdkModule>();
        SdkDescriptorParser.getChildElements(sdkElement, "modules").stream().flatMap(modulesEl -> SdkDescriptorParser.getChildElements(modulesEl, "module").stream()).forEach(moduleElement -> {
            boolean bl = modules.add(new SdkModule((Element)moduleElement));
        });
        return modules;
    }

    private static Collection<Element> getChildElements(Element parentElement, String ... childElementNames) {
        ArrayList<Element> elements = new ArrayList<Element>();
        List<String> filterNames = Arrays.asList(childElementNames);
        NodeList nodeList = parentElement.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node instanceof Element && (filterNames.contains(node.getNodeName()) || filterNames.isEmpty())) {
                elements.add((Element)Element.class.cast(node));
            }
            ++i;
        }
        return elements;
    }

    private static String retrieveSdkBasePath(SdkHeader sdkHeader) {
        String sdkBasePath = sdkHeader.getBasePath();
        EnvironmentSdkDescriptor sdkEnvironment = EnvironmentSdkDescriptors.getEnvironmentSdkDescriptorBySdkId((String)sdkHeader.getId());
        if ((sdkBasePath == null || sdkBasePath.trim().isEmpty()) && sdkEnvironment != null) {
            sdkBasePath = sdkEnvironment.getValue();
        }
        return sdkBasePath;
    }

    private ModelSdk createSdk(SdkHeader sdkHeader, ToolChainHolder rootToolChainHolder, ToolChainHolder[] toolChainsHolders) {
        return SdkType.EXTERNAL == this.sdkType || SdkType.IMPORTED == this.sdkType ? new ModelSdk(this.sdkType, sdkHeader, rootToolChainHolder, toolChainsHolders) : new ModelSdk(this.sdkType, sdkHeader, rootToolChainHolder, new ToolChainHolder[0]);
    }

    public static ModelSdk getSdkByDescriptor(SdkDescriptor sdkDescriptor) {
        if (sdkDescriptor == null) {
            return null;
        }
        try {
            return new SdkDescriptorParser(sdkDescriptor.getType()).parseSdkElement(SdkDescriptorUtils.convertSdkDescriptorToXml((SdkDescriptor)sdkDescriptor));
        }
        catch (ParserConfigurationException | CoreException e) {
            SdkCoreActivator.getInstance().logError("Unable to parse SDK.", e);
            return null;
        }
    }
}

