/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model;

import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.SdkHeader;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.ToolChainHolder;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.module.SdkModule;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.module.SdkModulesHolder;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.resource.SdkResourcesHolder;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.symbol.SdkSymbolsHolder;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkType;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.environment.EnvironmentSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.environment.EnvironmentSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkGroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class ModelSdk {
    private SdkHeader head;
    private ToolChainHolder root;
    private ToolChainHolder[] toolchains;
    private SdkModulesHolder modulesHolder;
    private SdkType type;

    public ModelSdk(SdkType type, SdkHeader head, ToolChainHolder root, ToolChainHolder[] toolChainHolders) {
        this.type = type;
        this.head = Objects.requireNonNull(head);
        this.root = Objects.requireNonNull(root);
        this.toolchains = toolChainHolders;
        this.modulesHolder = new SdkModulesHolder(this.getId(), head.getName(), head.getDescription());
    }

    public SdkType getType() {
        return this.type;
    }

    public SdkHeader getHeader() {
        return this.head;
    }

    public ToolChainHolder getRoot() {
        return this.root;
    }

    public ToolChainHolder[] getToolchains() {
        return this.toolchains;
    }

    public SdkModulesHolder getModules() {
        return this.modulesHolder;
    }

    public void addModule(SdkModule module) {
        this.modulesHolder.addRefModule(module);
    }

    public Map<String, SdkSymbolsHolder> getSymbols(String toolChainId) {
        HashMap<String, SdkSymbolsHolder> result = new HashMap<String, SdkSymbolsHolder>();
        result.put(this.root.getTCId(), this.root.getSymbolsHolder());
        if (this.toolchains != null) {
            Arrays.stream(this.toolchains).filter(tcHolder -> ModelSdk.isToolChainCompatible(toolChainId, tcHolder)).forEach(tcHolder -> {
                SdkSymbolsHolder sdkSymbolsHolder = result.put(tcHolder.getTCId(), tcHolder.getSymbolsHolder());
            });
        }
        if (this.modulesHolder != null) {
            for (ModelSdk moduleSdk : this.modulesHolder.getRefModulesSdks()) {
                String moduleSdkRootToolChainId = moduleSdk.getRoot().getTCId();
                Map<String, SdkSymbolsHolder> moduleSdkSymbols = moduleSdk.getSymbols(moduleSdkRootToolChainId);
                for (Map.Entry<String, SdkSymbolsHolder> e : moduleSdkSymbols.entrySet()) {
                    String moduleToolChainId = e.getKey();
                    SdkSymbolsHolder mergedHolder = (SdkSymbolsHolder)result.get(moduleToolChainId);
                    SdkSymbolsHolder moduleHolder = e.getValue();
                    if (mergedHolder == null) {
                        result.put(moduleToolChainId, moduleHolder);
                        continue;
                    }
                    mergedHolder.merge(moduleHolder);
                }
            }
        }
        return result;
    }

    private static boolean isToolChainCompatible(String toolChainId, ToolChainHolder tcHolder) {
        return toolChainId == null || "all_toolchains".equals(toolChainId) || toolChainId.equals(tcHolder.getTCId());
    }

    public boolean isPex() {
        return this.head.isPEx();
    }

    public String getId() {
        return this.head.getId();
    }

    public String toString() {
        EnvironmentSdkDescriptor env = EnvironmentSdkDescriptors.getEnvironmentSdkDescriptorBySdkId((String)this.getId());
        return String.format("SDK[%s %s @ %s]", this.head.getName(), this.head.getVersion().toString(), env == null ? "NULL" : env.getName());
    }

    public Map<String, List<SdkResourcesHolder>> getResources(ResourceSdkGroup resourceType, String toolChainId) {
        LinkedHashMap<String, List<SdkResourcesHolder>> result = new LinkedHashMap<String, List<SdkResourcesHolder>>();
        if (this.root != null) {
            SdkResourcesHolder rootHolder = new SdkResourcesHolder(this.root.getTCId());
            this.root.getResourceByType(resourceType).forEach(rootHolder::addResource);
            result.computeIfAbsent(this.getId(), s -> new ArrayList()).add(rootHolder);
        }
        if (this.toolchains != null && toolChainId != null) {
            List filteredToolChainHolders = Arrays.stream(this.toolchains).filter(tch -> ModelSdk.isToolChainCompatible(toolChainId, tch)).collect(Collectors.toList());
            for (ToolChainHolder tch2 : filteredToolChainHolders) {
                SdkResourcesHolder toolChainResourcesHolder = new SdkResourcesHolder(tch2.getTCId());
                tch2.getResourceByType(resourceType).forEach(toolChainResourcesHolder::addResource);
                result.computeIfAbsent(this.getId(), s -> new ArrayList()).add(toolChainResourcesHolder);
            }
        }
        if (this.modulesHolder != null && this.modulesHolder.hasModules()) {
            this.modulesHolder.getRefModulesSdksResources(resourceType, toolChainId).entrySet().forEach(e -> {
                List list = result.put((String)e.getKey(), (List)e.getValue());
            });
        }
        return result;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.head == null ? 0 : this.head.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModelSdk other = (ModelSdk)obj;
        return !(this.head == null ? other.getHeader() != null : !this.head.equals(other.getHeader()));
    }
}

