/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.resource;

import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.resource.ExtendedPath;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.resource.ResourceSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkAction;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkKind;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public class SdkResource {
    protected ExtendedPath path;
    private String langId;
    private Set<String> relatedConfigurations;
    protected ResourceSdkKind type;

    protected SdkResource(ResourceSdkKind type, ExtendedPath path) {
        this.type = type;
        this.path = Objects.requireNonNull(path);
        this.langId = null;
    }

    protected SdkResource(ResourceSdkKind type, ExtendedPath path, String langId) {
        this(type, path);
        this.langId = langId;
    }

    protected SdkResource(ResourceSdkKind type, ExtendedPath path, String langId, Set<String> relatedConfigurations) {
        this(type, path, langId);
        this.relatedConfigurations = relatedConfigurations;
    }

    protected SdkResource(Element element, String sdkBasePath) {
        this.type = ResourceSdkKind.of((String)element.getNodeName());
        this.path = SdkResource.initResourcePath(element, sdkBasePath);
        this.langId = element.getAttribute("langId");
        this.relatedConfigurations = SdkResource.initRelatedConfigurations(element);
    }

    public ResourceSdkKind getType() {
        return this.type;
    }

    public ExtendedPath getPath() {
        return this.path;
    }

    public String getLangId() {
        return this.langId != null ? this.langId : "";
    }

    public Set<String> getRelatedConfigurations() {
        return this.relatedConfigurations != null ? this.relatedConfigurations : Collections.emptySet();
    }

    public boolean isDirectory() {
        return this.path.toFile().isDirectory();
    }

    public String toString() {
        return String.valueOf(this.path.toString()) + " langId=" + this.getLangId();
    }

    public ResourceSdkDescriptor getResourceSdkDescriptor(String sdkId) {
        List sdkResources = ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkId((String)sdkId);
        if (sdkResources != null) {
            return sdkResources.stream().filter(resource -> this.path.toOSString().equals(resource.getPath())).findFirst().orElse(null);
        }
        return null;
    }

    private static ExtendedPath initResourcePath(Element element, String sdkBasePath) {
        String resourceSourcePath;
        String elementName = element.getNodeName();
        ResourceSdkKind kind = ResourceSdkKind.of((String)elementName);
        if (ResourceSdkKind.UNRECOGNIZED_RESOURCE == kind) {
            return ExtendedPath.fromOSString("", false);
        }
        boolean isCopy = false;
        String resourceProjectPath = "";
        String renameTo = "";
        boolean isToOpen = Boolean.parseBoolean(element.getAttribute("toOpen"));
        if (kind.isAction()) {
            resourceSourcePath = element.getAttribute("fromPath");
            if (ResourceSdkAction.of((String)elementName).isCopyAction()) {
                isCopy = true;
                resourceProjectPath = element.getAttribute("toPath");
            }
        } else {
            resourceSourcePath = element.getAttribute("path");
            isCopy = Boolean.parseBoolean(element.getAttribute("copy"));
            resourceProjectPath = element.getAttribute("copyToProjectPath");
            renameTo = element.getAttribute("renameTo");
        }
        String fullPath = resourceSourcePath;
        if (sdkBasePath != null) {
            fullPath = resourceSourcePath.startsWith(sdkBasePath) ? resourceSourcePath : String.format("%s/%s", sdkBasePath, resourceSourcePath).replace('\\', '/');
        }
        boolean isDirectory = new File(fullPath).isDirectory();
        return ExtendedPath.fromOSString(fullPath, isCopy, resourceProjectPath, renameTo, isToOpen, isDirectory);
    }

    private static Set<String> initRelatedConfigurations(Element element) {
        return Arrays.stream(element.getAttribute("configurations").split(",")).map(String::trim).filter(config -> !config.isEmpty()).collect(Collectors.toSet());
    }
}

