/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.symbol;

import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.symbol.SdkSymbolsHolder;
import com.nxp.s32ds.cle.runtime.sdk.registry.symbol.SymbolSdkKind;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SdkSymbol {
    private String symbolName;
    private final String langId;
    private final SdkSymbolsHolder holder;
    private Set<String> relatedConfigurations;

    public SdkSymbol(String symbolName, String langId, SdkSymbolsHolder holder) {
        Objects.requireNonNull(symbolName);
        this.symbolName = symbolName;
        this.langId = langId != null ? langId : "";
        this.holder = holder;
        this.relatedConfigurations = new LinkedHashSet<String>();
    }

    public SdkSymbol(Element element, SdkSymbolsHolder holder) {
        this(element.getAttribute("name"), element.getAttribute("langId"), holder);
        this.relatedConfigurations = this.initRelatedConfigurations(element);
    }

    public String getSymbolName() {
        return this.symbolName;
    }

    public void setSymbolName(String symbolName) {
        this.symbolName = symbolName;
    }

    public String getLangId() {
        return this.langId != null ? this.langId : "";
    }

    public SdkSymbolsHolder getHolder() {
        return this.holder;
    }

    public String getHolderToolChainId() {
        return this.holder.getToolChainId();
    }

    public boolean isCommon() {
        return this.langId == null || this.langId.isEmpty();
    }

    public void setRelatedConfigurations(String configurations) {
        this.relatedConfigurations = configurations == null ? Collections.emptySet() : Arrays.stream(configurations.split(",")).map(String::trim).filter(config -> !config.isEmpty()).collect(Collectors.toSet());
    }

    public void setRelatedConfigurations(Set<String> configurations) {
        this.relatedConfigurations = configurations != null ? configurations : Collections.emptySet();
    }

    public Set<String> getRelatedConfigurations() {
        return this.relatedConfigurations != null ? this.relatedConfigurations : Collections.emptySet();
    }

    public boolean isAppliedForConfiguration(IConfiguration configuration) {
        return this.relatedConfigurations == null || this.relatedConfigurations.isEmpty() || configuration == null || this.relatedConfigurations.contains(configuration.getBaseId()) || this.relatedConfigurations.contains(configuration.getName());
    }

    public void convertToXml(Document document, Element symbolsElement, SymbolSdkKind type) {
        Element symbolElement = document.createElement("symbol");
        symbolElement.setAttribute("name", this.getSymbolName());
        if (this.langId != null && !this.langId.isEmpty()) {
            symbolElement.setAttribute("langId", this.langId);
        }
        if (this.relatedConfigurations != null && !this.relatedConfigurations.isEmpty()) {
            symbolElement.setAttribute("configurations", String.join((CharSequence)",", this.relatedConfigurations));
        }
        symbolElement.setAttribute("type", type.getXmlTypeAttribueValue());
        symbolsElement.appendChild(symbolElement);
    }

    private Set<String> initRelatedConfigurations(Element element) {
        return Arrays.stream(element.getAttribute("configurations").split(",")).map(String::trim).filter(config -> !config.isEmpty()).collect(Collectors.toSet());
    }
}

