/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.ui.imports;

import com.nxp.s32ds.cle.cdt.sdk.core.imports.ImportSdkHandler;
import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkManagementUtils;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.SdkUiActivator;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.imports.ImportSdkPathResolveDialog;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.imports.ImportSdkRenameDialog;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.Shell;

public class ImportSdkUiCallbackHandler
implements ImportSdkHandler {
    private Shell parent;
    private boolean isImportFromArchive;

    public ImportSdkUiCallbackHandler(Shell parent) {
        this.parent = parent;
    }

    public Map<String, String> handleRename(Map<String, String> parameters, String errorMessage) {
        ImportSdkRenameDialog renameDialog = new ImportSdkRenameDialog(this.parent, parameters, errorMessage);
        if (renameDialog.open() == 0) {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("name", renameDialog.getNewName());
            result.put("version", renameDialog.getNewVersion());
            return result;
        }
        return null;
    }

    public Map<String, String> requestRename(SdkDescriptor sdkDescriptor, String errorMessage) {
        HashMap<String, String> result = new HashMap<String, String>();
        ImportSdkRenameDialog renameDialog = new ImportSdkRenameDialog(this.parent, sdkDescriptor, errorMessage);
        if (renameDialog.open() == 0) {
            result.put("name", renameDialog.getNewName());
            result.put("version", renameDialog.getNewVersion());
        }
        return result;
    }

    public String handleChangeSourceLocation(Map<String, String> parameters, File defaultLocation) {
        String selectedLocation = null;
        ImportSdkPathResolveDialog pathResolveDialog = new ImportSdkPathResolveDialog(this.parent, defaultLocation.toString(), parameters);
        if (pathResolveDialog.open() == 0) {
            selectedLocation = pathResolveDialog.getSelectedLocation();
        } else if (this.isImportFromArchive) {
            ImportSdkUiCallbackHandler.removeExtractedFilesFolder(pathResolveDialog.getDefaultLocation());
        }
        return selectedLocation;
    }

    public void setImportOrigin(boolean isImportFromArchive) {
        this.isImportFromArchive = isImportFromArchive;
    }

    private static void removeExtractedFilesFolder(String extractedFilesFolderPath) {
        IStatus status = SdkManagementUtils.deleteFolder((File)new File(extractedFilesFolderPath));
        if (status.isMultiStatus()) {
            Stream.of(status.getChildren()).filter(childStatus -> !childStatus.isOK()).forEach(arg_0 -> ((SdkUiActivator)SdkUiActivator.getInstance()).log(arg_0));
        } else if (!status.isOK()) {
            SdkUiActivator.getInstance().log(status);
        }
    }
}

