/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.ui.info;

import com.nxp.s32ds.cle.cdt.sdk.internal.ui.info.InfoDialog;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkType;
import com.nxp.s32ds.cle.runtime.sdk.registry.buildstep.BuildStepSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.buildstep.BuildStepSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.environment.EnvironmentSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.hardware.HardwareSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.lang.LangSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.module.ModuleSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.platform.PlatformSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.toolchain.ToolChainSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.environment.EnvironmentSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.lang.LangSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.lang.LangSdkKind;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class SdkInfoDialog
extends InfoDialog {
    private SdkDescriptor sdkDescriptor;
    private SdkType sdkType;

    public SdkInfoDialog(Shell parentShell, SdkDescriptor sdkDescriptor) {
        super(parentShell, "SDK Info");
        this.sdkDescriptor = Objects.requireNonNull(sdkDescriptor);
        this.sdkType = sdkDescriptor.getType();
    }

    public SdkInfoDialog(Shell parentShell, String sdkId, SdkType sdkType) {
        super(parentShell, "SDK Info");
        this.sdkDescriptor = Objects.requireNonNull(SdkDescriptors.getSdkDescriptor((String)sdkId));
        this.sdkType = Objects.requireNonNull(sdkType);
    }

    @Override
    protected void createContent(Composite contents) {
        this.createBaseInformationGroup(contents);
        this.createEnvironmentGroup(contents);
        this.createFilterOptionsGroup(contents);
        this.createExtendedParametersGroup(contents);
        this.createModulesGroup(contents);
        this.createBuildStepsGroup(contents);
    }

    private void createBaseInformationGroup(Composite contents) {
        String basePath;
        Group group = this.createInfoGroup(contents, "Base information");
        this.createInfoElement((Composite)group, "Name:", this.sdkDescriptor.getName());
        this.createInfoElement((Composite)group, "Version:", this.sdkDescriptor.getVersion());
        this.createInfoElement((Composite)group, "Type:", this.sdkType.getName());
        this.createInfoElement((Composite)group, "ID:", this.sdkDescriptor.getId());
        String sdkDescription = this.sdkDescriptor.getDescription();
        if (sdkDescription != null && !sdkDescription.isEmpty()) {
            this.createInfoElement((Composite)group, "Description:", sdkDescription);
        }
        this.createLinkInfoElement((Composite)group, "Location:", (basePath = this.sdkDescriptor.getBasePath()) != null && !basePath.isEmpty() ? basePath : "UNDEFINED", true);
        String sdkDescriptorPath = this.sdkDescriptor.getDescriptorPath();
        if (sdkDescriptorPath != null && !sdkDescriptorPath.isEmpty()) {
            this.createLinkInfoElement((Composite)group, "Manifest:", sdkDescriptorPath, false);
        }
        if (this.sdkDescriptor.isLoadedByUser()) {
            this.createFlagInfoElement((Composite)group, "Loaded by user:");
        }
    }

    private void createEnvironmentGroup(Composite contents) {
        EnvironmentSdkDescriptor environment = EnvironmentSdkDescriptors.getEnvironmentSdkDescriptorBySdkId((String)this.sdkDescriptor.getId());
        if (environment != null) {
            Group group = this.createInfoGroup(contents, "Environment");
            this.createInfoElement((Composite)group, "Name:", environment.getName());
            String value = environment.getValue();
            this.createLinkInfoElement((Composite)group, "Value:", value != null ? value : "", true);
        }
    }

    private void createFilterOptionsGroup(Composite contents) {
        LinkedHashMap<String, String> filterOptionsParams = new LinkedHashMap<String, String>();
        String sdkId = this.sdkDescriptor.getId();
        SdkInfoDialog.createToolChainsList(filterOptionsParams, sdkId);
        SdkInfoDialog.createHardwareParamsList(filterOptionsParams, sdkId);
        SdkInfoDialog.createLanguageParamsList(filterOptionsParams, sdkId);
        SdkInfoDialog.createPlatformParamsList(filterOptionsParams, sdkId);
        if (!filterOptionsParams.isEmpty()) {
            Group optionsGroup = this.createInfoGroup(contents, "Filter options");
            filterOptionsParams.entrySet().forEach(e -> this.createInfoElement((Composite)optionsGroup, (String)e.getKey(), (String)e.getValue()));
        }
    }

    private static void createToolChainsList(Map<String, String> filterOptionsParams, String sdkId) {
        String rootToolChainId;
        Collection toolChainIds = ToolChainSdkDescriptors.getToolChainSdkDescriptorsBySdkId((String)sdkId).stream().filter(Objects::nonNull).map(toolChain -> toolChain.getToolChainId().trim()).filter(toolChainId -> !toolChainId.isEmpty()).collect(Collectors.toList());
        if (toolChainIds.size() == 1 && (rootToolChainId = (String)toolChainIds.iterator().next()) != null) {
            toolChainIds = Arrays.stream(rootToolChainId.split(",")).map(String::trim).filter(toolChainId -> !toolChainId.isEmpty()).collect(Collectors.toList());
        }
    }

    private static void createHardwareParamsList(Map<String, String> filterOptionsParams, String sdkId) {
        String deviceRevisionId;
        String coresIds;
        String deviceCoresIds;
        Map hardwareParams = HardwareSdkDescriptors.getHardwareSdkDescriptorsIds((String)sdkId);
        String devicesIds = String.join((CharSequence)",", (Iterable)hardwareParams.get("com.nxp.s32ds.cle.runtime.hardware.registry.device.id"));
        if (!devicesIds.isEmpty()) {
            filterOptionsParams.put("Devices:", devicesIds);
        }
        if (!(deviceCoresIds = String.join((CharSequence)",", (Iterable)hardwareParams.get("com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id"))).isEmpty()) {
            filterOptionsParams.put("Device cores:", deviceCoresIds);
        }
        if (!(coresIds = String.join((CharSequence)",", (Iterable)hardwareParams.get("com.nxp.s32ds.cle.runtime.hardware.registry.core.id"))).isEmpty()) {
            filterOptionsParams.put("Cores:", coresIds);
        }
        if (!(deviceRevisionId = String.join((CharSequence)",", (Iterable)hardwareParams.get("com.nxp.s32ds.cle.runtime.hardware.registry.device.revision.id"))).isEmpty()) {
            filterOptionsParams.put("Device revision:", deviceRevisionId);
        }
    }

    private static void createLanguageParamsList(Map<String, String> filterOptionsParams, String sdkId) {
        LangSdkDescriptor langs = LangSdkDescriptors.getLangSdkDescriptorBySdkId((String)sdkId);
        if (langs != null && LangSdkKind.UNKNOWN != langs.getKind()) {
            filterOptionsParams.put("Languages:", langs.getLangId());
        }
    }

    private static void createPlatformParamsList(Map<String, String> filterOptionsParams, String sdkId) {
        String platformHost;
        Map platformSdkIds = PlatformSdkDescriptors.getPlatformSdkDescriptorsIds((String)sdkId);
        String platformTarget = (String)platformSdkIds.get("com.nxp.s32ds.cle.runtime.sdk.registry.platform.target");
        if (!platformTarget.isEmpty()) {
            filterOptionsParams.put("Platform target:", platformTarget);
        }
        if (!(platformHost = (String)platformSdkIds.get("com.nxp.s32ds.cle.runtime.sdk.registry.platform.host")).isEmpty()) {
            filterOptionsParams.put("Platform host:", platformHost);
        }
    }

    private void createExtendedParametersGroup(Composite contents) {
        String externalId;
        String targetFolderName;
        String targetProjectTemplate;
        LinkedHashMap<String, String> extendedParams = new LinkedHashMap<String, String>();
        Set tags = this.sdkDescriptor.getTags();
        if (tags != null && !tags.isEmpty()) {
            extendedParams.put("Tags:", String.join((CharSequence)",", tags));
        }
        if ((targetProjectTemplate = this.sdkDescriptor.getTargetProjectTemplate()) != null && !targetProjectTemplate.isEmpty()) {
            extendedParams.put("Project template:", targetProjectTemplate);
        }
        if ((targetFolderName = this.sdkDescriptor.getTargetFolderName()) != null && !targetFolderName.isEmpty() && !targetFolderName.equals(this.sdkDescriptor.getName())) {
            extendedParams.put("Target folder name:", targetFolderName);
        }
        if ((externalId = this.sdkDescriptor.getExternalId()) != null && !externalId.isEmpty()) {
            extendedParams.put("External ID:", externalId);
        }
        if (!extendedParams.isEmpty()) {
            Group extendedParamsGroup = this.createInfoGroup(contents, "Extended parameters");
            extendedParams.entrySet().forEach(e -> this.createInfoElement((Composite)extendedParamsGroup, (String)e.getKey(), (String)e.getValue()));
        }
    }

    private void createModulesGroup(Composite contents) {
        List modules = ModuleSdkDescriptors.getModuleSdkDescriptorsBySdkId((String)this.sdkDescriptor.getId());
        if (!modules.isEmpty()) {
            Group modulesGroup = this.createInfoGroup(contents, "Modules [name -> ref. SDK id]");
            modules.forEach(module -> this.createModuleInfoElement((Composite)modulesGroup, module.getName(), module.getModuleSdkId()));
        }
    }

    private void createModuleInfoElement(Composite parent, String label, String refSdkId) {
        SdkDescriptor refSdk = SdkDescriptors.getSdkDescriptor((String)refSdkId);
        if (refSdk == null) {
            Label nameLabel = new Label(parent, 0);
            nameLabel.setText(label);
            this.createErrorDecoration((Control)nameLabel, NLS.bind((String)"SDK with id {0} not found.", (Object)refSdkId), parent).show();
            this.createTextField(parent, refSdkId);
        } else {
            String descriptorPath = refSdk.getDescriptorPath();
            if (descriptorPath != null && !descriptorPath.isEmpty()) {
                this.createLinkInfoElement(parent, label, descriptorPath, refSdkId, false);
            } else {
                this.createInfoElement(parent, label, refSdkId);
            }
        }
    }

    private void createBuildStepsGroup(Composite contents) {
        List postBuildSteps;
        List buildSteps = BuildStepSdkDescriptors.getBuildStepSdkDescriptorsBySdkId((String)this.sdkDescriptor.getId());
        if (buildSteps.isEmpty()) {
            return;
        }
        Group buildStepsGroup = this.createInfoGroup(contents, "Build steps");
        Map<Boolean, List<BuildStepSdkDescriptor>> buildStepsMap = buildSteps.stream().collect(Collectors.partitioningBy(BuildStepSdkDescriptor::isPreBuildStep));
        List preBuildSteps = buildStepsMap.getOrDefault(true, Collections.emptyList());
        if (!preBuildSteps.isEmpty()) {
            this.createInfoElement((Composite)buildStepsGroup, "Pre-build steps:", String.join((CharSequence)"\n", preBuildSteps.stream().map(BuildStepSdkDescriptor::getCommand).collect(Collectors.toList())));
        }
        if (!(postBuildSteps = buildStepsMap.getOrDefault(false, Collections.emptyList())).isEmpty()) {
            this.createInfoElement((Composite)buildStepsGroup, "Post-build steps:", String.join((CharSequence)"\n", postBuildSteps.stream().map(BuildStepSdkDescriptor::getCommand).collect(Collectors.toList())));
        }
    }
}

