/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.ui.property;

import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachDataHolder;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachProcessor;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachStatuses;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachStatusesHolder;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.checkers.SdkAttachConflictingProjectFilesCheckHandler;
import com.nxp.s32ds.cle.cdt.sdk.core.checkers.SdkAvailabilityChecker;
import com.nxp.s32ds.cle.cdt.sdk.core.exports.SdkExporter;
import com.nxp.s32ds.cle.cdt.sdk.core.imports.ImportSdkHandler;
import com.nxp.s32ds.cle.cdt.sdk.core.imports.McalSdkImporter;
import com.nxp.s32ds.cle.cdt.sdk.core.imports.SdksImporter;
import com.nxp.s32ds.cle.cdt.sdk.core.load.ExternalSdkLoader;
import com.nxp.s32ds.cle.cdt.sdk.core.load.ImportedSdkLoader;
import com.nxp.s32ds.cle.cdt.sdk.core.load.InternalSdkLoader;
import com.nxp.s32ds.cle.cdt.sdk.core.load.ProjectLocalSdkLoader;
import com.nxp.s32ds.cle.cdt.sdk.core.load.WorkspaceSdkLoader;
import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkManagementUtils;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.Messages;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.attach.SdkAttachConflictingFilesUiHandler;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.attach.SdkAttachmentChangeHandler;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.imports.ImportSdkUiCallbackHandler;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.property.AbstractSdksPropertyPage;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.property.ProjectSdksPropertyPage;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.property.WizardSdksPropertyPage;
import com.nxp.s32ds.cle.cdt.sdk.ui.attach.ShowAttachedSdksDialog;
import com.nxp.s32ds.cle.cdt.sdk.ui.attach.wizard.SdkAttachWizardDialog;
import com.nxp.s32ds.cle.cdt.sdk.ui.edit.SdkEditDialog;
import com.nxp.s32ds.cle.cdt.sdk.ui.exports.SdkExportDialog;
import com.nxp.s32ds.cle.cdt.sdk.ui.imports.ImportMcalSdkDialog;
import com.nxp.s32ds.cle.cdt.sdk.ui.imports.ImportSdkDialog;
import com.nxp.s32ds.cle.cdt.sdk.ui.load.wizard.ExternalSdkWizard;
import com.nxp.s32ds.cle.ide.sdk.ProjectSdkDescriptor;
import com.nxp.s32ds.cle.ide.sdk.core.ProjectSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.internal.registry.core.SdkDescriptorUtils;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkType;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkDescriptors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.widgets.CompositeFactory;
import org.eclipse.jface.widgets.WidgetFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

class PropertyPageButtonBar {
    private Map<PropertyPageButtons, AbstractPropertyPageButton> buttons;
    private AbstractSdksPropertyPage page;

    PropertyPageButtonBar(PropertyPageButtons[] buttonIds, Composite parent, AbstractSdksPropertyPage page) {
        this.page = page;
        this.create(buttonIds, parent);
    }

    private void create(PropertyPageButtons[] buttonIds, Composite parent) {
        Composite groupComponent = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(0, 0).applyTo(groupComponent);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        groupComponent.setLayoutData((Object)data);
        groupComponent.setFont(parent.getFont());
        this.buttons = new EnumMap<PropertyPageButtons, AbstractPropertyPageButton>(PropertyPageButtons.class);
        PropertyPageButtons[] propertyPageButtonsArray = buttonIds;
        int n = buttonIds.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyPageButtons buttonId = propertyPageButtonsArray[n2];
            this.buttons.put(buttonId, buttonId.createButton(this, groupComponent));
            ++n2;
        }
        this.updateEnabledState();
    }

    void updateEnabledState() {
        this.buttons.values().forEach(AbstractPropertyPageButton::updateEnabledState);
    }

    void notifyButtonListeners(PropertyPageButtons buttonId) {
        AbstractPropertyPageButton button = this.buttons.get((Object)buttonId);
        if (button != null) {
            button.button.notifyListeners(13, null);
        }
    }

    abstract class AbstractPropertyPageButton {
        protected Button button;

        protected AbstractPropertyPageButton(String text, Composite parent) {
            this.create(text, parent);
        }

        private void create(String text, final Composite parent) {
            this.button = new Button(parent, 8);
            this.button.setText(text);
            this.button.setFont(parent.getFont());
            PropertyPageButtonBar.this.page.setButtonLayoutData(this.button);
            this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractPropertyPageButton.this.perform();
                    parent.forceFocus();
                }
            });
        }

        protected abstract Object perform();

        protected Collection<SdkDescriptor> getSelectedApplicable() {
            return PropertyPageButtonBar.this.page.getAllSelected();
        }

        protected boolean isSelectedApplicable(SdkDescriptor selectedSdk) {
            return true;
        }

        protected void updateEnabledState() {
            this.button.setEnabled(true);
        }
    }

    class PropertyPageAttachButton
    extends AbstractPropertyPageButton {
        protected PropertyPageAttachButton(Composite parent) {
            super(Messages.SdkPreferencesPage_button_attach_text, parent);
        }

        @Override
        protected Object perform() {
            Map sdksAttachStates = SdkAttachStatusesHolder.INSTANCE.getActualSDKsAttachStatesCopy();
            IProject project = PropertyPageButtonBar.this.page.getProject();
            Display display = Display.getCurrent();
            LinkedHashMap<String, List> selectedSdksAttachStates = new LinkedHashMap<String, List>();
            for (SdkDescriptor sdk : this.getSelectedApplicable()) {
                String sdkId = sdk.getId();
                selectedSdksAttachStates.put(sdkId, (List)sdksAttachStates.get(sdkId));
            }
            SdkManagementUtils.updateSdksAttachStates(selectedSdksAttachStates, (IProject)project, (boolean)true);
            Collection<SdkDescriptor> selectedAttachableSdks = this.getSelectedApplicable();
            SdkAttachWizardDialog dialog = new SdkAttachWizardDialog(display.getActiveShell(), SdkAttachmentChangeHandler.createAttachWizard(project, sdksAttachStates, selectedAttachableSdks));
            dialog.create();
            if (dialog.open() == 0) {
                SdkManagementUtils.updateSdksAttachStates(selectedSdksAttachStates, (IProject)project, (boolean)true);
                Map<String, List<IStatus>> toAttach = selectedSdksAttachStates.entrySet().stream().filter(e -> !((List)e.getValue()).isEmpty() && ((List)e.getValue()).stream().anyMatch(IStatus::isOK)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                SdkAttachmentChangeHandler.collectChangedSdksAttachStates(toAttach, project);
            }
            PropertyPageButtonBar.this.page.updateWidgetState();
            return null;
        }

        @Override
        protected Collection<SdkDescriptor> getSelectedApplicable() {
            return super.getSelectedApplicable().stream().filter(this::isSelectedApplicable).collect(Collectors.toList());
        }

        @Override
        protected boolean isSelectedApplicable(SdkDescriptor selectedSdk) {
            return SdkAttachStatusesHolder.INSTANCE.isSdkAttachable(selectedSdk);
        }

        @Override
        protected void updateEnabledState() {
            this.button.setEnabled(!SdkAttachStatusesHolder.INSTANCE.getActualSDKsAttachStates().isEmpty() && !this.getSelectedApplicable().isEmpty());
        }
    }

    static enum PropertyPageButtons {
        ATTACH{

            @Override
            AbstractPropertyPageButton createButton(PropertyPageButtonBar buttonBar, Composite parent) {
                PropertyPageButtonBar propertyPageButtonBar = buttonBar;
                propertyPageButtonBar.getClass();
                return propertyPageButtonBar.new PropertyPageAttachButton(parent);
            }
        }
        ,
        CONVERT{

            @Override
            AbstractPropertyPageButton createButton(PropertyPageButtonBar buttonBar, Composite parent) {
                PropertyPageButtonBar propertyPageButtonBar = buttonBar;
                propertyPageButtonBar.getClass();
                return propertyPageButtonBar.new PropertyPageConvertSdkButton(parent);
            }
        }
        ,
        CREATE{

            @Override
            public AbstractPropertyPageButton createButton(PropertyPageButtonBar buttonBar, Composite parent) {
                PropertyPageButtonBar propertyPageButtonBar = buttonBar;
                propertyPageButtonBar.getClass();
                return propertyPageButtonBar.new PropertyPageCreateButton(parent);
            }
        }
        ,
        EDIT{

            @Override
            AbstractPropertyPageButton createButton(PropertyPageButtonBar buttonBar, Composite parent) {
                PropertyPageButtonBar propertyPageButtonBar = buttonBar;
                propertyPageButtonBar.getClass();
                return propertyPageButtonBar.new PropertyPageEditButton(parent);
            }
        }
        ,
        EXPORT{

            @Override
            AbstractPropertyPageButton createButton(PropertyPageButtonBar buttonBar, Composite parent) {
                PropertyPageButtonBar propertyPageButtonBar = buttonBar;
                propertyPageButtonBar.getClass();
                return propertyPageButtonBar.new PropertyPageExportButton(parent);
            }
        }
        ,
        IMPORT{

            @Override
            public AbstractPropertyPageButton createButton(PropertyPageButtonBar buttonBar, Composite parent) {
                PropertyPageButtonBar propertyPageButtonBar = buttonBar;
                propertyPageButtonBar.getClass();
                return propertyPageButtonBar.new PropertyPageImportButton(parent);
            }
        }
        ,
        IMPORT_MCAL{

            @Override
            AbstractPropertyPageButton createButton(PropertyPageButtonBar buttonBar, Composite parent) {
                PropertyPageButtonBar propertyPageButtonBar = buttonBar;
                propertyPageButtonBar.getClass();
                return propertyPageButtonBar.new PropertyPageImportMcalSdkButton(parent);
            }
        }
        ,
        LOAD{

            @Override
            AbstractPropertyPageButton createButton(PropertyPageButtonBar buttonBar, Composite parent) {
                PropertyPageButtonBar propertyPageButtonBar = buttonBar;
                propertyPageButtonBar.getClass();
                return propertyPageButtonBar.new PropertyPageLoadButton(parent);
            }
        }
        ,
        RELOAD{

            @Override
            AbstractPropertyPageButton createButton(PropertyPageButtonBar buttonBar, Composite parent) {
                PropertyPageButtonBar propertyPageButtonBar = buttonBar;
                propertyPageButtonBar.getClass();
                return propertyPageButtonBar.new PropertyPageReloadButton(parent);
            }
        }
        ,
        REMOVE{

            @Override
            AbstractPropertyPageButton createButton(PropertyPageButtonBar buttonBar, Composite parent) {
                PropertyPageButtonBar propertyPageButtonBar = buttonBar;
                propertyPageButtonBar.getClass();
                return propertyPageButtonBar.new PropertyPageRemoveButton(parent);
            }
        }
        ,
        SHOW_ATTACHED{

            @Override
            AbstractPropertyPageButton createButton(PropertyPageButtonBar buttonBar, Composite parent) {
                PropertyPageButtonBar propertyPageButtonBar = buttonBar;
                propertyPageButtonBar.getClass();
                return propertyPageButtonBar.new PropertyPageShowAttachedButton(parent);
            }
        };


        abstract AbstractPropertyPageButton createButton(PropertyPageButtonBar var1, Composite var2);
    }

    class PropertyPageConvertSdkButton
    extends AbstractPropertyPageButton {
        protected PropertyPageConvertSdkButton(Composite parent) {
            super(Messages.SdkPreferencesPage_button_make_global_text, parent);
        }

        @Override
        public Object perform() {
            SdkDescriptor sdk = this.getSelectedApplicable().iterator().next();
            if (sdk == null) {
                return null;
            }
            SdkManagementUtils.convertProjectLocalSdkToWorkspaceSdk((SdkDescriptor)sdk);
            WorkspaceSdkLoader.updatePersistedWorkspaceSdks();
            ProjectLocalSdkLoader.updatePersistedProjectLocalSdks((IProject)PropertyPageButtonBar.this.page.getProject());
            PropertyPageButtonBar.this.page.updateWidgetState();
            return sdk;
        }

        @Override
        public boolean isSelectedApplicable(SdkDescriptor selectedSdk) {
            IProject project = PropertyPageButtonBar.this.page.getProject();
            if (project == null || SdkType.PROJECT_LOCAL != selectedSdk.getType() || !SdkAvailabilityChecker.checkAvailability((String)selectedSdk.getId()).isOK()) {
                return false;
            }
            ProjectSdkDescriptor projectSdk = ProjectSdkDescriptors.getProjectSdkDescriptorBySdkId((String)selectedSdk.getId());
            return projectSdk != null && project.getName().equals(projectSdk.getProjectName());
        }

        @Override
        public void updateEnabledState() {
            Collection<SdkDescriptor> selectedSdks = this.getSelectedApplicable();
            this.button.setEnabled(selectedSdks.size() == 1 && this.isSelectedApplicable(selectedSdks.iterator().next()));
        }
    }

    class PropertyPageCreateButton
    extends AbstractPropertyPageButton {
        protected PropertyPageCreateButton(Composite parent) {
            super(Messages.SdkPreferencesPage_button_create_text, parent);
        }

        @Override
        protected Object perform() {
            Shell shell = Display.getCurrent().getActiveShell();
            SdkDescriptor sdk = null;
            if (PropertyPageButtonBar.this.page instanceof ProjectSdksPropertyPage) {
                IProject project = PropertyPageButtonBar.this.page.getProject();
                SdkEditDialog dialog = SdkEditDialog.newCreateSdkDialog(shell, PropertyPageButtonBar.this.page.getSdkType(), project, PropertyPageButtonBar.this.page.getFilterOptions());
                if (dialog.open() == 1) {
                    PropertyPageButtonBar.this.page.updateWidgetState();
                    return null;
                }
                sdk = dialog.getSdkDescriptor();
                WorkspaceSdkLoader.updatePersistedWorkspaceSdks();
                ProjectLocalSdkLoader.updatePersistedProjectLocalSdks((IProject)project);
                SdkAttachProcessor.reAttachSdkToProject((SdkDescriptor)sdk, (IProject)project);
                SdkAttachStatusesHolder.INSTANCE.addSdkAttachStates(sdk, project);
            } else {
                SelectCreateSdkKindDialog selectorDialog = new SelectCreateSdkKindDialog(shell);
                selectorDialog.open();
                sdk = selectorDialog.getCreatedSdk();
            }
            PropertyPageButtonBar.this.page.updateWidgetState();
            return sdk;
        }
    }

    class PropertyPageEditButton
    extends AbstractPropertyPageButton {
        protected PropertyPageEditButton(Composite parent) {
            super(Messages.SdkPreferencesPage_button_edit_view_text, parent);
        }

        @Override
        protected Object perform() {
            SdkDescriptor sdk = this.getSelectedApplicable().iterator().next();
            if (sdk == null) {
                return null;
            }
            Shell shell = Display.getCurrent().getActiveShell();
            boolean isReadonlyMode = !this.isEditable(sdk);
            IProject project = PropertyPageButtonBar.this.page.getProject();
            SdkEditDialog dialog = isReadonlyMode ? SdkEditDialog.newViewSdkDialog(shell, sdk, project) : SdkEditDialog.newEditSdkDialog(shell, sdk, project, PropertyPageButtonBar.this.page.getFilterOptions());
            int dialogStatus = dialog.open();
            if (isReadonlyMode || dialogStatus == 1) {
                PropertyPageButtonBar.this.page.updateWidgetState();
                return null;
            }
            if (!isReadonlyMode && dialogStatus == 0) {
                sdk = dialog.getSdkDescriptor();
                WorkspaceSdkLoader.updatePersistedWorkspaceSdks();
                if (sdk != null && PropertyPageButtonBar.this.page instanceof ProjectSdksPropertyPage) {
                    ProjectLocalSdkLoader.updatePersistedProjectLocalSdks((IProject)project);
                    SdkManagementUtils.refreshSdksAttachStates((IProject)project);
                }
                PropertyPageButtonBar.this.page.updateWidgetState();
            }
            return sdk;
        }

        @Override
        protected void updateEnabledState() {
            Collection<SdkDescriptor> selected = this.getSelectedApplicable();
            if (selected.size() == 1) {
                SdkDescriptor sdk = selected.iterator().next();
                this.button.setEnabled(sdk != null && sdk.getBasePath() != null && !SdkAttachStatuses.ERROR_SDK_MISSED.equals(SdkAvailabilityChecker.checkAvailability((String)sdk.getId())));
            } else {
                this.button.setEnabled(false);
            }
        }

        private boolean isEditable(SdkDescriptor selectedSdk) {
            boolean isEditableType;
            if (selectedSdk == null) {
                return false;
            }
            SdkType sdkType = selectedSdk.getType();
            if (SdkType.PROJECT_LOCAL == sdkType) {
                IProject project = PropertyPageButtonBar.this.page.getProject();
                if (project == null) {
                    return false;
                }
                ProjectSdkDescriptor projectSdk = ProjectSdkDescriptors.getProjectSdkDescriptorBySdkId((String)selectedSdk.getId());
                isEditableType = projectSdk != null && project.getName().equals(projectSdk.getProjectName());
            } else {
                boolean bl = isEditableType = SdkType.EXTERNAL != sdkType && SdkType.IMPORTED != sdkType && SdkType.INTERNAL != sdkType && SdkType.UNKNOWN != sdkType;
            }
            return isEditableType && !SdkAttachDataHolder.isSdkAttached((SdkDescriptor)selectedSdk);
        }
    }

    class PropertyPageExportButton
    extends AbstractPropertyPageButton {
        protected PropertyPageExportButton(Composite parent) {
            super(Messages.SdkPreferencesPage_button_export_text, parent);
        }

        @Override
        protected Object perform() {
            SdkDescriptor selectedSdkDescriptor = this.getSelectedApplicable().iterator().next();
            Shell shell = Display.getCurrent().getActiveShell();
            SdkExportDialog dialog = new SdkExportDialog(shell, selectedSdkDescriptor);
            if (dialog.open() == 0) {
                String location = dialog.location();
                boolean isExportDescriptorOnly = !dialog.withContent();
                IStatus exportStatus = new SdkExporter().exportSDK(location, selectedSdkDescriptor, isExportDescriptorOnly);
                Display display = Display.getDefault();
                String messageTitle = Messages.SdkExportDialog_title;
                String messageText = exportStatus.getMessage();
                if (exportStatus.isOK()) {
                    display.syncExec(() -> MessageDialog.openInformation((Shell)shell, (String)messageTitle, (String)messageText));
                } else {
                    display.syncExec(() -> MessageDialog.openError((Shell)shell, (String)messageTitle, (String)messageText));
                }
            }
            PropertyPageButtonBar.this.page.updateWidgetState();
            return selectedSdkDescriptor;
        }

        @Override
        protected boolean isSelectedApplicable(SdkDescriptor selectedSdk) {
            if (selectedSdk == null || !SdkAvailabilityChecker.checkAvailability((String)selectedSdk.getId()).isOK()) {
                return false;
            }
            SdkType sdkType = selectedSdk.getType();
            if (SdkType.WORKSPACE == sdkType) {
                return true;
            }
            if (SdkType.PROJECT_LOCAL == sdkType && PropertyPageButtonBar.this.page instanceof ProjectSdksPropertyPage) {
                IProject project = PropertyPageButtonBar.this.page.getProject();
                if (project == null) {
                    return false;
                }
                ProjectSdkDescriptor projectSdk = ProjectSdkDescriptors.getProjectSdkDescriptorBySdkId((String)selectedSdk.getId());
                return projectSdk != null && project.getName().equals(projectSdk.getProjectName());
            }
            return false;
        }

        @Override
        protected void updateEnabledState() {
            Collection<SdkDescriptor> selected = this.getSelectedApplicable();
            this.button.setEnabled(selected.size() == 1 && this.isSelectedApplicable(selected.iterator().next()));
        }
    }

    class PropertyPageImportButton
    extends AbstractPropertyPageButton {
        protected PropertyPageImportButton(Composite parent) {
            super(Messages.SdkPreferencesPage_button_import_text, parent);
        }

        @Override
        protected Object perform() {
            Shell shell = Display.getCurrent().getActiveShell();
            ImportSdkDialog dialog = new ImportSdkDialog(shell);
            if (dialog.open() != 0) {
                return Collections.emptyList();
            }
            Collection importedSdks = null;
            SdksImporter sdkImporter = new SdksImporter();
            sdkImporter.setSdkImportHandler((ImportSdkHandler)new ImportSdkUiCallbackHandler(shell));
            if (dialog.isImportFromArchive()) {
                importedSdks = sdkImporter.importSdks(dialog.getArchiveExtractionDestinationFolder(), dialog.getArchiveSourceLocation());
            } else if (dialog.isImportFromFolder()) {
                importedSdks = sdkImporter.importSdkFromDirectory(dialog.getSourceFolderLocation());
            }
            if (importedSdks != null && PropertyPageButtonBar.this.page instanceof ProjectSdksPropertyPage) {
                importedSdks.forEach(sdk -> SdkAttachStatusesHolder.INSTANCE.addSdkAttachStates(sdk, PropertyPageButtonBar.this.page.getProject()));
            }
            PropertyPageButtonBar.this.page.updateWidgetState();
            return importedSdks;
        }
    }

    class PropertyPageImportMcalSdkButton
    extends AbstractPropertyPageButton {
        protected PropertyPageImportMcalSdkButton(Composite parent) {
            super(Messages.SdkPreferencesPage_button_create_mcal_sdk_text, parent);
        }

        @Override
        protected Object perform() {
            Shell shell = Display.getCurrent().getActiveShell();
            ImportMcalSdkDialog dialog = new ImportMcalSdkDialog(shell, this.getAvailableOriginMcalSdks());
            if (dialog.open() == 0) {
                IStatus importStatus = McalSdkImporter.performImportMcalSdkByConfiguration((SdkDescriptor)dialog.getMcalSdk(), (String)dialog.getMcalConfigurationPath(), (String)dialog.getSdkName(), (String)dialog.getSdkVersion());
                if (importStatus.isOK()) {
                    ExternalSdkLoader.updatePersistedExternalSdks();
                    InternalSdkLoader.updatePersistedInternalSdks();
                    PropertyPageButtonBar.this.page.updateWidgetState();
                } else {
                    shell.getDisplay().syncExec(() -> MessageDialog.openError((Shell)shell, (String)Messages.SdkPreferencesPage_create_mcal_sdk_message_title, (String)Messages.SdkPreferencesPage_create_mcal_sdk_error_message));
                }
            }
            return null;
        }

        @Override
        protected void updateEnabledState() {
            this.button.setEnabled(!this.getAvailableOriginMcalSdks().isEmpty());
        }

        private List<SdkDescriptor> getAvailableOriginMcalSdks() {
            return SdkManagementUtils.getFilteredSdks(sdk -> sdk.getTags().contains("mcal") && McalSdkImporter.checkMcalDescriptorBasePath((String)sdk.getBasePath()).isOK());
        }
    }

    class PropertyPageLoadButton
    extends AbstractPropertyPageButton {
        protected PropertyPageLoadButton(Composite parent) {
            super(Messages.SdkPreferencesPage_button_load_text, parent);
        }

        @Override
        protected Object perform() {
            Shell shell = Display.getCurrent().getActiveShell();
            ArrayList<SdkDescriptor> importedSdks = new ArrayList<SdkDescriptor>();
            WizardDialog dialog = new WizardDialog(shell, (IWizard)new ExternalSdkWizard(importedSdks));
            dialog.create();
            if (dialog.open() != 0) {
                return Collections.emptyList();
            }
            for (SdkDescriptor importedSdk : importedSdks) {
                List projects = SdkAttachDataHolder.getProjectsSdkAttachedTo((SdkDescriptor)importedSdk);
                for (IProject project : projects) {
                    SdkAttachStatusesHolder.INSTANCE.addSdkAttachStates(importedSdk, project);
                }
            }
            PropertyPageButtonBar.this.page.updateWidgetState();
            return importedSdks;
        }
    }

    class PropertyPageReloadButton
    extends AbstractPropertyPageButton {
        protected PropertyPageReloadButton(Composite parent) {
            super(Messages.SdkPreferencesPage_button_reload_text, parent);
        }

        protected IStatus perform() {
            Collection<SdkDescriptor> selectedSdks = this.getSelectedApplicable();
            if (selectedSdks.isEmpty() || !this.isReloadSelectedSdksConfirmed(selectedSdks)) {
                return Status.CANCEL_STATUS;
            }
            Map sdksDescriptorsPaths = ExternalSdkLoader.getSdksDescriptors();
            SdkAttachConflictingFilesUiHandler handler = new SdkAttachConflictingFilesUiHandler();
            for (SdkDescriptor sdk : selectedSdks) {
                String descriptorFilePath = (String)sdksDescriptorsPaths.get(sdk.getId());
                if (descriptorFilePath == null) continue;
                ExternalSdkLoader.reloadSdkFromDescriptorFile((SdkDescriptor)sdk, (String)descriptorFilePath, (boolean)true, (SdkAttachConflictingProjectFilesCheckHandler)handler);
            }
            InternalSdkLoader.updatePersistedInternalSdks();
            if (PropertyPageButtonBar.this.page instanceof WizardSdksPropertyPage) {
                ((WizardSdksPropertyPage)PropertyPageButtonBar.this.page).uncheckSelected(selectedSdks);
            }
            return Status.OK_STATUS;
        }

        @Override
        protected Collection<SdkDescriptor> getSelectedApplicable() {
            return super.getSelectedApplicable().stream().filter(this::isSelectedApplicable).collect(Collectors.toList());
        }

        @Override
        protected boolean isSelectedApplicable(SdkDescriptor sdkDescriptor) {
            Map sdksDescriptors = ExternalSdkLoader.getSdksDescriptors();
            return SdkType.EXTERNAL == sdkDescriptor.getType() && sdksDescriptors.containsKey(sdkDescriptor.getId());
        }

        @Override
        protected void updateEnabledState() {
            this.button.setEnabled(!this.getSelectedApplicable().isEmpty());
        }

        private boolean isReloadSelectedSdksConfirmed(Collection<SdkDescriptor> selectedSdks) {
            Shell shell = Display.getCurrent().getActiveShell();
            if (selectedSdks.size() == 1) {
                SdkDescriptor selectedSdk = selectedSdks.iterator().next();
                return MessageDialog.openConfirm((Shell)shell, (String)Messages.SdkPreferencesPage_reload_sdk_confirmation_title, (String)NLS.bind((String)Messages.SdkPreferencesPage_reload_sdk_confirmation_text, (Object)selectedSdk.getName(), (Object)selectedSdk.getVersion()));
            }
            return MessageDialog.openConfirm((Shell)shell, (String)Messages.SdkPreferencesPage_reload_sdk_confirmation_title, (String)Messages.SdkPreferencesPage_reload_sdks_confirmation_text);
        }
    }

    class PropertyPageRemoveButton
    extends AbstractPropertyPageButton {
        protected PropertyPageRemoveButton(Composite parent) {
            super(Messages.SdkPreferencesPage_button_remove_text, parent);
        }

        @Override
        protected Object perform() {
            Collection<SdkDescriptor> selectedSdks = this.getSelectedApplicable();
            if (!selectedSdks.isEmpty() && this.isRemoveSelectedSdksConfirmed(selectedSdks)) {
                selectedSdks.forEach(SdkManagementUtils::removeSdk);
                ImportedSdkLoader.updatePersistedImportedSdks();
                WorkspaceSdkLoader.updatePersistedWorkspaceSdks();
                ExternalSdkLoader.updatePersistedExternalSdks();
                InternalSdkLoader.updatePersistedInternalSdks();
                if (PropertyPageButtonBar.this.page instanceof ProjectSdksPropertyPage) {
                    IProject project = PropertyPageButtonBar.this.page.getProject();
                    ProjectLocalSdkLoader.updatePersistedProjectLocalSdks((IProject)project);
                    SdkAttachStatusesHolder.INSTANCE.removeSDKAttachStates(selectedSdks, project);
                }
                PropertyPageButtonBar.this.page.updateWidgetState();
            }
            return selectedSdks;
        }

        @Override
        protected boolean isSelectedApplicable(SdkDescriptor selectedSdk) {
            if (selectedSdk == null || selectedSdk.getBasePath() == null || SdkAttachStatuses.ERROR_SDK_MISSED.equals(SdkAvailabilityChecker.checkAvailability((String)selectedSdk.getId()))) {
                return false;
            }
            SdkType sdkType = selectedSdk.getType();
            if (SdkType.PROJECT_LOCAL == sdkType) {
                IProject project = PropertyPageButtonBar.this.page.getProject();
                ProjectSdkDescriptor projectSdk = ProjectSdkDescriptors.getProjectSdkDescriptorBySdkId((String)selectedSdk.getId());
                return project != null && projectSdk != null && project.getName().equals(projectSdk.getProjectName());
            }
            return SdkType.WORKSPACE == sdkType || SdkType.IMPORTED == sdkType || SdkType.EXTERNAL == sdkType && selectedSdk.isLoadedByUser();
        }

        @Override
        protected void updateEnabledState() {
            this.button.setEnabled(!this.getSelectedApplicable().isEmpty());
        }

        @Override
        protected Collection<SdkDescriptor> getSelectedApplicable() {
            return super.getSelectedApplicable().stream().filter(this::isSelectedApplicable).collect(Collectors.toList());
        }

        private boolean isRemoveSelectedSdksConfirmed(Collection<SdkDescriptor> selectedSdks) {
            Shell shell = Display.getCurrent().getActiveShell();
            if (selectedSdks.size() == 1) {
                SdkDescriptor selectedSdk = selectedSdks.iterator().next();
                return MessageDialog.openConfirm((Shell)shell, (String)Messages.SdkPreferencesPage_remove_sdk_confirmation_title, (String)NLS.bind((String)Messages.SdkPreferencesPage_remove_sdk_confirmation_text, (Object)selectedSdk.getName(), (Object)selectedSdk.getVersion()));
            }
            return MessageDialog.openConfirm((Shell)shell, (String)Messages.SdkPreferencesPage_remove_sdk_confirmation_title, (String)Messages.SdkPreferencesPage_remove_sdks_confirmation_text);
        }
    }

    class PropertyPageShowAttachedButton
    extends AbstractPropertyPageButton {
        protected PropertyPageShowAttachedButton(Composite parent) {
            super(Messages.SdkPreferencesPage_button_show_attached, parent);
        }

        @Override
        protected Object perform() {
            Collection<SdkDescriptor> selectedSdks = this.getSelectedApplicable();
            SdkDescriptor selectedSdk = !selectedSdks.isEmpty() ? selectedSdks.iterator().next() : null;
            new ShowAttachedSdksDialog(Display.getCurrent().getActiveShell(), selectedSdk).open();
            return null;
        }
    }

    private static class SelectCreateSdkKindDialog
    extends TitleAreaDialog {
        private TargetSdkKind targetSdkKind = TargetSdkKind.WORKSPACE_SDK;
        private SdkDescriptor createdSdk;

        public SelectCreateSdkKindDialog(Shell parentShell) {
            super(parentShell);
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(Messages.PropertyPageButtonBar_create_sdk_selector_dialog_shell_text);
        }

        protected Control createDialogArea(Composite parent) {
            Composite parentComposite = (Composite)super.createDialogArea(parent);
            this.initializeDialogUnits((Control)parent);
            this.setTitle(Messages.PropertyPageButtonBar_create_sdk_selector_dialog_title);
            this.setMessage(Messages.PropertyPageButtonBar_create_sdk_selector_dialog_message);
            Composite composite = (Composite)((CompositeFactory)((CompositeFactory)WidgetFactory.composite((int)0).layout((Layout)GridLayoutFactory.swtDefaults().create())).layoutData((Object)GridDataFactory.swtDefaults().align(4, 4).grab(true, true).create())).create((Widget)parentComposite);
            ((Button)WidgetFactory.button((int)16).text(Messages.PropertyPageButtonBar_create_sdk_selector_dialog_radio_general_sdk_text).onSelect(e -> {
                TargetSdkKind targetSdkKind = this.targetSdkKind = TargetSdkKind.WORKSPACE_SDK;
            }).create((Widget)composite)).setSelection(true);
            if (System.getProperty("os.name").startsWith("Windows")) {
                WidgetFactory.button((int)16).text(Messages.PropertyPageButtonBar_create_sdk_selector_dialog_radio_mcal_sdk_text).onSelect(e -> {
                    TargetSdkKind targetSdkKind = this.targetSdkKind = TargetSdkKind.MCAL_SDK;
                }).create((Widget)composite);
            }
            this.setHelpAvailable(true);
            String sdkCreateId = ".SDK_CREATE_GENERAL_context";
            if (System.getProperty("os.name").startsWith("Windows")) {
                sdkCreateId = ".SDK_CREATE_context";
            }
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parentComposite, "com.freescale.s32ds.cross.sdk.support" + sdkCreateId);
            return composite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.PROCEED_LABEL, true);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }

        protected void okPressed() {
            super.okPressed();
            if (TargetSdkKind.WORKSPACE_SDK == this.targetSdkKind) {
                this.proceedWithCreateDefaultSdk();
            } else if (TargetSdkKind.MCAL_SDK == this.targetSdkKind) {
                this.proceedWithCreateMcalSdk();
            }
        }

        private void proceedWithCreateDefaultSdk() {
            Shell shell = this.getShell();
            SdkEditDialog dialog = SdkEditDialog.newCreateSdkDialog(shell, SdkType.WORKSPACE, null, null);
            if (dialog.open() == 0) {
                this.createdSdk = dialog.getSdkDescriptor();
                WorkspaceSdkLoader.updatePersistedWorkspaceSdks();
            }
        }

        private void proceedWithCreateMcalSdk() {
            Shell shell = this.getShell();
            ImportMcalSdkDialog dialog = new ImportMcalSdkDialog(shell, SelectCreateSdkKindDialog.getAvailableOriginMcalSdks());
            if (dialog.open() == 0) {
                String sdkName = dialog.getSdkName();
                String sdkVersion = dialog.getSdkVersion();
                IStatus importStatus = McalSdkImporter.performImportMcalSdkByConfiguration((SdkDescriptor)dialog.getMcalSdk(), (String)dialog.getMcalConfigurationPath(), (String)sdkName, (String)sdkVersion);
                if (importStatus.isOK()) {
                    this.createdSdk = SdkDescriptors.getSdkDescriptor((String)SdkDescriptorUtils.makeId((String)sdkName, (String)sdkVersion));
                    ExternalSdkLoader.updatePersistedExternalSdks();
                    InternalSdkLoader.updatePersistedInternalSdks();
                } else {
                    shell.getDisplay().syncExec(() -> MessageDialog.openError((Shell)shell, (String)Messages.SdkPreferencesPage_create_mcal_sdk_message_title, (String)Messages.SdkPreferencesPage_create_mcal_sdk_error_message));
                }
            }
        }

        private SdkDescriptor getCreatedSdk() {
            return this.createdSdk;
        }

        private static List<SdkDescriptor> getAvailableOriginMcalSdks() {
            return SdkManagementUtils.getFilteredSdks(sdk -> sdk.getTags().contains("mcal") && McalSdkImporter.checkMcalDescriptorBasePath((String)sdk.getBasePath()).isOK());
        }

        private static enum TargetSdkKind {
            WORKSPACE_SDK,
            MCAL_SDK;

        }
    }
}

