/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.ui.property;

import com.nxp.s32ds.cle.cdt.sdk.core.filtering.AbstractSdkSmartFilter;
import com.nxp.s32ds.cle.cdt.sdk.core.filtering.FilterOptionsImplementation;
import com.nxp.s32ds.cle.cdt.sdk.core.filtering.LatestSdkVersionFilter;
import com.nxp.s32ds.cle.cdt.sdk.filtering.FilterOptions;
import com.nxp.s32ds.cle.cdt.sdk.filtering.SdkFilter;
import com.nxp.s32ds.cle.cdt.sdk.filtering.SdkFilteringParameters;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.SdkTableViewerHolder;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.property.AbstractSdksPropertyPage;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.property.PropertyPageButtonBar;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.property.PropertyPageFilterBar;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.property.WizardSelectSdksDialog;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class WizardSdksPropertyPage
extends AbstractSdksPropertyPage {
    private static final String HELP_CONTEXT_WIZARD_ID = "com.freescale.s32ds.cross.sdk.support.SDK_MGMT_WIZARD_context";
    private Set<SdkDescriptor> checkedSdkList = new LinkedHashSet<SdkDescriptor>();
    private WizardSelectSdksDialog holderDialog;
    private SdkFilteringParameters sdkFilteringParams;

    public WizardSdksPropertyPage(SdkFilteringParameters sdkFilteringParams, WizardSelectSdksDialog holderDialog) {
        this.buttonIds = new PropertyPageButtonBar.PropertyPageButtons[]{PropertyPageButtonBar.PropertyPageButtons.EDIT, PropertyPageButtonBar.PropertyPageButtons.RELOAD};
        this.sdkFilteringParams = sdkFilteringParams;
        this.holderDialog = holderDialog;
        this.filterIds = new PropertyPageFilterBar.PropertyPageFilters[]{PropertyPageFilterBar.PropertyPageFilters.LATEST_VERSION};
    }

    public void setSelected(Object[] selection) {
        if (selection == null || selection.length == 0) {
            return;
        }
        Stream.of(selection).filter(SdkDescriptor.class::isInstance).forEach(sdk -> {
            boolean bl = this.checkedSdkList.add((SdkDescriptor)sdk);
        });
        this.updateCheckedItems();
    }

    public List<SdkDescriptor> getSelectedToAttach() {
        return new ArrayList<SdkDescriptor>(this.checkedSdkList);
    }

    public void cancelSelectedToAttach() {
        this.checkedSdkList.clear();
    }

    public void setFilterInfo(SdkFilteringParameters info) {
        this.sdkFilteringParams = info;
    }

    public void setHolderDialog(WizardSelectSdksDialog holderDialog) {
        this.holderDialog = holderDialog;
    }

    @Override
    protected SdkTableViewerHolder createTableViewerHolder(Composite parent) {
        SdkTableViewerHolder holder = SdkTableViewerHolder.newCheckList(parent);
        holder.getCheckboxTableViewer().addCheckStateListener(event -> {
            Object element = event.getElement();
            if (!(element instanceof SdkDescriptor)) {
                return;
            }
            if (event.getChecked()) {
                this.checkedSdkList.add((SdkDescriptor)element);
            } else if (this.checkedSdkList.contains(element)) {
                this.checkedSdkList.remove(element);
            }
        });
        return holder;
    }

    protected List<SdkDescriptor> getSDKs() {
        AbstractSdkSmartFilter abstractSmartFiler = new AbstractSdkSmartFilter(){

            public boolean accept(SdkDescriptor sdk) {
                return SdkType.PROJECT_LOCAL != sdk.getType();
            }

            public FilterOptions options() {
                return FilterOptionsImplementation.createFilter((SdkFilteringParameters)WizardSdksPropertyPage.this.sdkFilteringParams);
            }
        };
        if (this.filterBar != null && this.filterBar.isFilterEnabled(PropertyPageFilterBar.PropertyPageFilters.LATEST_VERSION)) {
            return this.getFilteredSdks((SdkFilter)new LatestSdkVersionFilter((SdkFilter)abstractSmartFiler));
        }
        return this.getFilteredSdks((SdkFilter)abstractSmartFiler);
    }

    @Override
    public void updateWidgetState() {
        super.updateWidgetState();
        this.updateCheckedItems();
    }

    @Override
    protected Composite createContents(Composite parent) {
        Composite page = super.createContents(parent);
        this.setHelpContextId(page);
        return page;
    }

    @Override
    protected void setHelpContextId(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HELP_CONTEXT_WIZARD_ID);
    }

    @Override
    protected void updateControlsEnabedState() {
        Button b;
        super.updateControlsEnabedState();
        if (this.holderDialog != null && (b = this.holderDialog.getOK()) != null) {
            b.setEnabled(this.checksAreOk());
        }
    }

    protected List<SdkDescriptor> getFilteredSdks(SdkFilter filter) {
        return super.getFilteredSdks(filter).stream().filter(sdk -> !sdk.getTags().contains("mcal")).collect(Collectors.toList());
    }

    void uncheckSelected(Collection<SdkDescriptor> selectedSdks) {
        selectedSdks.forEach(selectedSdk -> {
            boolean bl = this.checkedSdkList.removeIf(sdk -> sdk.getId().equals(selectedSdk.getId()));
        });
        this.updateWidgetState();
    }

    private boolean checksAreOk() {
        this.holderDialog.setMessage("");
        return true;
    }

    private void updateCheckedItems() {
        Stream.of(this.viewer.getTable().getItems()).forEach(i -> i.setChecked(i.getData() instanceof SdkDescriptor && this.checkedSdkList.contains(i.getData())));
    }
}

