/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.ui.attach.wizard;

import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkManagementUtils;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.Messages;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.widgets.ButtonFactory;
import org.eclipse.jface.widgets.CompositeFactory;
import org.eclipse.jface.widgets.LabelFactory;
import org.eclipse.jface.widgets.TextFactory;
import org.eclipse.jface.widgets.WidgetFactory;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SdkAttachWizardDetachPage
extends WizardPage {
    static final String PAGE_ID = "com.nxp.s32ds.cle.cdt.sdk.ui.attach.wizard.detach.page";
    private static final String DEFAULT_BACKUP_FILE_EXTENSION = ".zip";
    private boolean isCreateProjectBackup;
    private String backupFilePath;
    private Label sdksToDetachInfoLabel;
    private Text backupFilePathText;
    private Composite backupFileComposite;
    private IProject project;

    public SdkAttachWizardDetachPage(IProject project) {
        super(PAGE_ID);
        this.project = project;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite container = new Composite(parent, 0);
        this.setTitle(Messages.DetachSdkActionsSelectionDialog_title);
        this.setMessage(Messages.DetachSdkActionsSelectionDialog_message);
        GridLayoutFactory.swtDefaults().applyTo(container);
        GridDataFactory.swtDefaults().grab(true, false).align(4, 4).applyTo((Control)container);
        this.createInfoComposite(container);
        this.createBackupProjectFileComposite(container);
        this.getContainer().updateButtons();
        this.setControl((Control)container);
    }

    public String getDescription() {
        return Messages.DetachSdkActionsSelectionDialog_message;
    }

    public String getTitle() {
        return Messages.DetachSdkActionsSelectionDialog_title;
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public IWizardPage getPreviousPage() {
        return this.getWizard().getPage("com.nxp.s32ds.cle.cdt.sdk.ui.attach.wizard.config.page");
    }

    public boolean isPageComplete() {
        return !this.isCreateProjectBackup() || this.isCreateProjectBackup() && this.getBackupFilePath() != null;
    }

    public boolean isCurrentPage() {
        return super.isCurrentPage();
    }

    public boolean isCreateProjectBackup() {
        return this.isCreateProjectBackup;
    }

    public String getBackupFilePath() {
        return this.backupFilePath;
    }

    void updateSdksToDetachList(Collection<SdkDescriptor> sdksToDetach) {
        this.sdksToDetachInfoLabel.setText(String.join((CharSequence)"\n", sdksToDetach.stream().map(sdk -> " - " + SdkManagementUtils.getSdkBriefInfo((SdkDescriptor)sdk, (boolean)false)).collect(Collectors.toList())));
        this.sdksToDetachInfoLabel.requestLayout();
    }

    private void createInfoComposite(Composite container) {
        Composite sdksInfoComposite = (Composite)((CompositeFactory)((CompositeFactory)WidgetFactory.composite((int)0).layout((Layout)GridLayoutFactory.swtDefaults().create())).layoutData((Object)GridDataFactory.swtDefaults().grab(true, false).align(4, 4).create())).create((Widget)container);
        ((LabelFactory)WidgetFactory.label((int)0).text(Messages.DetachSdkActionsSelectionDialog_label_info_header).layoutData((Object)GridDataFactory.swtDefaults().align(1, 0x1000000).create())).create((Widget)sdksInfoComposite);
        this.sdksToDetachInfoLabel = (Label)((LabelFactory)WidgetFactory.label((int)64).layoutData((Object)GridDataFactory.swtDefaults().align(4, 4).create())).create((Widget)sdksInfoComposite);
        ((LabelFactory)WidgetFactory.label((int)0).text(Messages.DetachSdkActionsSelectionDialog_label_info_footer).layoutData((Object)GridDataFactory.swtDefaults().align(1, 0x1000000).create())).create((Widget)sdksInfoComposite);
    }

    private void createBackupProjectFileComposite(Composite container) {
        this.backupFileComposite = (Composite)((CompositeFactory)((CompositeFactory)WidgetFactory.composite((int)0).layout((Layout)GridLayoutFactory.swtDefaults().numColumns(3).equalWidth(false).create())).layoutData((Object)GridDataFactory.swtDefaults().grab(true, false).align(4, 4).create())).create((Widget)container);
        ((ButtonFactory)WidgetFactory.button((int)32).text(Messages.DetachSdkActionsSelectionDialog_checkbox_backup_project_text).layoutData((Object)GridDataFactory.swtDefaults().span(3, 1).grab(true, false).align(4, 4).create())).onSelect(this::onSelectBackupButton).create((Widget)this.backupFileComposite);
        ((LabelFactory)((LabelFactory)WidgetFactory.label((int)0).text(Messages.DetachSdkActionsSelectionDialog_label_backup_project_file).layoutData((Object)GridDataFactory.swtDefaults().align(1, 0x1000000).create())).enabled(false)).create((Widget)this.backupFileComposite);
        this.backupFilePathText = (Text)((TextFactory)((TextFactory)WidgetFactory.text((int)2056).layoutData((Object)GridDataFactory.swtDefaults().grab(true, false).align(4, 0x1000000).create())).enabled(false)).create((Widget)this.backupFileComposite);
        Button browseButton = (Button)((ButtonFactory)((ButtonFactory)WidgetFactory.button((int)8).text(Messages.DetachSdkActionsSelectionDialog_button_browse_backup_project_file_text).layoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).create())).enabled(false)).onSelect(event -> this.onSelectBrowseButtton()).create((Widget)this.backupFileComposite);
        this.setButtonLayoutData(browseButton);
    }

    private void onSelectBackupButton(SelectionEvent event) {
        Button button = (Button)event.getSource();
        boolean isSelected = button.getSelection();
        Arrays.stream(this.backupFileComposite.getChildren()).filter(control -> !control.isDisposed() && !control.equals(button)).forEach(control -> control.setEnabled(isSelected));
        if (!isSelected) {
            this.isCreateProjectBackup = false;
            this.backupFilePath = null;
        } else {
            this.isCreateProjectBackup = true;
            String selectedBackupFilePath = this.backupFilePathText.getText();
            this.backupFilePath = !selectedBackupFilePath.isEmpty() ? selectedBackupFilePath : null;
        }
        this.getContainer().updateButtons();
    }

    private void onSelectBrowseButtton() {
        FileDialog saveFileDialog = new FileDialog(Display.getDefault().getActiveShell(), 8192);
        saveFileDialog.setFileName(this.project.getName());
        saveFileDialog.setFilterExtensions(new String[]{"*.zip"});
        String filePath = saveFileDialog.open();
        if (filePath != null) {
            if (!filePath.endsWith(DEFAULT_BACKUP_FILE_EXTENSION)) {
                filePath = String.valueOf(filePath) + DEFAULT_BACKUP_FILE_EXTENSION;
            }
            if (this.isFileOk(filePath)) {
                this.backupFilePath = filePath;
                this.backupFilePathText.setText(this.backupFilePath);
            }
        }
        this.getContainer().updateButtons();
    }

    private boolean isFileOk(String filePath) {
        if (Files.exists(Paths.get(filePath, new String[0]), LinkOption.NOFOLLOW_LINKS)) {
            return MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.DetachSdkActionsSelectionFile_already_exist, (String)String.format(Messages.DetachSdkActionsSelectionFile_overwrite, filePath));
        }
        return true;
    }
}

