/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.ui.exports;

import com.nxp.s32ds.cle.cdt.sdk.internal.ui.Messages;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import java.io.File;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class SdkExportDialog
extends TitleAreaDialog {
    public static final String FORBIDDEN_CHARS = "#;=,:@*?<>\\|\"' {}[]()`&$%";
    private SdkDescriptor sdkDescriptor;
    private String location;
    private boolean withContent;
    private boolean needsOverwrite = false;
    private Text locationField;
    private Button withContentButton;
    private final String standardMessage;

    public SdkExportDialog(Shell parentShell, SdkDescriptor sdkDescriptor) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.sdkDescriptor = sdkDescriptor;
        this.standardMessage = Messages.SdkExportDialog_header_text;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.SdkExportDialog_title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)parentComposite);
        Composite contents = this.createComposite(parentComposite);
        Dialog.applyDialogFont((Control)parentComposite);
        return contents;
    }

    private Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        GridData data = new GridData(1808);
        data.widthHint = 500;
        composite.setLayoutData((Object)data);
        Label locationLabel = new Label(composite, 16384);
        locationLabel.setText(Messages.SdkExportDialog_label_to_archive);
        locationLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.locationField = new Text(composite, 2060);
        this.locationField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.locationField.setToolTipText(Messages.SdkExportDialog_use_browse);
        this.locationField.addModifyListener(e -> this.updateButtonsState());
        Button folderButton = new Button(composite, 8);
        folderButton.setText(Messages.SdkDialog_browse_button_text);
        folderButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        folderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selectedLocation = SdkExportDialog.this.selectFolder();
                if (selectedLocation != null) {
                    SdkExportDialog.this.locationField.setText(String.format("%s%s%s_%s.zip", selectedLocation, selectedLocation.endsWith(FileSystems.getDefault().getSeparator()) ? "" : FileSystems.getDefault().getSeparator(), SdkExportDialog.this.sdkDescriptor.getName(), SdkExportDialog.this.sdkDescriptor.getVersion()));
                }
                SdkExportDialog.this.updateButtonsState();
            }
        });
        this.setButtonLayoutData(folderButton);
        Group options = new Group(composite, 16);
        options.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        options.setText(Messages.SdkExportDialog_label_options);
        options.setLayout((Layout)new GridLayout(1, true));
        this.withContentButton = new Button((Composite)options, 32);
        this.withContentButton.setText(Messages.SdkExportDialog_label_export_only_sdk_descriptor);
        this.withContentButton.setSelection(false);
        this.setButtonLayoutData(this.withContentButton);
        this.setTitle(Messages.SdkExportDialog_title);
        this.setMessage(this.standardMessage);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.freescale.s32ds.cross.sdk.support.SDK_export_context");
        return composite;
    }

    private String selectFolder() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 0x10000000);
        dialog.setText(Messages.SdkDialog_folder_selection_dialog_title);
        dialog.setMessage(Messages.SdkDialog_folder_selection_dialog_message);
        return dialog.open();
    }

    private void updateButtonsState() {
        this.needsOverwrite = false;
        this.getButton(0).setEnabled(this.validateLocation(this.locationField.getText()));
    }

    public void create() {
        super.create();
        this.updateButtonsState();
    }

    protected void okPressed() {
        if (this.needsOverwrite && !MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.SdkExportDialog_error_file_already_exists, (String)Messages.SdkExportDialog_overwrite)) {
            return;
        }
        this.location = this.locationField.getText();
        this.withContent = !this.withContentButton.getSelection();
        super.okPressed();
    }

    public String location() {
        return this.location;
    }

    public boolean withContent() {
        return this.withContent;
    }

    private boolean validateLocation(String location) {
        File f;
        if (location.isEmpty()) {
            this.setMessage(Messages.SdkExportDialog_use_browse);
            this.getButton(0).setEnabled(false);
            return false;
        }
        this.setErrorMessage(null);
        location.chars().filter(c -> FORBIDDEN_CHARS.indexOf(c) != -1 && c != 58 && c != 92 && c != 32).findFirst().ifPresent(c -> this.setErrorMessage(NLS.bind((String)Messages.SdkExportDialog_error_achive_path_name_has_illegal_symbols, (Object)Character.valueOf((char)c))));
        if (this.getErrorMessage() == null && (f = new File(location)).exists()) {
            if (f.isFile() && f.canWrite()) {
                this.setMessage(Messages.SdkExportDialog_error_file_exists_and_will_be_overriden, 2);
                this.needsOverwrite = true;
                return true;
            }
            this.setErrorMessage(Messages.SdkExportDialog_error_file_exists_and_cannot_be_overriden);
        }
        if (this.getErrorMessage() == null) {
            try {
                String canonicalPath = new File(location).getCanonicalPath();
                this.setMessage(canonicalPath);
                Files.createFile(Paths.get(canonicalPath, new String[0]), new FileAttribute[0]);
                Files.delete(Paths.get(canonicalPath, new String[0]));
                return true;
            }
            catch (AccessDeniedException accessDeniedException) {
                this.setErrorMessage(Messages.SdkExportDialog_error_file_access_denied);
            }
            catch (IOException ioe) {
                this.setErrorMessage(NLS.bind((String)Messages.SdkExportDialog_error_file_cannot_be_created, (Object)ioe.getMessage()));
            }
        }
        if (this.getErrorMessage() != null) {
            this.getButton(0).setEnabled(false);
            return false;
        }
        return true;
    }
}

