/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.bootimage.controller;

import com.nxp.swtools.bootimage.mcu.EmptyMcu;
import com.nxp.swtools.bootimage.mcu.IMcu;
import com.nxp.swtools.bootimage.utils.ABootProblemsManager;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.controller.AController;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.storage.StorageTool;
import com.nxp.swtools.utils.resources.DataDirectoryUtils;
import com.nxp.swtools.utils.scripting.ScriptResult;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.beans.property.SimpleBooleanProperty;

@NonNullByDefault
public abstract class ABootController
extends AController {
    @Nullable
    private IMcu mcu = null;
    private final ISharedConfiguration sharedConfig = SharedConfigurationFactory.getSharedConfigurationSingleton();
    private SimpleBooleanProperty isDisposed = new SimpleBooleanProperty(false);
    protected SimpleBooleanProperty isEnabled = new SimpleBooleanProperty(true);
    private SimpleBooleanProperty isOn = new SimpleBooleanProperty();
    private ScriptResult generatedCode = new ScriptResult.Builder().build();
    private SimpleBooleanProperty isSaved = new SimpleBooleanProperty(false);
    private AtomicBoolean shouldUpdateConfiguration = new AtomicBoolean(true);
    @Nullable
    private Object configurationUpdateSource = null;
    @Nullable
    protected ABootProblemsManager<?> problemsManager;

    protected abstract IMcu getMcuFromSharedConfig(ISharedConfiguration var1);

    protected abstract void reloadFromSharedConfig(ISharedConfiguration var1);

    public abstract void handleSettingChange(int var1, @Nullable Object var2, @Nullable String var3);

    protected abstract StorageTool storeTool();

    public abstract void disableEnableToolScene();

    public abstract void resetToProcessorDefaults();

    public @Nullable IMcu getMcu() {
        return this.mcu;
    }

    public void setMcu(IMcu mcu) {
        this.mcu = mcu;
    }

    public ISharedConfiguration getSharedConfig() {
        return this.sharedConfig;
    }

    public SimpleBooleanProperty isDisposed() {
        return this.isDisposed;
    }

    public void setDisposed(boolean value) {
        this.isDisposed.set(value);
    }

    public SimpleBooleanProperty isToolEnabled() {
        return this.isEnabled;
    }

    public void setToolEnabled(boolean value) {
        this.isEnabled.set(value);
    }

    public SimpleBooleanProperty isToolOn() {
        return this.isOn;
    }

    public void setToolOn(boolean value) {
        this.isOn.set(value);
    }

    public ScriptResult getGeneratedCode() {
        return this.generatedCode;
    }

    public void setGeneratedCode(ScriptResult generatedCode) {
        this.generatedCode = generatedCode;
    }

    public SimpleBooleanProperty isSaved() {
        return this.isSaved;
    }

    public void setSaved(boolean value) {
        this.isSaved.set(value);
    }

    public AtomicBoolean getShouldUpdateConfiguration() {
        return this.shouldUpdateConfiguration;
    }

    public void setShouldUpdateConfiguration(boolean value) {
        this.shouldUpdateConfiguration.set(value);
    }

    public static boolean isMcuSupported(IMcu mcuToCheck) {
        return !(mcuToCheck instanceof EmptyMcu);
    }

    public boolean isMcuSupported(IMcuIdentification mcuId, String fileType) {
        return !UtilsText.isEmpty((String)DataDirectoryUtils.getDbFile((IMcuIdentification)mcuId, (String)fileType));
    }

    public synchronized void stateShouldUpdate(Object source, boolean shouldUpdate) {
        if (this.configurationUpdateSource == null) {
            this.configurationUpdateSource = source;
        } else if (source.equals(this.configurationUpdateSource)) {
            this.configurationUpdateSource = null;
        } else {
            return;
        }
        this.shouldUpdateConfiguration.set(shouldUpdate);
    }
}

