/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.bootimage.settings;

import com.nxp.swtools.bootimage.settings.ABaseComponentSetting;
import com.nxp.swtools.bootimage.settings.Description;
import com.nxp.swtools.bootimage.settings.ImageSegment;
import com.nxp.swtools.bootimage.settings.MessagesSetting;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.number.NumberFormatValidator;
import javafx.beans.property.SimpleIntegerProperty;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Root;

@Root(name="input", strict=false)
public class InputSetting
extends ABaseComponentSetting {
    @Attribute(name="offset", required=false)
    private String offset;
    private SimpleIntegerProperty sizeProperty;
    @Nullable
    private ImageSegment imageSegment;
    @Attribute(name="byte_order", required=false)
    private String byteOrder = "be";

    public InputSetting(String id, String label, @Nullable Description description, String offset, SimpleIntegerProperty sizeProperty, String byteOrder, String options, @Nullable MessagesSetting messages) {
        super(id, label, description, "", options, messages, -1L, "");
        this.offset = offset;
        this.sizeProperty = sizeProperty;
        this.imageSegment = null;
        this.byteOrder = byteOrder;
    }

    public InputSetting() {
        this.offset = "";
        this.sizeProperty = new SimpleIntegerProperty();
        this.imageSegment = null;
    }

    public SimpleIntegerProperty getSizeProperty() {
        return this.sizeProperty;
    }

    public void setSize(int size) {
        this.sizeProperty.set(size);
    }

    public int getOffsetValue() {
        int offsetVal = 0;
        if (NumberFormatValidator.isValidXmlHexFormat((String)this.offset)) {
            offsetVal = NumberFormatValidator.getDecimalIntegerFromXmlHex((String)this.offset);
        } else if (NumberFormatValidator.isValidDecimal((String)this.offset)) {
            offsetVal = NumberFormatValidator.getIntFromStringDecimal((String)this.offset);
        }
        return offsetVal;
    }

    public void setImageSegment(ImageSegment imageSegment) {
        this.imageSegment = imageSegment;
    }

    public @Nullable ImageSegment getImageSegment() {
        return this.imageSegment;
    }

    public String getByteOrder() {
        return this.byteOrder;
    }
}

