/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.bootimage.settings;

import com.nxp.swtools.bootimage.settings.ABaseComponentSetting;
import com.nxp.swtools.bootimage.settings.Description;
import com.nxp.swtools.bootimage.settings.MessagesSetting;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.number.NumberFormatValidator;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Root;

@Root(name="limit_values", strict=false)
public class LimitValuesSetting
extends ABaseComponentSetting {
    @Attribute(name="min_value")
    private String minValue;
    @Attribute(name="max_value")
    private String maxValue;
    @Attribute(name="min_value_expr", required=false)
    private String minValueExpr;
    @Attribute(name="max_value_expr", required=false)
    private String maxValueExpr;

    public LimitValuesSetting(String id, String label, @Nullable Description description, String minValue, String maxValue, String minValueExpr, String maxValueExpr, String options, @Nullable MessagesSetting messages) {
        super(id, label, description, "", options, messages, -1L, "");
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.minValueExpr = minValueExpr;
        this.maxValueExpr = maxValueExpr;
    }

    public LimitValuesSetting() {
        this.minValue = "";
        this.maxValue = "";
        this.minValueExpr = "";
        this.maxValueExpr = "";
    }

    public String getMinValue() {
        return this.minValue;
    }

    public String getMaxValue() {
        return this.maxValue;
    }

    public long getMinLimitValue() {
        long value = 0L;
        if (NumberFormatValidator.isValidXmlHexFormat((String)this.minValue)) {
            value = NumberFormatValidator.getDecimalLongFromXmlHex((String)this.minValue);
        } else if (NumberFormatValidator.isValidDecimal((String)this.minValue)) {
            value = NumberFormatValidator.getLongFromStringDecimal((String)this.minValue);
        }
        return value;
    }

    public long getMaxLimitValue() {
        long value = 0L;
        if (NumberFormatValidator.isValidXmlHexFormat((String)this.maxValue)) {
            value = NumberFormatValidator.getDecimalLongFromXmlHex((String)this.maxValue);
        } else if (NumberFormatValidator.isValidDecimal((String)this.maxValue)) {
            value = NumberFormatValidator.getLongFromStringDecimal((String)this.maxValue);
        }
        return value;
    }

    public String getMinValueExpression() {
        return this.minValueExpr;
    }

    public String getMaxValueExpression() {
        return this.maxValueExpr;
    }
}

