/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.bootimage.settings;

import com.nxp.swtools.bootimage.settings.ABaseComponentSetting;
import com.nxp.swtools.bootimage.settings.ABaseCustomComponentSetting;
import com.nxp.swtools.bootimage.settings.ArraySetting;
import com.nxp.swtools.bootimage.settings.BoolSetting;
import com.nxp.swtools.bootimage.settings.CommandsTable;
import com.nxp.swtools.bootimage.settings.Description;
import com.nxp.swtools.bootimage.settings.EnumSetting;
import com.nxp.swtools.bootimage.settings.ImageSegment;
import com.nxp.swtools.bootimage.settings.InputFileSetting;
import com.nxp.swtools.bootimage.settings.InputSetting;
import com.nxp.swtools.bootimage.settings.IntegerSetting;
import com.nxp.swtools.bootimage.settings.LayoutSetting;
import com.nxp.swtools.bootimage.settings.MessagesSetting;
import com.nxp.swtools.bootimage.settings.ReservedSetting;
import com.nxp.swtools.bootimage.settings.TextSetting;
import com.nxp.swtools.bootimage.utils.BootXmlConstants;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.number.NumberFormatValidator;
import com.nxp.swtools.common.utils.number.NumberFormatter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Root(name="struct", strict=false)
public class StructSetting
extends ABaseCustomComponentSetting {
    @ElementList(inline=true, required=false)
    private List<BoolSetting> boolSettingList = new ArrayList<BoolSetting>();
    @ElementList(inline=true, required=false)
    private List<EnumSetting> enumSettingList = new ArrayList<EnumSetting>();
    @ElementList(inline=true, required=false)
    private List<IntegerSetting> integerSettingList = new ArrayList<IntegerSetting>();
    private ImageSegment imageSegment;
    @ElementList(inline=true, required=false)
    private List<StructSetting> structSettingList = new ArrayList<StructSetting>();
    @ElementList(inline=true, required=false)
    private List<InputSetting> inputSettingList = new ArrayList<InputSetting>();
    @ElementList(inline=true, required=false)
    private List<InputFileSetting> inputFiles = new ArrayList<InputFileSetting>();
    @ElementList(inline=true, required=false)
    private List<ArraySetting> arraySettingList = new ArrayList<ArraySetting>();
    @ElementList(inline=true, required=false)
    private List<TextSetting> textSettingList = new ArrayList<TextSetting>();
    @Attribute(name="byte_order", required=false)
    private String byteOrder = "be";
    @Attribute(name="reset", required=false)
    private boolean reset = true;
    @Element(name="layout", required=false)
    @Nullable
    private @Element(name="layout", required=false) @Nullable LayoutSetting layoutSetting;
    @Element(name="reserved", required=false)
    @Nullable
    private @Element(name="reserved", required=false) @Nullable ReservedSetting reserved;
    @Attribute(name="reserved_property", required=false)
    @Nullable
    private @Attribute(name="reserved_property", required=false) @Nullable String reservedProperty;
    @Attribute(name="default_memory_value", required=false)
    @Nullable
    private @Attribute(name="default_memory_value", required=false) @Nullable String defaultMemValue;
    @Element(name="commands", required=false)
    @Nullable
    private @Element(name="commands", required=false) @Nullable CommandsTable commandsTable;

    public StructSetting(String id, String label, @Nullable Description description, String offset, String size, String value, String byteOrder, String options, @Nullable MessagesSetting messages, @Nullable String defaultMemValue, @Nullable CommandsTable commandsTable) {
        super(id, label, description, offset, size, value, -1L, options, messages, null, "");
        this.imageSegment = new ImageSegment(id, 0, 0, null);
        this.byteOrder = byteOrder;
        this.defaultMemValue = defaultMemValue;
        this.commandsTable = commandsTable;
    }

    public StructSetting() {
        this.commandsTable = null;
        this.defaultMemValue = null;
        this.imageSegment = new ImageSegment(this.getId(), this.getOffsetValue(), this.getSizeValueInBytes(), ByteBuffer.wrap(this.getBufferToWrite((byte)-1)));
    }

    public List<BoolSetting> getBoolSettingList() {
        return this.boolSettingList;
    }

    public @Nullable BoolSetting getBoolSettingById(String id) {
        for (BoolSetting boolSetting : this.boolSettingList) {
            if (!boolSetting.getId().equals(id)) continue;
            return boolSetting;
        }
        return null;
    }

    public List<EnumSetting> getEnumSettingList() {
        return this.enumSettingList;
    }

    public @Nullable EnumSetting getEnumSettingById(String id) {
        for (EnumSetting enumSetting : this.enumSettingList) {
            if (!enumSetting.getId().equals(id)) continue;
            return enumSetting;
        }
        return null;
    }

    public List<IntegerSetting> getIntegerSettingList() {
        return this.integerSettingList;
    }

    public @Nullable IntegerSetting getIntegerSettingById(String id) {
        for (IntegerSetting integerSetting : this.integerSettingList) {
            if (!integerSetting.getId().equals(id)) continue;
            return integerSetting;
        }
        return null;
    }

    public List<StructSetting> getStructSettingList() {
        return this.structSettingList;
    }

    public List<InputSetting> getInputSettingList() {
        return this.inputSettingList;
    }

    public @Nullable InputSetting getInputSettingById(String id) {
        for (InputSetting inputSetting : this.inputSettingList) {
            if (!inputSetting.getId().equals(id)) continue;
            return inputSetting;
        }
        return null;
    }

    public List<InputFileSetting> getInputFiles() {
        return this.inputFiles;
    }

    public @Nullable InputFileSetting getInputFileById(String id) {
        for (InputFileSetting inputFile : this.inputFiles) {
            if (!inputFile.getId().equals(id)) continue;
            return inputFile;
        }
        return null;
    }

    public List<ArraySetting> getArraySettingList() {
        return this.arraySettingList;
    }

    public @Nullable ArraySetting getArraySettingById(String id) {
        for (ArraySetting arraySetting : this.arraySettingList) {
            if (!arraySetting.getId().equals(id)) continue;
            return arraySetting;
        }
        return null;
    }

    public List<TextSetting> getTextSettingList() {
        return this.textSettingList;
    }

    public void setTextSettingList(List<TextSetting> textSettingList) {
        this.textSettingList = textSettingList;
    }

    public @Nullable TextSetting getTextSettingById(String id) {
        for (TextSetting textSetting : this.textSettingList) {
            if (!textSetting.getId().equals(id)) continue;
            return textSetting;
        }
        return null;
    }

    public ImageSegment getImageSegment() {
        return this.imageSegment;
    }

    public void setImageSegment(ImageSegment imageSegment) {
        this.imageSegment = imageSegment;
    }

    public byte[] getBufferToWrite(byte defaultValue) {
        ByteBuffer bufferToWrite = ByteBuffer.allocate(0);
        if (!this.getOffset().equals("") && !this.getSize().equals("")) {
            bufferToWrite = ByteBuffer.allocate(this.getSizeValueInBytes());
            Arrays.fill(bufferToWrite.array(), defaultValue);
            long currentValueToWrite = 0L;
            for (EnumSetting enumSetting : this.getEnumSettingList()) {
                if (enumSetting.getOffset().equals("") || enumSetting.getSize().equals("")) continue;
                if (BootXmlConstants.SIZE_BIT_UNIT_VALUE_REGEXP.matcher(enumSetting.getSize()).matches()) {
                    currentValueToWrite = currentValueToWrite + (enumSetting.getValueToWrite() << enumSetting.getOffsetValue() - enumSetting.getSizeValueInBits() + 1) & 0xFFFFFFFFFFFFFFFFL;
                    continue;
                }
                if (!BootXmlConstants.SIZE_BYTE_UNIT_VALUE_REGEXP.matcher(enumSetting.getSize()).matches()) continue;
                currentValueToWrite = currentValueToWrite + (enumSetting.getValueToWrite() << (this.getSizeValueInBytes() - (enumSetting.getOffsetValue() + enumSetting.getSizeValueInBytes())) * 8) & 0xFFFFFFFFFFFFFFFFL;
            }
            for (BoolSetting boolSetting : this.getBoolSettingList()) {
                if (boolSetting.getOffset().equals("") || boolSetting.getSize().equals("")) continue;
                if (BootXmlConstants.SIZE_BIT_UNIT_VALUE_REGEXP.matcher(boolSetting.getSize()).matches()) {
                    currentValueToWrite = currentValueToWrite + (boolSetting.getValueToWrite() << boolSetting.getOffsetValue()) & 0xFFFFFFFFFFFFFFFFL;
                    continue;
                }
                if (!BootXmlConstants.SIZE_BYTE_UNIT_VALUE_REGEXP.matcher(boolSetting.getSize()).matches()) continue;
                currentValueToWrite = currentValueToWrite + (boolSetting.getValueToWrite() << (this.getSizeValueInBytes() - (boolSetting.getOffsetValue() + boolSetting.getSizeValueInBytes())) * 8) & 0xFFFFFFFFFFFFFFFFL;
            }
            for (IntegerSetting integerSetting : this.getIntegerSettingList()) {
                if (integerSetting.getOffset().equals("") || integerSetting.getSize().equals("")) continue;
                if (BootXmlConstants.SIZE_BIT_UNIT_VALUE_REGEXP.matcher(integerSetting.getSize()).matches()) {
                    currentValueToWrite = currentValueToWrite + (integerSetting.getValueToWrite() << integerSetting.getOffsetValue() - integerSetting.getSizeValueInBits() + 1) & 0xFFFFFFFFFFFFFFFFL;
                    continue;
                }
                if (!BootXmlConstants.SIZE_BYTE_UNIT_VALUE_REGEXP.matcher(integerSetting.getSize()).matches()) continue;
                currentValueToWrite = currentValueToWrite + (integerSetting.getValueToWrite() << (this.getSizeValueInBytes() - (integerSetting.getOffsetValue() + integerSetting.getSizeValueInBytes())) * 8) & 0xFFFFFFFFFFFFFFFFL;
            }
            ByteBuffer intermediateBuff = ByteBuffer.allocate(8).putLong(currentValueToWrite);
            if (intermediateBuff.capacity() >= this.getSizeValueInBytes()) {
                int i = 0;
                while (i < this.getSizeValueInBytes()) {
                    bufferToWrite.put(this.getSizeValueInBytes() - 1 - i, intermediateBuff.get(7 - i));
                    ++i;
                }
            }
            for (InputFileSetting inputFile : this.getInputFiles()) {
                ImageSegment inputFileImageSeg = inputFile.getImageSegment();
                if (inputFile.getOffset().equals("") || inputFile.getSizeProperty().get() <= 0 || inputFileImageSeg == null || inputFileImageSeg.getBufferToWrite() == null) continue;
                int inputFileOffset = inputFile.getOffsetValue();
                int inputFileSize = inputFile.getSizeProperty().get();
                ByteBuffer inputFileBuffer = inputFileImageSeg.getBufferToWrite();
                if (inputFileBuffer == null) continue;
                int i = 0;
                while (i < inputFileSize) {
                    bufferToWrite.put(inputFileOffset + i, inputFileBuffer.get(i));
                    ++i;
                }
            }
            for (BoolSetting boolSetting : this.getBoolSettingList()) {
                ByteBuffer boolByteBuffer = boolSetting.getBytesToWrite();
                if (boolByteBuffer == null || !boolSetting.getCurrentSelection()) continue;
                int i = 0;
                while (i < boolByteBuffer.capacity()) {
                    bufferToWrite.put(boolSetting.getOffsetValue() + i, boolByteBuffer.get(i));
                    ++i;
                }
            }
        }
        return NumberFormatter.convertEndianness((byte[])Objects.requireNonNull(bufferToWrite.array()), (int)this.getSizeValueInBytes(), (String)this.byteOrder);
    }

    public boolean areAllComponentsDisabled() {
        for (EnumSetting enumSetting : this.getEnumSettingList()) {
            if (enumSetting.getCurrentDisableState().get()) continue;
            return false;
        }
        for (BoolSetting boolSetting : this.getBoolSettingList()) {
            if (boolSetting.getCurrentDisableState().get()) continue;
            return false;
        }
        for (IntegerSetting integerSetting : this.getIntegerSettingList()) {
            if (integerSetting.getCurrentDisableState().get()) continue;
            return false;
        }
        for (InputFileSetting inputFile : this.getInputFiles()) {
            if (inputFile.getCurrentDisableState().get()) continue;
            return false;
        }
        return true;
    }

    public void setByteOrder(String byteOrder) {
        this.byteOrder = byteOrder;
    }

    public String getByteOrder() {
        return this.byteOrder;
    }

    public boolean isReset() {
        return this.reset;
    }

    public void setReset(boolean reset) {
        this.reset = reset;
    }

    public @Nullable LayoutSetting getLayoutSetting() {
        return this.layoutSetting;
    }

    public @Nullable ReservedSetting getReservedSettings() {
        return this.reserved;
    }

    public @Nullable String getReservedPropertyValue() {
        return this.reservedProperty;
    }

    public List<ABaseComponentSetting> getChildComponents() {
        ArrayList<ABaseComponentSetting> scalarComponents = new ArrayList<ABaseComponentSetting>();
        this.boolSettingList.forEach(setting -> {
            boolean bl = scalarComponents.add((ABaseComponentSetting)setting);
        });
        this.enumSettingList.forEach(setting -> {
            boolean bl = scalarComponents.add((ABaseComponentSetting)setting);
        });
        this.integerSettingList.forEach(setting -> {
            boolean bl = scalarComponents.add((ABaseComponentSetting)setting);
        });
        this.structSettingList.forEach(setting -> {
            boolean bl = scalarComponents.add((ABaseComponentSetting)setting);
        });
        this.inputSettingList.forEach(setting -> {
            boolean bl = scalarComponents.add((ABaseComponentSetting)setting);
        });
        this.inputFiles.forEach(setting -> {
            boolean bl = scalarComponents.add((ABaseComponentSetting)setting);
        });
        this.arraySettingList.forEach(setting -> {
            boolean bl = scalarComponents.add((ABaseComponentSetting)setting);
        });
        this.textSettingList.forEach(setting -> {
            boolean bl = scalarComponents.add((ABaseComponentSetting)setting);
        });
        return scalarComponents;
    }

    public @Nullable ABaseComponentSetting getScalarComponentById(String id) {
        for (ABaseComponentSetting scalarSetting : this.getChildComponents()) {
            if (!scalarSetting.getId().equals(id)) continue;
            return scalarSetting;
        }
        return null;
    }

    public @Nullable ABaseComponentSetting getScalarComponentThatMatchesId(StructSetting parentStruct, String id) {
        for (ABaseComponentSetting scalarSetting : parentStruct.getChildComponents()) {
            if (!scalarSetting.getId().contains(id)) continue;
            return scalarSetting;
        }
        return null;
    }

    public @Nullable String getDefaultMemValue() {
        return this.defaultMemValue;
    }

    public long getDefaultMemoryValue() {
        String defaultMemoryValue = this.getDefaultMemValue();
        if (defaultMemoryValue == null) {
            return -1L;
        }
        long value = 0L;
        if (NumberFormatValidator.isValidXmlHexFormat((String)defaultMemoryValue)) {
            value = NumberFormatValidator.getDecimalLongFromXmlHex((String)defaultMemoryValue);
        } else if (NumberFormatValidator.isValidDecimal((String)defaultMemoryValue)) {
            value = NumberFormatValidator.getLongFromStringDecimal((String)defaultMemoryValue);
        } else if (NumberFormatValidator.isValidXmlBinaryFormat((String)defaultMemoryValue)) {
            value = NumberFormatValidator.getDecimalIntegerFromXmlBinary((String)defaultMemoryValue);
        }
        return value;
    }

    public @Nullable CommandsTable getCommandsTable() {
        return this.commandsTable;
    }
}

